/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.sdp;

import org.mobicents.media.server.impl.rtp.sdp.RTPFormat;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormats;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.utils.Text;

public class AVProfile {
    public static final Text AUDIO = new Text("audio");
    public static final Text VIDEO = new Text("video");
    public static final int telephoneEventsID = 101;
    public static final int telephoneEvent126 = 126;
    public static final AudioFormat telephoneEvent = FormatFactory.createAudioFormat((String)"telephone-event", (int)8000);
    public static final RTPFormats audio;
    public static final RTPFormats video;
    public static final RTPFormats application;
    private static final RTPFormat pcmu;
    private static final RTPFormat pcma;
    private static final RTPFormat gsm;
    private static final RTPFormat g729;
    private static final RTPFormat l16;
    private static final RTPFormat dtmf;
    private static final RTPFormat dtmf126;
    private static final RTPFormat ilbc;
    private static final RTPFormat linear;
    private static final RTPFormat H261;
    private static final RTPFormat H263;
    private static final RTPFormat MP4V_ES;

    public static RTPFormat getFormat(int p) {
        RTPFormat res = audio.find(p);
        return res == null ? video.find(p) : res;
    }

    public static RTPFormat getFormat(int p, Text mediaType) {
        RTPFormat res = null;
        if (mediaType.equals((Object)AUDIO)) {
            res = audio.find(p);
        } else if (mediaType.equals((Object)VIDEO)) {
            res = video.find(p);
        }
        return res;
    }

    static {
        telephoneEvent.setOptions(new Text("0-15"));
        audio = new RTPFormats();
        video = new RTPFormats();
        application = new RTPFormats();
        pcmu = new RTPFormat(0, (Format)FormatFactory.createAudioFormat((String)"pcmu", (int)8000, (int)8, (int)1), 8000);
        pcma = new RTPFormat(8, (Format)FormatFactory.createAudioFormat((String)"pcma", (int)8000, (int)8, (int)1), 8000);
        gsm = new RTPFormat(3, (Format)FormatFactory.createAudioFormat((String)"gsm", (int)8000), 8000);
        g729 = new RTPFormat(18, (Format)FormatFactory.createAudioFormat((String)"g729", (int)8000), 8000);
        l16 = new RTPFormat(97, (Format)FormatFactory.createAudioFormat((String)"l16", (int)8000, (int)16, (int)1), 8000);
        dtmf = new RTPFormat(101, (Format)telephoneEvent, 8000);
        dtmf126 = new RTPFormat(126, (Format)telephoneEvent, 8000);
        ilbc = new RTPFormat(102, (Format)FormatFactory.createAudioFormat((String)"ilbc", (int)8000, (int)16, (int)1), 8000);
        linear = new RTPFormat(150, (Format)FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1), 8000);
        H261 = new RTPFormat(45, (Format)FormatFactory.createVideoFormat((String)"h261"));
        H263 = new RTPFormat(34, (Format)FormatFactory.createVideoFormat((String)"h263"));
        MP4V_ES = new RTPFormat(96, (Format)FormatFactory.createVideoFormat((String)"mp4v-es"));
        audio.add(pcma);
        audio.add(pcmu);
        audio.add(gsm);
        audio.add(g729);
        audio.add(l16);
        audio.add(ilbc);
        audio.add(dtmf);
        audio.add(dtmf126);
        video.add(H261);
        video.add(H263);
        video.add(MP4V_ES);
    }
}

