/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.crypto;

import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtp.crypto.PacketTransformer;
import org.mobicents.media.server.impl.rtp.crypto.RawPacket;
import org.mobicents.media.server.impl.rtp.crypto.SRTPCryptoContext;
import org.mobicents.media.server.impl.rtp.crypto.SRTPTransformEngine;

public class SRTPTransformer
implements PacketTransformer {
    private static final Logger logger = Logger.getLogger(SRTPTransformer.class);
    private final RawPacket rawPacket;
    private SRTPTransformEngine forwardEngine;
    private SRTPTransformEngine reverseEngine;
    private Hashtable<Long, SRTPCryptoContext> contexts;

    public SRTPTransformer(SRTPTransformEngine engine) {
        this(engine, engine);
    }

    public SRTPTransformer(SRTPTransformEngine forwardEngine, SRTPTransformEngine reverseEngine) {
        this.forwardEngine = forwardEngine;
        this.reverseEngine = reverseEngine;
        this.contexts = new Hashtable();
        this.rawPacket = new RawPacket();
    }

    @Override
    public byte[] transform(byte[] pkt) {
        return this.transform(pkt, 0, pkt.length);
    }

    @Override
    public byte[] transform(byte[] pkt, int offset, int length) {
        this.rawPacket.wrap(pkt, offset, length);
        long ssrc = this.rawPacket.getSSRC();
        SRTPCryptoContext context = this.contexts.get(ssrc);
        if (context == null) {
            context = this.forwardEngine.getDefaultContext().deriveContext(ssrc, 0, 0L);
            context.deriveSrtpKeys(0L);
            this.contexts.put(ssrc, context);
        }
        context.transformPacket(this.rawPacket);
        return this.rawPacket.getData();
    }

    @Override
    public byte[] reverseTransform(byte[] pkt) {
        return this.reverseTransform(pkt, 0, pkt.length);
    }

    @Override
    public byte[] reverseTransform(byte[] pkt, int offset, int length) {
        boolean reversed;
        this.rawPacket.wrap(pkt, offset, length);
        long ssrc = this.rawPacket.getSSRC();
        SRTPCryptoContext context = this.contexts.get(ssrc);
        if (context == null) {
            context = this.reverseEngine.getDefaultContext().deriveContext(ssrc, 0, 0L);
            context.deriveSrtpKeys(this.rawPacket.getSequenceNumber());
            this.contexts.put(ssrc, context);
        }
        if (reversed = context.reverseTransformPacket(this.rawPacket)) {
            return this.rawPacket.getData();
        }
        return null;
    }

    @Override
    public void close() {
        this.forwardEngine.close();
        if (this.forwardEngine != this.reverseEngine) {
            this.reverseEngine.close();
        }
        for (Long ssrc : this.contexts.keySet()) {
            SRTPCryptoContext context = this.contexts.get(ssrc);
            if (context == null) continue;
            context.close();
            this.contexts.remove(ssrc);
        }
    }
}

