/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.crypto;

import org.mobicents.media.server.impl.rtp.crypto.SRTPPolicy;

public enum SRTPParameters {
    SRTP_AES128_CM_HMAC_SHA1_80(1, 1, 16, 1, 20, 10, 10, 14),
    SRTP_AES128_CM_HMAC_SHA1_32(2, 1, 16, 1, 20, 4, 10, 14),
    SRTP_NULL_HMAC_SHA1_80(5, 0, 0, 1, 20, 10, 10, 0),
    SRTP_NULL_HMAC_SHA1_32(6, 0, 0, 1, 20, 4, 10, 0);

    private int profile;
    private int encType;
    private int encKeyLength;
    private int authType;
    private int authKeyLength;
    private int authTagLength;
    private int rtcpAuthTagLength;
    private int saltLength;

    private SRTPParameters(int newProfile, int newEncType, int newEncKeyLength, int newAuthType, int newAuthKeyLength, int newAuthTagLength, int newRtcpAuthTagLength, int newSaltLength) {
        this.profile = newProfile;
        this.encType = newEncType;
        this.encKeyLength = newEncKeyLength;
        this.authType = newAuthType;
        this.authKeyLength = newAuthKeyLength;
        this.authTagLength = newAuthTagLength;
        this.rtcpAuthTagLength = newRtcpAuthTagLength;
        this.saltLength = newSaltLength;
    }

    public int getProfile() {
        return this.profile;
    }

    public int getCipherKeyLength() {
        return this.encKeyLength;
    }

    public int getCipherSaltLength() {
        return this.saltLength;
    }

    public static SRTPParameters getSrtpParametersForProfile(int profileValue) {
        switch (profileValue) {
            case 1: {
                return SRTP_AES128_CM_HMAC_SHA1_80;
            }
            case 2: {
                return SRTP_AES128_CM_HMAC_SHA1_32;
            }
            case 5: {
                return SRTP_NULL_HMAC_SHA1_80;
            }
            case 6: {
                return SRTP_NULL_HMAC_SHA1_32;
            }
        }
        throw new IllegalArgumentException("SRTP Protection Profile value %d is not allowed for DTLS SRTP. See http://tools.ietf.org/html/rfc5764#section-4.1.2 for valid values.");
    }

    public SRTPPolicy getSrtpPolicy() {
        SRTPPolicy sp = new SRTPPolicy(this.encType, this.encKeyLength, this.authType, this.authKeyLength, this.authTagLength, this.saltLength);
        return sp;
    }

    public SRTPPolicy getSrtcpPolicy() {
        SRTPPolicy sp = new SRTPPolicy(this.encType, this.encKeyLength, this.authType, this.authKeyLength, this.rtcpAuthTagLength, this.saltLength);
        return sp;
    }
}

