/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.crypto;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.mobicents.media.server.impl.rtp.crypto.PacketTransformer;
import org.mobicents.media.server.impl.rtp.crypto.RawPacket;
import org.mobicents.media.server.impl.rtp.crypto.SRTCPCryptoContext;
import org.mobicents.media.server.impl.rtp.crypto.SRTPTransformEngine;

public class SRTCPTransformer
implements PacketTransformer {
    private final RawPacket packet = new RawPacket();
    private SRTPTransformEngine forwardEngine;
    private SRTPTransformEngine reverseEngine;
    private Hashtable<Long, SRTCPCryptoContext> contexts;

    public SRTCPTransformer(SRTPTransformEngine engine) {
        this(engine, engine);
    }

    public SRTCPTransformer(SRTPTransformEngine forwardEngine, SRTPTransformEngine reverseEngine) {
        this.forwardEngine = forwardEngine;
        this.reverseEngine = reverseEngine;
        this.contexts = new Hashtable();
    }

    @Override
    public byte[] transform(byte[] pkt) {
        return this.transform(pkt, 0, pkt.length);
    }

    @Override
    public byte[] transform(byte[] pkt, int offset, int length) {
        this.packet.wrap(pkt, offset, length);
        long ssrc = this.packet.getRTCPSSRC();
        SRTCPCryptoContext context = this.contexts.get(ssrc);
        if (context == null) {
            context = this.forwardEngine.getDefaultContextControl().deriveContext(ssrc);
            context.deriveSrtcpKeys();
            this.contexts.put(ssrc, context);
        }
        context.transformPacket(this.packet);
        return this.packet.getData();
    }

    @Override
    public byte[] reverseTransform(byte[] pkt) {
        return this.reverseTransform(pkt, 0, pkt.length);
    }

    @Override
    public byte[] reverseTransform(byte[] pkt, int offset, int length) {
        boolean reversed;
        this.packet.wrap(pkt, offset, length);
        long ssrc = this.packet.getRTCPSSRC();
        SRTCPCryptoContext context = this.contexts.get(ssrc);
        if (context == null) {
            context = this.reverseEngine.getDefaultContextControl().deriveContext(ssrc);
            context.deriveSrtcpKeys();
            this.contexts.put(new Long(ssrc), context);
        }
        if (reversed = context.reverseTransformPacket(this.packet)) {
            return this.packet.getData();
        }
        return null;
    }

    @Override
    public void close() {
        this.forwardEngine.close();
        if (this.forwardEngine != this.reverseEngine) {
            this.reverseEngine.close();
        }
        Iterator<Map.Entry<Long, SRTCPCryptoContext>> iter = this.contexts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, SRTCPCryptoContext> entry = iter.next();
            SRTCPCryptoContext context = entry.getValue();
            iter.remove();
            if (context == null) continue;
            context.close();
        }
    }
}

