/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.crypto;

import java.nio.ByteBuffer;

public class RawPacket {
    public static final int EXT_HEADER_SIZE = 4;
    public static final int FIXED_HEADER_SIZE = 12;
    private ByteBuffer buffer = ByteBuffer.allocateDirect(8192);

    public RawPacket() {
    }

    public RawPacket(byte[] data, int offset, int length) {
        this.wrap(data, offset, length);
    }

    public void wrap(byte[] data, int offset, int length) {
        this.buffer.clear();
        this.buffer.rewind();
        this.buffer.put(data, offset, length);
        this.buffer.flip();
        this.buffer.rewind();
    }

    public byte[] getData() {
        this.buffer.rewind();
        byte[] data = new byte[this.buffer.limit()];
        this.buffer.get(data, 0, data.length);
        return data;
    }

    public void append(byte[] data, int len) {
        if (data == null || len <= 0 || len > data.length) {
            throw new IllegalArgumentException("Invalid combination of parameters data and length to append()");
        }
        int oldLimit = this.buffer.limit();
        this.grow(len);
        this.buffer.position(oldLimit);
        this.buffer.limit(oldLimit + len);
        this.buffer.put(data, 0, len);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public boolean getExtensionBit() {
        this.buffer.rewind();
        return (this.buffer.get() & 0x10) == 16;
    }

    public int getExtensionLength() {
        int length = 0;
        if (this.getExtensionBit()) {
            int extLenIndex = 12 + this.getCsrcCount() * 4 + 2;
            length = this.buffer.get(extLenIndex) << 8 | this.buffer.get(extLenIndex + 1) * 4;
        }
        return length;
    }

    public int getCsrcCount() {
        this.buffer.rewind();
        return this.buffer.get() & 0xF;
    }

    public int getHeaderLength() {
        int length = 12 + 4 * this.getCsrcCount();
        if (this.getExtensionBit()) {
            length += 4 + this.getExtensionLength();
        }
        return length;
    }

    public int getLength() {
        return this.buffer.limit();
    }

    public int getPaddingSize() {
        this.buffer.rewind();
        if ((this.buffer.get() & 0x20) == 0) {
            return 0;
        }
        return this.buffer.get(this.buffer.limit());
    }

    public byte[] getPayload() {
        return this.readRegion(this.getHeaderLength(), this.getPayloadLength());
    }

    public int getPayloadLength() {
        return this.getLength() - this.getHeaderLength();
    }

    public byte getPayloadType() {
        this.buffer.rewind();
        return (byte)(this.buffer.get(1) & 0x7F);
    }

    public int getRTCPSSRC() {
        return this.readInt(4);
    }

    public int getSequenceNumber() {
        return this.readUnsignedShortAsInt(2);
    }

    public int getSRTCPIndex(int authTagLen) {
        int offset = this.getLength() - (4 + authTagLen);
        return this.readInt(offset);
    }

    public int getSSRC() {
        return this.readInt(8);
    }

    public long getTimestamp() {
        return this.readInt(4);
    }

    public void grow(int delta) {
        if (delta == 0) {
            return;
        }
        int newLen = this.buffer.limit() + delta;
        if (newLen <= this.buffer.capacity()) {
            this.buffer.limit(newLen);
            return;
        }
        ByteBuffer newBuffer = this.buffer.isDirect() ? ByteBuffer.allocateDirect(newLen) : ByteBuffer.allocate(newLen);
        this.buffer.rewind();
        newBuffer.put(this.buffer);
        newBuffer.limit(newLen);
        this.buffer = newBuffer;
    }

    public int readInt(int off) {
        this.buffer.rewind();
        return (this.buffer.get(off++) & 0xFF) << 24 | (this.buffer.get(off++) & 0xFF) << 16 | (this.buffer.get(off++) & 0xFF) << 8 | this.buffer.get(off++) & 0xFF;
    }

    public byte[] readRegion(int off, int len) {
        this.buffer.rewind();
        if (off < 0 || len <= 0 || off + len > this.buffer.limit()) {
            return null;
        }
        byte[] region = new byte[len];
        this.buffer.get(region, off, len);
        return region;
    }

    public void readRegionToBuff(int off, int len, byte[] outBuff) {
        assert (off >= 0);
        assert (len > 0);
        assert (outBuff != null);
        assert (outBuff.length >= len);
        assert (this.buffer.limit() >= off + len);
        this.buffer.position(off);
        this.buffer.get(outBuff, 0, len);
    }

    public int readUnsignedShortAsInt(int off) {
        this.buffer.position(off);
        int b1 = 0xFF & this.buffer.get();
        int b2 = 0xFF & this.buffer.get();
        int val = b1 << 8 | b2;
        return val;
    }

    public long readUnsignedIntAsLong(int off) {
        this.buffer.position(off);
        return ((long)(this.buffer.get() & 0xFF) << 24 | (long)(this.buffer.get() & 0xFF) << 16 | (long)(this.buffer.get() & 0xFF) << 8 | (long)(this.buffer.get() & 0xFF)) & 0xFFFFFFFFL;
    }

    public void shrink(int delta) {
        if (delta <= 0) {
            return;
        }
        int newLimit = this.buffer.limit() - delta;
        if (newLimit <= 0) {
            newLimit = 0;
        }
        this.buffer.limit(newLimit);
    }
}

