/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp.channels;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.mobicents.media.io.ice.CandidatePair;
import org.mobicents.media.io.ice.IceAgent;
import org.mobicents.media.io.ice.IceAuthenticator;
import org.mobicents.media.io.ice.IceFactory;
import org.mobicents.media.io.ice.IceMediaStream;
import org.mobicents.media.io.ice.LocalCandidateWrapper;
import org.mobicents.media.io.ice.events.IceEventListener;
import org.mobicents.media.io.ice.events.SelectedCandidatesEvent;
import org.mobicents.media.io.ice.harvest.HarvestException;
import org.mobicents.media.server.impl.rtcp.RtcpChannel;
import org.mobicents.media.server.impl.rtp.ChannelsManager;
import org.mobicents.media.server.impl.rtp.RtpChannel;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpListener;
import org.mobicents.media.server.impl.rtp.SsrcGenerator;
import org.mobicents.media.server.impl.rtp.sdp.AVProfile;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormat;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormats;
import org.mobicents.media.server.impl.rtp.statistics.RtpStatistics;
import org.mobicents.media.server.io.network.PortManager;
import org.mobicents.media.server.io.sdp.fields.MediaDescriptionField;
import org.mobicents.media.server.scheduler.Clock;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.FormatNotSupportedException;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;

public abstract class MediaChannel {
    private static final Logger logger = Logger.getLogger(MediaChannel.class);
    private static final AudioFormat DTMF_FORMAT = FormatFactory.createAudioFormat((String)"telephone-event", (int)8000);
    private static final AudioFormat LINEAR_FORMAT = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    protected long ssrc = 0L;
    protected String cname;
    protected final String mediaType;
    protected RtpClock clock;
    protected RtpClock oobClock;
    protected RtpChannel rtpChannel;
    protected RtcpChannel rtcpChannel;
    protected boolean rtcpMux;
    protected RtpStatistics statistics;
    protected boolean open;
    protected RTPFormats supportedFormats;
    protected RTPFormats offeredFormats;
    protected RTPFormats negotiatedFormats;
    protected boolean negotiated;
    private RtpListener rtpListener;
    private boolean ice;
    private IceAgent iceAgent;
    private IceListener iceListener;
    private boolean dtls;

    protected MediaChannel(String mediaType, Clock wallClock, ChannelsManager channelsManager) {
        this.mediaType = mediaType;
        this.clock = new RtpClock(wallClock);
        this.oobClock = new RtpClock(wallClock);
        this.statistics = new RtpStatistics(this.clock, this.ssrc);
        this.rtpChannel = channelsManager.getRtpChannel(this.statistics, this.clock, this.oobClock);
        this.rtcpChannel = channelsManager.getRtcpChannel(this.statistics);
        this.offeredFormats = new RTPFormats();
        this.negotiatedFormats = new RTPFormats();
        this.negotiated = false;
        this.rtcpMux = false;
        this.ice = false;
        this.dtls = false;
        this.open = false;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public void setSsrc(long ssrc) {
        this.ssrc = ssrc;
    }

    public String getCname() {
        return this.cname;
    }

    public void setCname(String cname) {
        this.cname = cname;
        this.statistics.setCname(cname);
    }

    public String getRtpAddress() {
        if (this.rtpChannel.isBound()) {
            return this.rtpChannel.getLocalHost();
        }
        return "";
    }

    public int getRtpPort() {
        if (this.rtpChannel.isBound()) {
            return this.rtpChannel.getLocalPort();
        }
        return 0;
    }

    public String getRtcpAddress() {
        if (this.rtcpMux) {
            return this.getRtpAddress();
        }
        if (this.rtcpChannel.isBound()) {
            return this.rtcpChannel.getLocalHost();
        }
        return "";
    }

    public int getRtcpPort() {
        if (this.rtcpMux) {
            return this.getRtpPort();
        }
        if (this.rtcpChannel.isBound()) {
            return this.rtcpChannel.getLocalPort();
        }
        return 0;
    }

    public void open() {
        this.ssrc = SsrcGenerator.generateSsrc();
        this.open = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " is open"));
        }
    }

    public void close() throws IllegalStateException {
        if (this.open) {
            this.rtpChannel.close();
            if (!this.rtcpMux) {
                this.rtcpChannel.close();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " is closed"));
            }
        } else {
            throw new IllegalStateException("Channel is already inactive");
        }
        this.reset();
        this.open = false;
    }

    private void reset() {
        this.resetFormats();
        if (this.rtcpMux) {
            this.rtcpMux = false;
            this.rtpChannel.enableRtcpMux(false);
        }
        if (this.ice) {
            this.disableICE();
        }
        if (this.dtls) {
            this.disableDTLS();
        }
        this.statistics.reset();
        this.cname = "";
        this.ssrc = 0L;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isAvailable() {
        boolean available = this.rtpChannel.isAvailable();
        if (!this.rtcpMux) {
            available = available && this.rtcpChannel.isAvailable();
        }
        return available;
    }

    public void setRtpListener(RtpListener listener) {
        this.rtpListener = listener;
    }

    public void setInputDsp(Processor dsp) {
        this.rtpChannel.setInputDsp(dsp);
    }

    public Processor getInputDsp() {
        return this.rtpChannel.getInputDsp();
    }

    public void setOutputDsp(Processor dsp) {
        this.rtpChannel.setOutputDsp(dsp);
    }

    public Processor getOutputDsp() {
        return this.rtpChannel.getOutputDsp();
    }

    public void setConnectionMode(ConnectionMode mode) {
        this.rtpChannel.updateMode(mode);
    }

    protected void setFormats(RTPFormats formats) {
        try {
            this.rtpChannel.setFormatMap(formats);
            this.rtpChannel.setOutputFormats(formats.getFormats());
        }
        catch (FormatNotSupportedException e) {
            logger.warn((Object)"Could not set output formats", (Throwable)e);
        }
    }

    public RTPFormats getFormats() {
        if (this.negotiated) {
            return this.negotiatedFormats;
        }
        return this.supportedFormats;
    }

    public RTPFormats getFormatMap() {
        return this.rtpChannel.getFormatMap();
    }

    public void bind(boolean isLocal, boolean rtcpMux) throws IOException, IllegalStateException {
        if (this.ice) {
            throw new IllegalStateException("Cannot bind when ICE is enabled");
        }
        this.rtpChannel.bind(isLocal);
        if (!rtcpMux) {
            this.rtcpChannel.bind(isLocal, this.rtpChannel.getLocalPort() + 1);
        }
        this.rtcpMux = rtcpMux;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " RTP channel " + this.ssrc + " is bound to " + this.rtpChannel.getLocalHost() + ":" + this.rtpChannel.getLocalPort()));
            if (rtcpMux) {
                logger.debug((Object)(this.mediaType + " is multiplexing RTCP"));
            } else {
                logger.debug((Object)(this.mediaType + " RTCP channel " + this.ssrc + " is bound to " + this.rtcpChannel.getLocalHost() + ":" + this.rtcpChannel.getLocalPort()));
            }
        }
    }

    public boolean isRtcpMux() {
        return this.rtcpMux;
    }

    public void connectRtp(SocketAddress address) {
        this.rtpChannel.setRemotePeer(address);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " RTP channel " + this.ssrc + " connected to remote peer " + address.toString()));
        }
    }

    public void connectRtp(String address, int port) {
        this.connectRtp(new InetSocketAddress(address, port));
    }

    public void bindRtcp(boolean isLocal, int port) throws IOException, IllegalStateException {
        if (this.ice) {
            throw new IllegalStateException("Cannot bind when ICE is enabled");
        }
        this.rtcpChannel.bind(isLocal, port);
        this.rtcpMux = port == this.rtpChannel.getLocalPort();
    }

    public void connectRtcp(SocketAddress remoteAddress) {
        this.rtcpChannel.setRemotePeer(remoteAddress);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " RTCP channel " + this.ssrc + " has connected to remote peer " + remoteAddress.toString()));
        }
    }

    public void connectRtcp(String address, int port) {
        this.connectRtcp(new InetSocketAddress(address, port));
    }

    protected RTPFormats buildRTPMap(RTPFormats profile) {
        RTPFormats list = new RTPFormats();
        Formats fmts = new Formats();
        if (this.rtpChannel.getOutputDsp() != null) {
            Codec[] currCodecs = this.rtpChannel.getOutputDsp().getCodecs();
            for (int i = 0; i < currCodecs.length; ++i) {
                if (!currCodecs[i].getSupportedInputFormat().matches((Format)LINEAR_FORMAT)) continue;
                fmts.add(currCodecs[i].getSupportedOutputFormat());
            }
        }
        fmts.add((Format)DTMF_FORMAT);
        if (fmts != null) {
            for (int i = 0; i < fmts.size(); ++i) {
                RTPFormat f = profile.find(fmts.get(i));
                if (f == null) continue;
                list.add(f.clone());
            }
        }
        return list;
    }

    private void resetFormats() {
        this.offeredFormats.clean();
        this.negotiatedFormats.clean();
        this.setFormats(this.supportedFormats);
        this.negotiated = false;
    }

    public RTPFormats getNegotiatedFormats() {
        return this.negotiatedFormats;
    }

    public boolean hasNegotiatedFormats() {
        return this.negotiated;
    }

    public void negotiateFormats(MediaDescriptionField media) {
        this.offeredFormats.clean();
        for (int payloadType : media.getPayloadTypes()) {
            RTPFormat format = AVProfile.getFormat(payloadType, AVProfile.AUDIO);
            if (format == null) continue;
            this.offeredFormats.add(format);
        }
        this.negotiatedFormats.clean();
        this.supportedFormats.intersection(this.offeredFormats, this.negotiatedFormats);
        this.setFormats(this.negotiatedFormats);
        this.negotiated = true;
    }

    public boolean containsNegotiatedFormats() {
        return !this.negotiatedFormats.isEmpty() && this.negotiatedFormats.hasNonDTMF();
    }

    public void enableICE(String externalAddress, boolean rtcpMux) throws UnknownHostException, IllegalStateException {
        if (!this.open) {
            throw new IllegalStateException("Media Channel is not active");
        }
        if (this.ice) {
            throw new IllegalStateException("ICE is already enabled");
        }
        this.ice = true;
        this.rtcpMux = rtcpMux;
        if (this.iceAgent == null) {
            this.iceAgent = IceFactory.createLiteAgent();
            this.iceListener = new IceListener();
        }
        this.iceAgent.addIceListener((IceEventListener)this.iceListener);
        this.iceAgent.generateIceCredentials();
        this.iceAgent.addMediaStream("audio", true, this.rtcpMux);
        if (externalAddress != null && !externalAddress.isEmpty()) {
            this.iceAgent.setExternalAddress(InetAddress.getByName(externalAddress));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " enabled ICE"));
        }
    }

    public void disableICE() throws IllegalStateException {
        if (!this.open) {
            throw new IllegalStateException("Media Channel is not active");
        }
        if (!this.ice) {
            throw new IllegalStateException("ICE is not enabled");
        }
        if (this.iceAgent.isRunning()) {
            this.iceAgent.stop();
        }
        this.iceAgent.reset();
        this.ice = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " disabled ICE"));
        }
    }

    public boolean isIceEnabled() {
        return this.ice;
    }

    public String getIceUfrag() {
        if (this.ice) {
            return this.iceAgent.getUfrag();
        }
        return "";
    }

    public String getIcePwd() {
        if (this.ice) {
            return this.iceAgent.getPassword();
        }
        return "";
    }

    public List<LocalCandidateWrapper> getRtpCandidates() {
        if (this.ice) {
            IceMediaStream iceStream = this.iceAgent.getMediaStream(this.mediaType);
            return iceStream.getRtpComponent().getLocalCandidates();
        }
        return new ArrayList<LocalCandidateWrapper>();
    }

    public LocalCandidateWrapper getDefaultRtpCandidate() {
        if (this.ice) {
            IceMediaStream iceStream = this.iceAgent.getMediaStream(this.mediaType);
            return iceStream.getRtpComponent().getDefaultLocalCandidate();
        }
        return null;
    }

    public List<LocalCandidateWrapper> getRtcpCandidates() {
        if (this.ice) {
            IceMediaStream audioIce = this.iceAgent.getMediaStream(this.mediaType);
            return audioIce.getRtcpComponent().getLocalCandidates();
        }
        return new ArrayList<LocalCandidateWrapper>();
    }

    public LocalCandidateWrapper getDefaultRtcpCandidate() {
        if (this.ice) {
            IceMediaStream iceStream = this.iceAgent.getMediaStream(this.mediaType);
            return iceStream.getRtcpComponent().getDefaultLocalCandidate();
        }
        return null;
    }

    public void gatherIceCandidates(PortManager portManager) throws HarvestException, IllegalStateException {
        if (!this.ice) {
            throw new IllegalStateException("ICE is not enabled on this media channel");
        }
        this.iceAgent.harvest(portManager);
    }

    public void startIceAgent() throws IllegalStateException {
        if (!this.ice) {
            throw new IllegalStateException("ICE is not enabled on this media channel");
        }
        if (!this.iceAgent.isRunning()) {
            this.iceAgent.start();
        }
    }

    public void stopIceAgent() throws IllegalStateException {
        if (!this.ice) {
            throw new IllegalStateException("ICE is not enabled on this media channel");
        }
        if (this.iceAgent.isRunning()) {
            this.iceAgent.stop();
        }
    }

    public void enableDTLS(String hashFunction, String remoteFingerprint) throws IllegalStateException {
        if (this.dtls) {
            throw new IllegalStateException("DTLS is already enabled on this channel");
        }
        this.rtpChannel.enableSRTP(hashFunction, remoteFingerprint, (IceAuthenticator)this.iceAgent);
        if (!this.rtcpMux) {
            this.rtcpChannel.enableSRTCP(hashFunction, remoteFingerprint, (IceAuthenticator)this.iceAgent);
        }
        this.dtls = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " enabled DTLS"));
        }
    }

    public void disableDTLS() throws IllegalStateException {
        if (!this.dtls) {
            throw new IllegalStateException("DTLS is already disabled on this channel");
        }
        this.rtpChannel.disableSRTP();
        if (!this.rtcpMux) {
            this.rtcpChannel.disableSRTCP();
        }
        this.dtls = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.mediaType + " channel " + this.ssrc + " disabled DTLS"));
        }
    }

    public boolean isDtlsEnabled() {
        return this.dtls;
    }

    public String getDtlsFingerprint() {
        if (this.dtls) {
            return this.rtpChannel.getWebRtcLocalFingerprint().toString();
        }
        return "";
    }

    public long getPacketsReceived() {
        if (this.open) {
            return this.statistics.getRtpPacketsReceived();
        }
        return 0L;
    }

    public long getOctetsReceived() {
        if (this.open) {
            return this.statistics.getRtpOctetsReceived();
        }
        return 0L;
    }

    public long getPacketsSent() {
        if (this.open) {
            return this.statistics.getRtpPacketsSent();
        }
        return 0L;
    }

    public long getOctetsSent() {
        if (this.open) {
            return this.statistics.getRtpOctetsSent();
        }
        return 0L;
    }

    public long getJitter() {
        if (this.open) {
            return this.statistics.getMember(this.ssrc).getJitter();
        }
        return 0L;
    }

    private class IceListener
    implements IceEventListener {
        private IceListener() {
        }

        public void onSelectedCandidates(SelectedCandidatesEvent event) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Finished ICE candidates selection for " + MediaChannel.this.mediaType + " channel  " + MediaChannel.this.ssrc + "! Preparing for binding."));
                }
                IceAgent agent = event.getSource();
                CandidatePair rtpCandidate = agent.getSelectedRtpCandidate(MediaChannel.this.mediaType);
                MediaChannel.this.rtpChannel.bind(rtpCandidate.getChannel());
                CandidatePair rtcpCandidate = agent.getSelectedRtcpCandidate(MediaChannel.this.mediaType);
                if (rtcpCandidate != null) {
                    MediaChannel.this.rtcpChannel.bind(rtcpCandidate.getChannel());
                }
            }
            catch (IOException e) {
                MediaChannel.this.rtpListener.onRtpFailure("Could not select ICE candidates: " + e.getMessage());
            }
        }
    }
}

