/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.IOException;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtp.RTPOutput;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.impl.rtp.rfc2833.DtmfOutput;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormat;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormats;
import org.mobicents.media.server.impl.rtp.statistics.RtpStatistics;
import org.mobicents.media.server.impl.srtp.DtlsHandler;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.spi.memory.Frame;

public class RtpTransmitter {
    private static final Logger LOGGER = Logger.getLogger(RtpTransmitter.class);
    private DatagramChannel channel;
    private final RtpClock rtpClock;
    private final RtpStatistics statistics;
    private boolean dtmfSupported;
    private final RTPOutput rtpOutput;
    private final DtmfOutput dtmfOutput;
    private final RtpPacket rtpPacket = new RtpPacket(8192, true);
    private final RtpPacket oobPacket = new RtpPacket(8192, true);
    private DtlsHandler dtlsHandler;
    private boolean secure;
    private RTPFormats formats;
    private RTPFormat currentFormat;
    private long timestamp;
    private long dtmfTimestamp;
    private int sequenceNumber;

    public RtpTransmitter(Scheduler scheduler, RtpClock clock, RtpStatistics statistics) {
        this.rtpClock = clock;
        this.statistics = statistics;
        this.dtmfSupported = false;
        this.rtpOutput = new RTPOutput(scheduler, this);
        this.dtmfOutput = new DtmfOutput(scheduler, this);
        this.sequenceNumber = 0;
        this.dtmfTimestamp = -1L;
        this.timestamp = -1L;
        this.formats = null;
        this.secure = false;
    }

    public void setFormatMap(RTPFormats rtpFormats) {
        this.dtmfSupported = rtpFormats.contains(101);
        this.formats = rtpFormats;
    }

    public RTPOutput getRtpOutput() {
        return this.rtpOutput;
    }

    public DtmfOutput getDtmfOutput() {
        return this.dtmfOutput;
    }

    public void enableSrtp(DtlsHandler handler) {
        this.secure = true;
        this.dtlsHandler = handler;
    }

    public void disableSrtp() {
        this.secure = false;
        this.dtlsHandler = null;
    }

    public void activate() {
        this.rtpOutput.activate();
        this.dtmfOutput.activate();
    }

    public void deactivate() {
        this.rtpOutput.deactivate();
        this.dtmfOutput.deactivate();
        this.dtmfSupported = false;
    }

    public void setChannel(DatagramChannel channel) {
        this.channel = channel;
    }

    private boolean isConnected() {
        return this.channel != null && this.channel.isConnected();
    }

    private void disconnect() throws IOException {
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    public void reset() {
        this.deactivate();
        this.clear();
    }

    public void clear() {
        this.timestamp = -1L;
        this.dtmfTimestamp = -1L;
        this.currentFormat = null;
    }

    private void send(RtpPacket packet) throws IOException {
        if (this.secure && !this.dtlsHandler.isHandshakeComplete()) {
            return;
        }
        ByteBuffer buffer = packet.getBuffer();
        if (this.secure) {
            byte[] rtpData = new byte[buffer.limit()];
            buffer.get(rtpData, 0, rtpData.length);
            byte[] srtpData = this.dtlsHandler.encodeRTP(rtpData, 0, rtpData.length);
            if (srtpData == null || srtpData.length == 0) {
                LOGGER.warn((Object)"Could not secure RTP packet! Packet dropped.");
                return;
            }
            buffer.clear();
            buffer.put(srtpData);
            buffer.flip();
        }
        if (packet != null) {
            this.channel.send(buffer, this.channel.socket().getRemoteSocketAddress());
            this.statistics.onRtpSent(packet);
        }
    }

    public void sendDtmf(Frame frame) {
        if (!this.dtmfSupported) {
            frame.recycle();
            return;
        }
        if (frame.getTimestamp() / 1000000L == this.dtmfTimestamp) {
            frame.recycle();
            return;
        }
        this.dtmfTimestamp = frame.getTimestamp() / 1000000L;
        this.dtmfTimestamp = this.rtpClock.convertToRtpTime(this.dtmfTimestamp);
        this.oobPacket.wrap(false, 101, this.sequenceNumber++, this.dtmfTimestamp, this.statistics.getSsrc(), frame.getData(), frame.getOffset(), frame.getLength());
        frame.recycle();
        try {
            if (this.isConnected()) {
                this.send(this.oobPacket);
            }
        }
        catch (PortUnreachableException e) {
            try {
                this.disconnect();
            }
            catch (IOException ex) {
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void send(Frame frame) {
        if (frame.getFormat() == null) {
            frame.recycle();
            return;
        }
        if (this.currentFormat == null || !this.currentFormat.getFormat().matches(frame.getFormat())) {
            this.currentFormat = this.formats.getRTPFormat(frame.getFormat());
            if (this.currentFormat == null) {
                frame.recycle();
                return;
            }
            this.rtpClock.setClockRate(this.currentFormat.getClockRate());
        }
        if (frame.getTimestamp() / 1000000L == this.timestamp) {
            frame.recycle();
            return;
        }
        this.timestamp = frame.getTimestamp() / 1000000L;
        this.timestamp = this.rtpClock.convertToRtpTime(this.timestamp);
        this.rtpPacket.wrap(false, this.currentFormat.getID(), this.sequenceNumber++, this.timestamp, this.statistics.getSsrc(), frame.getData(), frame.getOffset(), frame.getLength());
        frame.recycle();
        try {
            if (this.isConnected()) {
                this.send(this.rtpPacket);
            }
        }
        catch (PortUnreachableException e) {
            try {
                this.disconnect();
            }
            catch (IOException ex) {
                LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

