/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.Serializable;
import java.nio.ByteBuffer;

public class RtpPacket
implements Serializable {
    public static final int RTP_PACKET_MAX_SIZE = 8192;
    private static final long serialVersionUID = -1590053946635208723L;
    public static final int FIXED_HEADER_SIZE = 12;
    public static final int EXT_HEADER_SIZE = 4;
    public static final int VERSION = 2;
    private ByteBuffer buffer;

    public RtpPacket(int capacity, boolean allocateDirect) {
        this.buffer = allocateDirect ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    public RtpPacket(boolean allocateDirect) {
        this(8192, allocateDirect);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getVersion() {
        return (this.buffer.get(0) & 0xC0) >> 6;
    }

    public int getContributingSource() {
        return this.buffer.get(0) & 0xF;
    }

    public boolean hasPadding() {
        return (this.buffer.get(0) & 0x20) == 32;
    }

    public boolean hasExtensions() {
        return (this.buffer.get(0) & 0x10) == 16;
    }

    public boolean getMarker() {
        return (this.buffer.get(1) & 0xFF & 0x80) == 128;
    }

    public int getPayloadType() {
        return this.buffer.get(1) & 0xFF & 0x7F;
    }

    public int getSeqNumber() {
        return this.buffer.getShort(2) & 0xFFFF;
    }

    public long getTimestamp() {
        return (long)(this.buffer.get(4) & 0xFF) << 24 | (long)(this.buffer.get(5) & 0xFF) << 16 | (long)(this.buffer.get(6) & 0xFF) << 8 | (long)(this.buffer.get(7) & 0xFF);
    }

    public long getSyncSource() {
        return this.readUnsignedIntAsLong(8);
    }

    public long GetRTCPSyncSource() {
        return this.readUnsignedIntAsLong(4);
    }

    public long readUnsignedIntAsLong(int off) {
        this.buffer.position(off);
        return ((long)(this.buffer.get() & 0xFF) << 24 | (long)(this.buffer.get() & 0xFF) << 16 | (long)(this.buffer.get() & 0xFF) << 8 | (long)(this.buffer.get() & 0xFF)) & 0xFFFFFFFFL;
    }

    public void getPayload(byte[] buff, int offset) {
        this.buffer.position(12);
        this.buffer.get(buff, offset, this.buffer.limit() - 12);
    }

    public void wrap(boolean mark, int payloadType, int seqNumber, long timestamp, long ssrc, byte[] data, int offset, int len) {
        this.buffer.clear();
        this.buffer.rewind();
        this.buffer.put((byte)-128);
        byte b = (byte)payloadType;
        if (mark) {
            b = (byte)(b | 0x80);
        }
        this.buffer.put(b);
        this.buffer.put((byte)((seqNumber & 0xFF00) >> 8));
        this.buffer.put((byte)(seqNumber & 0xFF));
        this.buffer.put((byte)((timestamp & 0xFFFFFFFFFF000000L) >> 24));
        this.buffer.put((byte)((timestamp & 0xFF0000L) >> 16));
        this.buffer.put((byte)((timestamp & 0xFF00L) >> 8));
        this.buffer.put((byte)(timestamp & 0xFFL));
        this.buffer.put((byte)((ssrc & 0xFFFFFFFFFF000000L) >> 24));
        this.buffer.put((byte)((ssrc & 0xFF0000L) >> 16));
        this.buffer.put((byte)((ssrc & 0xFF00L) >> 8));
        this.buffer.put((byte)(ssrc & 0xFFL));
        this.buffer.put(data, offset, len);
        this.buffer.flip();
        this.buffer.rewind();
    }

    public String toString() {
        return "RTP Packet[marker=" + this.getMarker() + ", seq=" + this.getSeqNumber() + ", timestamp=" + this.getTimestamp() + ", payload_size=" + this.getPayloadLength() + ", payload=" + this.getPayloadType() + "]";
    }

    public void shrink(int delta) {
        if (delta <= 0) {
            return;
        }
        int newLimit = this.buffer.limit() - delta;
        if (newLimit <= 0) {
            newLimit = 0;
        }
        this.buffer.limit(newLimit);
    }

    public int getHeaderLength() {
        if (this.getExtensionBit()) {
            return 12 + 4 * this.getCsrcCount() + 4 + this.getExtensionLength();
        }
        return 12 + 4 * this.getCsrcCount();
    }

    public int getPayloadLength() {
        return this.buffer.limit() - this.getHeaderLength();
    }

    public int getExtensionLength() {
        if (!this.getExtensionBit()) {
            return 0;
        }
        int extLenIndex = 12 + this.getCsrcCount() * 4 + 2;
        return this.buffer.get(extLenIndex) << 8 | this.buffer.get(extLenIndex + 1) * 4;
    }

    public boolean getExtensionBit() {
        this.buffer.rewind();
        return (this.buffer.get() & 0x10) == 16;
    }

    public int getCsrcCount() {
        this.buffer.rewind();
        return this.buffer.get() & 0xF;
    }

    public int getPaddingSize() {
        this.buffer.rewind();
        if ((this.buffer.get() & 4) == 0) {
            return 0;
        }
        return this.buffer.get(this.buffer.limit() - 1);
    }

    public int getLength() {
        return this.buffer.limit();
    }

    public void grow(int delta) {
        if (delta == 0) {
            return;
        }
        int newLen = this.buffer.limit() + delta;
        if (newLen <= this.buffer.capacity()) {
            this.buffer.limit(newLen);
            return;
        }
        ByteBuffer newBuffer = this.buffer.isDirect() ? ByteBuffer.allocateDirect(newLen) : ByteBuffer.allocate(newLen);
        this.buffer.rewind();
        newBuffer.put(this.buffer);
        newBuffer.limit(newLen);
        this.buffer = newBuffer;
    }

    public void append(byte[] data, int len) {
        if (data == null || len <= 0 || len > data.length) {
            throw new IllegalArgumentException("Invalid combination of parameters data and length to append()");
        }
        int oldLimit = this.buffer.limit();
        this.grow(len);
        this.buffer.position(oldLimit);
        this.buffer.limit(oldLimit + len);
        this.buffer.put(data, 0, len);
    }

    public void readRegionToBuff(int off, int len, byte[] outBuff) {
        assert (off >= 0);
        assert (len > 0);
        assert (outBuff != null);
        assert (outBuff.length >= len);
        assert (this.buffer.limit() >= off + len);
        this.buffer.position(off);
        this.buffer.get(outBuff, 0, len);
    }
}

