/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import org.apache.log4j.Logger;
import org.mobicents.media.io.ice.IceAuthenticator;
import org.mobicents.media.io.ice.network.stun.StunHandler;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.impl.rtcp.RtcpHandler;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpHandler;
import org.mobicents.media.server.impl.rtp.RtpListener;
import org.mobicents.media.server.impl.rtp.RtpTransmitter;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormats;
import org.mobicents.media.server.impl.rtp.statistics.RtpStatistics;
import org.mobicents.media.server.impl.srtp.DtlsHandler;
import org.mobicents.media.server.impl.srtp.DtlsListener;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.io.network.channel.Channel;
import org.mobicents.media.server.io.network.channel.MultiplexedChannel;
import org.mobicents.media.server.io.network.channel.PacketHandler;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.FormatNotSupportedException;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.utils.Text;

public class RtpChannel
extends MultiplexedChannel
implements DtlsListener {
    private static final Logger logger = Logger.getLogger(RtpChannel.class);
    private static final int PORT_ANY = -1;
    private final int channelId;
    private boolean bound;
    private RtpStatistics statistics;
    private final UdpManager udpManager;
    private final Scheduler scheduler;
    private final RtpClock clock;
    private final RtpClock oobClock;
    private final int jitterBufferSize;
    private final HeartBeat heartBeat;
    private SocketAddress remotePeer;
    private RtpTransmitter transmitter;
    private static final int RTP_PRIORITY = 3;
    private static final int STUN_PRIORITY = 2;
    private static final int RTCP_PRIORITY = 1;
    private RtpHandler rtpHandler;
    private DtlsHandler dtlsHandler;
    private StunHandler stunHandler;
    private RtcpHandler rtcpHandler;
    private AudioComponent audioComponent;
    private OOBComponent oobComponent;
    protected static final AudioFormat LINEAR_FORMAT = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    protected static final AudioFormat DTMF_FORMAT = FormatFactory.createAudioFormat((String)"telephone-event", (int)8000);
    private boolean secure;
    private boolean rtcpMux;
    private RtpListener rtpListener;

    protected RtpChannel(int channelId, int jitterBufferSize, RtpStatistics statistics, RtpClock clock, RtpClock oobClock, Scheduler scheduler, UdpManager udpManager) {
        this.scheduler = scheduler;
        this.udpManager = udpManager;
        this.clock = clock;
        this.oobClock = oobClock;
        this.channelId = channelId;
        this.jitterBufferSize = jitterBufferSize;
        this.statistics = statistics;
        this.bound = false;
        this.transmitter = new RtpTransmitter(scheduler, clock, statistics);
        this.rtpHandler = new RtpHandler(scheduler, clock, oobClock, jitterBufferSize, statistics);
        this.audioComponent = new AudioComponent(channelId);
        this.audioComponent.addInput(this.rtpHandler.getRtpInput().getAudioInput());
        this.audioComponent.addOutput(this.transmitter.getRtpOutput().getAudioOutput());
        this.oobComponent = new OOBComponent(channelId);
        this.oobComponent.addInput(this.rtpHandler.getDtmfInput().getOOBInput());
        this.oobComponent.addOutput(this.transmitter.getDtmfOutput().getOOBOutput());
        this.secure = false;
        this.rtcpMux = false;
        this.heartBeat = new HeartBeat();
    }

    public RtpTransmitter getTransmitter() {
        return this.transmitter;
    }

    public AudioComponent getAudioComponent() {
        return this.audioComponent;
    }

    public OOBComponent getOobComponent() {
        return this.oobComponent;
    }

    public Processor getInputDsp() {
        return this.rtpHandler.getRtpInput().getDsp();
    }

    public void setInputDsp(Processor dsp) {
        this.rtpHandler.getRtpInput().setDsp(dsp);
    }

    public Processor getOutputDsp() {
        return this.transmitter.getRtpOutput().getDsp();
    }

    public void setOutputDsp(Processor dsp) {
        this.transmitter.getRtpOutput().setDsp(dsp);
    }

    public void setOutputFormats(Formats fmts) throws FormatNotSupportedException {
        this.transmitter.getRtpOutput().setFormats(fmts);
    }

    public void setRtpListener(RtpListener listener) {
        this.rtpListener = listener;
    }

    public long getPacketsReceived() {
        return this.statistics.getRtpPacketsReceived();
    }

    public long getPacketsTransmitted() {
        return this.statistics.getRtpPacketsSent();
    }

    public void setFormatMap(RTPFormats rtpFormats) {
        this.flush();
        this.rtpHandler.setFormatMap(rtpFormats);
        this.transmitter.setFormatMap(rtpFormats);
    }

    public RTPFormats getFormatMap() {
        return this.rtpHandler.getFormatMap();
    }

    public void updateMode(ConnectionMode connectionMode) {
        switch (connectionMode) {
            case SEND_ONLY: {
                this.rtpHandler.setReceivable(false);
                this.rtpHandler.setLoopable(false);
                this.audioComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(true));
                this.oobComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(true));
                this.rtpHandler.deactivate();
                this.transmitter.activate();
                break;
            }
            case RECV_ONLY: {
                this.rtpHandler.setReceivable(true);
                this.rtpHandler.setLoopable(false);
                this.audioComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(false));
                this.oobComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(false));
                this.rtpHandler.activate();
                this.transmitter.deactivate();
                break;
            }
            case INACTIVE: {
                this.rtpHandler.setReceivable(false);
                this.rtpHandler.setLoopable(false);
                this.audioComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
                this.oobComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
                this.rtpHandler.deactivate();
                this.transmitter.deactivate();
                break;
            }
            case SEND_RECV: 
            case CONFERENCE: {
                this.rtpHandler.setReceivable(true);
                this.rtpHandler.setLoopable(false);
                this.audioComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(true));
                this.oobComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(true));
                this.rtpHandler.activate();
                this.transmitter.activate();
                break;
            }
            case NETWORK_LOOPBACK: {
                this.rtpHandler.setReceivable(false);
                this.rtpHandler.setLoopable(true);
                this.audioComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
                this.oobComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
                this.rtpHandler.deactivate();
                this.transmitter.deactivate();
                break;
            }
        }
        boolean connectImmediately = false;
        if (this.remotePeer != null) {
            connectImmediately = this.udpManager.connectImmediately((InetSocketAddress)this.remotePeer);
        }
        if (this.udpManager.getRtpTimeout() > 0 && this.remotePeer != null && !connectImmediately) {
            if (this.rtpHandler.isReceivable()) {
                this.statistics.setLastHeartbeat(this.scheduler.getClock().getTime());
                this.scheduler.submitHeatbeat((Task)this.heartBeat);
            } else {
                this.heartBeat.cancel();
            }
        }
    }

    private void onBinding(boolean useJitterBuffer) {
        this.rtpHandler.setPipelinePriority(3);
        if (this.rtcpMux) {
            this.rtcpHandler.setPipelinePriority(1);
        }
        if (this.secure) {
            this.stunHandler.setPipelinePriority(2);
        }
        this.transmitter.setChannel(this.dataChannel);
        this.rtpHandler.useJitterBuffer(useJitterBuffer);
        this.handlers.addHandler((PacketHandler)this.rtpHandler);
        if (this.rtcpMux) {
            this.rtcpHandler.setChannel(this.dataChannel);
            this.handlers.addHandler((PacketHandler)this.rtcpHandler);
        }
        if (this.secure) {
            this.dtlsHandler.setChannel(this.dataChannel);
            this.dtlsHandler.addListener(this);
            this.handlers.addHandler((PacketHandler)this.stunHandler);
            this.dtlsHandler.handshake();
        }
    }

    public void bind(boolean isLocal) throws IOException {
        this.selectionKey = this.udpManager.open((Channel)this);
        this.dataChannel = (DatagramChannel)this.selectionKey.channel();
        this.onBinding(!isLocal);
        this.udpManager.bind(this.dataChannel, -1, isLocal);
        this.bound = true;
    }

    public void bind(DatagramChannel channel) throws IOException, SocketException {
        try {
            this.selectionKey = this.udpManager.open(channel, (Channel)this);
            this.dataChannel = channel;
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
        this.onBinding(true);
        if (!channel.socket().isBound()) {
            this.udpManager.bind(channel, -1);
        }
        this.bound = true;
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isAvailable() {
        boolean available;
        boolean bl = available = this.dataChannel != null && this.dataChannel.isConnected();
        if (this.secure) {
            available = available && this.dtlsHandler.isHandshakeComplete();
        }
        return available;
    }

    public void setRemotePeer(SocketAddress address) {
        this.remotePeer = address;
        boolean connectImmediately = false;
        if (this.dataChannel != null) {
            if (this.dataChannel.isConnected()) {
                try {
                    this.disconnect();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
            if (connectImmediately = this.udpManager.connectImmediately((InetSocketAddress)address)) {
                try {
                    this.dataChannel.connect(address);
                }
                catch (IOException e) {
                    logger.info((Object)"Can not connect to remote address , please check that you are not using local address - 127.0.0.X to connect to remote");
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.udpManager.getRtpTimeout() > 0 && !connectImmediately) {
            if (this.rtpHandler.isReceivable()) {
                this.statistics.setLastHeartbeat(this.scheduler.getClock().getTime());
                this.scheduler.submitHeatbeat((Task)this.heartBeat);
            } else {
                this.heartBeat.cancel();
            }
        }
    }

    public String getExternalAddress() {
        return this.udpManager.getExternalAddress();
    }

    public boolean hasExternalAddress() {
        return this.notEmpty(this.udpManager.getExternalAddress());
    }

    private boolean notEmpty(String text) {
        return text != null && !text.isEmpty();
    }

    public void enableSRTP(String hashFunction, String remotePeerFingerprint, IceAuthenticator authenticator) {
        this.secure = true;
        if (this.dtlsHandler == null) {
            this.dtlsHandler = new DtlsHandler();
        }
        this.dtlsHandler.setRemoteFingerprint(hashFunction, remotePeerFingerprint);
        if (this.stunHandler == null) {
            this.stunHandler = new StunHandler(authenticator);
        }
        this.transmitter.enableSrtp(this.dtlsHandler);
        this.rtpHandler.enableSrtp(this.dtlsHandler);
        if (this.rtcpMux) {
            this.rtcpHandler.enableSRTCP(this.dtlsHandler);
        }
    }

    public void disableSRTP() {
        this.secure = false;
        if (this.dtlsHandler != null) {
            this.dtlsHandler.setRemoteFingerprint("", "");
            this.dtlsHandler.resetLocalFingerprint();
        }
        if (this.stunHandler != null) {
            this.handlers.removeHandler((PacketHandler)this.stunHandler);
        }
        this.transmitter.disableSrtp();
        this.rtpHandler.disableSrtp();
        if (this.rtcpMux) {
            this.rtcpHandler.disableSRTCP();
        }
    }

    public void enableRtcpMux(boolean enable) {
        this.rtcpMux = enable;
        if (enable && this.rtcpHandler == null) {
            this.rtcpHandler = new RtcpHandler(this.statistics);
        }
    }

    public Text getWebRtcLocalFingerprint() {
        if (this.dtlsHandler != null) {
            return this.dtlsHandler.getLocalFingerprint();
        }
        return new Text();
    }

    public void close() {
        if (this.rtcpMux) {
            this.rtcpHandler.leaveRtpSession();
            this.reset();
        } else {
            super.close();
            this.reset();
        }
        this.bound = false;
    }

    private void reset() {
        this.heartBeat.cancel();
        this.rtpHandler.reset();
        this.transmitter.reset();
        if (this.rtcpMux) {
            this.rtcpHandler.reset();
        }
        if (this.secure) {
            this.dtlsHandler.reset();
        }
    }

    @Override
    public void onDtlsHandshakeComplete() {
        logger.info((Object)"DTLS handshake completed for RTP candidate.");
        if (this.rtcpMux) {
            this.rtcpHandler.joinRtpSession();
        }
    }

    @Override
    public void onDtlsHandshakeFailed(Throwable e) {
        this.rtpListener.onRtpFailure(e);
    }

    static {
        DTMF_FORMAT.setOptions(new Text("0-15"));
    }

    private class HeartBeat
    extends Task {
        private HeartBeat() {
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public long perform() {
            long elapsedTime = RtpChannel.this.scheduler.getClock().getTime() - RtpChannel.this.statistics.getLastHeartbeat();
            if (elapsedTime > (long)RtpChannel.this.udpManager.getRtpTimeout() * 1000000000L) {
                if (RtpChannel.this.rtpListener != null) {
                    RtpChannel.this.rtpListener.onRtpFailure("RTP timeout! Elapsed time since last heartbeat: " + elapsedTime);
                }
            } else {
                RtpChannel.this.scheduler.submitHeatbeat((Task)this);
            }
            return 0L;
        }
    }
}

