/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.apache.log4j.Logger;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.impl.rtp.ChannelsManager;
import org.mobicents.media.server.impl.rtp.JitterBuffer;
import org.mobicents.media.server.impl.rtp.RTPChannelListener;
import org.mobicents.media.server.impl.rtp.RTPInput;
import org.mobicents.media.server.impl.rtp.RTPOutput;
import org.mobicents.media.server.impl.rtp.RtpClock;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.impl.rtp.rfc2833.DtmfInput;
import org.mobicents.media.server.impl.rtp.rfc2833.DtmfOutput;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormat;
import org.mobicents.media.server.impl.rtp.sdp.RTPFormats;
import org.mobicents.media.server.impl.srtp.DtlsHandler;
import org.mobicents.media.server.io.network.ProtocolHandler;
import org.mobicents.media.server.io.network.UdpManager;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.FormatNotSupportedException;
import org.mobicents.media.server.spi.dsp.Processor;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.format.Formats;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.utils.Text;

@Deprecated
public class RTPDataChannel {
    private Logger logger = Logger.getLogger(RTPDataChannel.class);
    private static final int PORT_ANY = -1;
    private static final AudioFormat LINEAR_FORMAT = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private static final AudioFormat DTMF_FORMAT = FormatFactory.createAudioFormat((String)"telephone-event", (int)8000);
    private final long ssrc = System.currentTimeMillis();
    private ChannelsManager channelsManager;
    private DatagramChannel rtpChannel;
    private DatagramChannel rtcpChannel;
    private boolean rtpChannelBound = false;
    private boolean rtcpChannelBound = false;
    private RTPInput input;
    private RTPOutput output;
    private DtmfInput dtmfInput;
    private DtmfOutput dtmfOutput;
    private TxTask tx = new TxTask();
    private RtpClock rtpClock;
    private RtpClock oobClock;
    private int jitterBufferSize;
    private RTPFormats rtpFormats = new RTPFormats();
    private SocketAddress remotePeer;
    private int sn;
    private int count;
    private RTPHandler rtpHandler;
    private volatile long rxCount;
    private volatile long txCount;
    private JitterBuffer rxBuffer;
    private Formats formats = new Formats();
    private Boolean shouldReceive = false;
    private Boolean shouldLoop = false;
    private HeartBeat heartBeat;
    private long lastPacketReceived;
    private RTPChannelListener rtpChannelListener;
    private Scheduler scheduler;
    private UdpManager udpManager;
    private AudioComponent audioComponent;
    private OOBComponent oobComponent;
    private boolean sendDtmf = false;
    private boolean isWebRtc = false;
    private DtlsHandler webRtcHandler;

    protected RTPDataChannel(ChannelsManager channelsManager, int channelId) {
        this.channelsManager = channelsManager;
        this.jitterBufferSize = channelsManager.getJitterBufferSize();
        this.rtpHandler = new RTPHandler();
        this.rtpClock = new RtpClock(channelsManager.getClock());
        this.oobClock = new RtpClock(channelsManager.getClock());
        this.rxBuffer = new JitterBuffer(this.rtpClock, this.jitterBufferSize);
        this.scheduler = channelsManager.getScheduler();
        this.udpManager = channelsManager.getUdpManager();
        this.input = new RTPInput(this.scheduler, this.rxBuffer);
        this.rxBuffer.setListener(this.input);
        this.output = new RTPOutput(this.scheduler, this);
        this.dtmfInput = new DtmfInput(this.scheduler, this.oobClock);
        this.dtmfOutput = new DtmfOutput(this.scheduler, this);
        this.heartBeat = new HeartBeat();
        this.formats.add((Format)LINEAR_FORMAT);
        this.audioComponent = new AudioComponent(channelId);
        this.audioComponent.addInput(this.input.getAudioInput());
        this.audioComponent.addOutput(this.output.getAudioOutput());
        this.oobComponent = new OOBComponent(channelId);
        this.oobComponent.addInput(this.dtmfInput.getOOBInput());
        this.oobComponent.addOutput(this.dtmfOutput.getOOBOutput());
    }

    public AudioComponent getAudioComponent() {
        return this.audioComponent;
    }

    public OOBComponent getOOBComponent() {
        return this.oobComponent;
    }

    public void setInputDsp(Processor dsp) {
        this.input.setDsp(dsp);
    }

    public Processor getInputDsp() {
        return this.input.getDsp();
    }

    public void setOutputDsp(Processor dsp) {
        this.output.setDsp(dsp);
    }

    public Processor getOutputDsp() {
        return this.output.getDsp();
    }

    public void setOutputFormats(Formats fmts) throws FormatNotSupportedException {
        this.output.setFormats(fmts);
    }

    public void setRtpChannelListener(RTPChannelListener rtpChannelListener) {
        this.rtpChannelListener = rtpChannelListener;
    }

    public void updateMode(ConnectionMode connectionMode) {
        switch (connectionMode) {
            case SEND_ONLY: {
                this.shouldReceive = false;
                this.shouldLoop = false;
                this.audioComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(true));
                this.oobComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(true));
                this.dtmfInput.deactivate();
                this.input.deactivate();
                this.output.activate();
                this.dtmfOutput.activate();
                break;
            }
            case RECV_ONLY: {
                this.shouldReceive = true;
                this.shouldLoop = false;
                this.audioComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(false));
                this.oobComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(false));
                this.dtmfInput.activate();
                this.input.activate();
                this.output.deactivate();
                this.dtmfOutput.deactivate();
                break;
            }
            case INACTIVE: {
                this.shouldReceive = false;
                this.shouldLoop = false;
                this.audioComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
                this.oobComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
                this.dtmfInput.deactivate();
                this.input.deactivate();
                this.output.deactivate();
                this.dtmfOutput.deactivate();
                break;
            }
            case SEND_RECV: 
            case CONFERENCE: {
                this.shouldReceive = true;
                this.shouldLoop = false;
                this.audioComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(true));
                this.oobComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(true));
                this.dtmfInput.activate();
                this.input.activate();
                this.output.activate();
                this.dtmfOutput.activate();
                break;
            }
            case NETWORK_LOOPBACK: {
                this.shouldReceive = false;
                this.shouldLoop = true;
                this.audioComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
                this.oobComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
                this.dtmfInput.deactivate();
                this.input.deactivate();
                this.output.deactivate();
                this.dtmfOutput.deactivate();
                break;
            }
        }
        boolean connectImmediately = false;
        if (this.remotePeer != null) {
            connectImmediately = this.udpManager.connectImmediately((InetSocketAddress)this.remotePeer);
        }
        if (this.udpManager.getRtpTimeout() > 0 && this.remotePeer != null && !connectImmediately) {
            if (this.shouldReceive.booleanValue()) {
                this.lastPacketReceived = this.scheduler.getClock().getTime();
                this.scheduler.submitHeatbeat((Task)this.heartBeat);
            } else {
                this.heartBeat.cancel();
            }
        }
    }

    public void bind(boolean isLocal) throws IOException, SocketException {
        try {
            this.rtpChannel = this.udpManager.open((ProtocolHandler)this.rtpHandler);
            if (this.channelsManager.getIsControlEnabled().booleanValue()) {
                this.rtcpChannel = this.udpManager.open((ProtocolHandler)new RTCPHandler());
            }
        }
        catch (IOException e) {
            throw new SocketException(e.getMessage());
        }
        if (!isLocal) {
            this.rxBuffer.setBufferInUse(true);
            this.udpManager.bind(this.rtpChannel, -1);
        } else {
            this.rxBuffer.setBufferInUse(false);
            this.udpManager.bindLocal(this.rtpChannel, -1);
        }
        this.rtpChannelBound = true;
        if (this.channelsManager.getIsControlEnabled().booleanValue()) {
            if (!isLocal) {
                this.udpManager.bind(this.rtcpChannel, this.rtpChannel.socket().getLocalPort() + 1);
            } else {
                this.udpManager.bindLocal(this.rtcpChannel, this.rtpChannel.socket().getLocalPort() + 1);
            }
        }
    }

    public void bind(DatagramChannel channel) throws IOException {
        this.rxBuffer.setBufferInUse(true);
        this.rtpChannel = channel;
        if (this.isWebRtc) {
            this.webRtcHandler.setChannel(this.rtpChannel);
        }
        this.udpManager.open(this.rtpChannel, (ProtocolHandler)this.rtpHandler);
        this.rtpChannelBound = true;
    }

    public boolean isDataChannelBound() {
        return this.rtpChannelBound;
    }

    public int getLocalPort() {
        return this.rtpChannel != null ? this.rtpChannel.socket().getLocalPort() : 0;
    }

    public void setPeer(SocketAddress address) {
        this.remotePeer = address;
        boolean connectImmediately = false;
        if (this.rtpChannel != null) {
            if (this.rtpChannel.isConnected()) {
                try {
                    this.rtpChannel.disconnect();
                }
                catch (IOException e) {
                    this.logger.error((Object)e);
                }
            }
            if (connectImmediately = this.udpManager.connectImmediately((InetSocketAddress)address)) {
                try {
                    this.rtpChannel.connect(address);
                }
                catch (IOException e) {
                    this.logger.info((Object)"Can not connect to remote address , please check that you are not using local address - 127.0.0.X to connect to remote");
                    this.logger.error((Object)e);
                }
            }
        }
        if (this.udpManager.getRtpTimeout() > 0 && !connectImmediately) {
            if (this.shouldReceive.booleanValue()) {
                this.lastPacketReceived = this.scheduler.getClock().getTime();
                this.scheduler.submitHeatbeat((Task)this.heartBeat);
            } else {
                this.heartBeat.cancel();
            }
        }
    }

    public void close() {
        if (this.rtpChannel != null && this.rtpChannel.isConnected()) {
            try {
                this.rtpChannel.disconnect();
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
            try {
                this.rtpChannel.socket().close();
                this.rtpChannel.close();
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
        }
        if (this.rtcpChannel != null) {
            this.rtcpChannel.socket().close();
        }
        this.rxCount = 0L;
        this.txCount = 0L;
        this.input.deactivate();
        this.dtmfInput.deactivate();
        this.dtmfInput.reset();
        this.output.deactivate();
        this.dtmfOutput.deactivate();
        this.tx.clear();
        this.heartBeat.cancel();
        this.sendDtmf = false;
    }

    public int getPacketsLost() {
        return this.input.getPacketsLost();
    }

    public long getPacketsReceived() {
        return this.rxCount;
    }

    public long getPacketsTransmitted() {
        return this.txCount;
    }

    public void setFormatMap(RTPFormats rtpFormats) {
        this.sendDtmf = rtpFormats.find(101) != null;
        this.rtpHandler.flush();
        this.rtpFormats = rtpFormats;
        this.rxBuffer.setFormats(rtpFormats);
    }

    protected void send(Frame frame) {
        if (this.rtpChannel != null && this.rtpChannel.isConnected()) {
            this.tx.perform(frame);
        }
    }

    public void sendDtmf(Frame frame) {
        if (this.rtpChannel.isConnected()) {
            this.tx.performDtmf(frame);
        }
    }

    public boolean isAvailable() {
        boolean available;
        boolean bl = available = this.rtpChannel != null && this.rtpChannel.isConnected();
        if (this.isWebRtc) {
            available = available && this.webRtcHandler.isHandshakeComplete();
        }
        return available;
    }

    public void enableWebRTC(Text remotePeerFingerprint) {
        this.isWebRtc = true;
        if (this.webRtcHandler == null) {
            this.webRtcHandler = new DtlsHandler();
        }
        this.webRtcHandler.setRemoteFingerprint("sha-256", remotePeerFingerprint.toString());
    }

    public Text getWebRtcLocalFingerprint() {
        if (this.webRtcHandler != null) {
            return this.webRtcHandler.getLocalFingerprint();
        }
        return new Text();
    }

    private SocketAddress receiveRtpPacket(RtpPacket packet) throws IOException {
        SocketAddress address = null;
        if (this.isWebRtc) {
            // empty if block
        }
        if (packet != null) {
            ByteBuffer buf = packet.getBuffer();
            buf.clear();
            address = this.rtpChannel.receive(buf);
            buf.flip();
        }
        return address;
    }

    private void sendRtpPacket(RtpPacket packet) throws IOException {
        if (this.isWebRtc && !this.webRtcHandler.isHandshakeComplete()) {
            return;
        }
        if (this.isWebRtc) {
            // empty if block
        }
        if (packet != null) {
            ByteBuffer buf = packet.getBuffer();
            buf.rewind();
            this.rtpChannel.send(buf, this.rtpChannel.socket().getRemoteSocketAddress());
        }
    }

    public String getExternalAddress() {
        return this.udpManager.getExternalAddress();
    }

    static {
        DTMF_FORMAT.setOptions(new Text("0-15"));
    }

    private class HeartBeat
    extends Task {
        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public long perform() {
            if (RTPDataChannel.this.scheduler.getClock().getTime() - RTPDataChannel.this.lastPacketReceived > (long)RTPDataChannel.this.udpManager.getRtpTimeout() * 1000000000L) {
                if (RTPDataChannel.this.rtpChannelListener != null) {
                    RTPDataChannel.this.rtpChannelListener.onRtpFailure();
                }
            } else {
                RTPDataChannel.this.scheduler.submitHeatbeat((Task)this);
            }
            return 0L;
        }
    }

    private class TxTask {
        private RtpPacket rtpPacket = new RtpPacket(8192, true);
        private RtpPacket oobPacket = new RtpPacket(8192, true);
        private RTPFormat fmt;
        private long timestamp = -1L;
        private long dtmfTimestamp = -1L;

        private TxTask() {
        }

        public void clear() {
            this.timestamp = -1L;
            this.dtmfTimestamp = -1L;
            this.fmt = null;
        }

        public void performDtmf(Frame frame) {
            if (!RTPDataChannel.this.sendDtmf) {
                frame.recycle();
                return;
            }
            if (frame.getTimestamp() / 1000000L == this.dtmfTimestamp) {
                frame.recycle();
                return;
            }
            this.dtmfTimestamp = frame.getTimestamp() / 1000000L;
            this.dtmfTimestamp = RTPDataChannel.this.rtpClock.convertToRtpTime(this.dtmfTimestamp);
            this.oobPacket.wrap(false, 101, RTPDataChannel.this.sn++, this.dtmfTimestamp, RTPDataChannel.this.ssrc, frame.getData(), frame.getOffset(), frame.getLength());
            frame.recycle();
            try {
                if (RTPDataChannel.this.rtpChannel.isConnected()) {
                    RTPDataChannel.this.sendRtpPacket(this.oobPacket);
                    RTPDataChannel.this.txCount++;
                }
            }
            catch (PortUnreachableException e) {
                try {
                    RTPDataChannel.this.rtpChannel.disconnect();
                }
                catch (IOException ex) {
                    RTPDataChannel.this.logger.error((Object)ex);
                }
            }
            catch (Exception e) {
                RTPDataChannel.this.logger.error((Object)e);
            }
        }

        public void perform(Frame frame) {
            if (frame.getFormat() == null) {
                frame.recycle();
                return;
            }
            if (this.fmt == null || !this.fmt.getFormat().matches(frame.getFormat())) {
                this.fmt = RTPDataChannel.this.rtpFormats.getRTPFormat(frame.getFormat());
                if (this.fmt == null) {
                    frame.recycle();
                    return;
                }
                RTPDataChannel.this.rtpClock.setClockRate(this.fmt.getClockRate());
            }
            if (frame.getTimestamp() / 1000000L == this.timestamp) {
                frame.recycle();
                return;
            }
            this.timestamp = frame.getTimestamp() / 1000000L;
            this.timestamp = RTPDataChannel.this.rtpClock.convertToRtpTime(this.timestamp);
            this.rtpPacket.wrap(false, this.fmt.getID(), RTPDataChannel.this.sn++, this.timestamp, RTPDataChannel.this.ssrc, frame.getData(), frame.getOffset(), frame.getLength());
            frame.recycle();
            try {
                if (RTPDataChannel.this.rtpChannel.isConnected()) {
                    RTPDataChannel.this.sendRtpPacket(this.rtpPacket);
                    RTPDataChannel.this.txCount++;
                }
            }
            catch (PortUnreachableException e) {
                try {
                    RTPDataChannel.this.rtpChannel.disconnect();
                }
                catch (IOException ex) {
                    RTPDataChannel.this.logger.error((Object)ex);
                }
            }
            catch (Exception e) {
                RTPDataChannel.this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private class RxTask {
        private RtpPacket rtpPacket = new RtpPacket(8192, true);
        private RTPFormat format;
        private SocketAddress currAddress;

        private RxTask() {
        }

        private void flush() {
            try {
                SocketAddress currAddress = RTPDataChannel.this.rtpChannel.receive(this.rtpPacket.getBuffer());
                this.rtpPacket.getBuffer().clear();
                while (currAddress != null) {
                    currAddress = RTPDataChannel.this.rtpChannel.receive(this.rtpPacket.getBuffer());
                    this.rtpPacket.getBuffer().clear();
                }
            }
            catch (Exception e) {
                RTPDataChannel.this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        public long perform() {
            if (RTPDataChannel.this.isWebRtc && !RTPDataChannel.this.webRtcHandler.isHandshakeComplete()) {
                if (!RTPDataChannel.this.webRtcHandler.isHandshaking()) {
                    RTPDataChannel.this.webRtcHandler.handshake();
                }
            } else {
                this.perform2();
            }
            return 0L;
        }

        private void perform2() {
            try {
                this.currAddress = null;
                try {
                    this.currAddress = RTPDataChannel.this.receiveRtpPacket(this.rtpPacket);
                    if (this.currAddress != null && !RTPDataChannel.this.rtpChannel.isConnected()) {
                        RTPDataChannel.this.rxBuffer.restart();
                        RTPDataChannel.this.rtpChannel.connect(this.currAddress);
                    } else if (this.currAddress != null && RTPDataChannel.this.rxCount == 0L) {
                        RTPDataChannel.this.rxBuffer.restart();
                    }
                }
                catch (PortUnreachableException e) {
                    try {
                        RTPDataChannel.this.rtpChannel.disconnect();
                    }
                    catch (IOException ex) {
                        RTPDataChannel.this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                catch (IOException e) {
                    RTPDataChannel.this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
                while (this.currAddress != null) {
                    RTPDataChannel.this.lastPacketReceived = RTPDataChannel.this.scheduler.getClock().getTime();
                    if (this.rtpPacket.getVersion() != 0 && (RTPDataChannel.this.shouldReceive.booleanValue() || RTPDataChannel.this.shouldLoop.booleanValue()) && this.rtpPacket.getBuffer().limit() > 0) {
                        if (RTPDataChannel.this.shouldLoop.booleanValue() && RTPDataChannel.this.rtpChannel.isConnected()) {
                            RTPDataChannel.this.sendRtpPacket(this.rtpPacket);
                            RTPDataChannel.this.rxCount++;
                            RTPDataChannel.this.txCount++;
                        } else if (!RTPDataChannel.this.shouldLoop.booleanValue()) {
                            this.format = RTPDataChannel.this.rtpFormats.find(this.rtpPacket.getPayloadType());
                            if (this.format != null && this.format.getFormat().matches((Format)DTMF_FORMAT)) {
                                RTPDataChannel.this.dtmfInput.write(this.rtpPacket);
                            } else {
                                RTPDataChannel.this.rxBuffer.write(this.rtpPacket, this.format);
                            }
                            RTPDataChannel.this.rxCount++;
                        }
                    }
                    this.currAddress = RTPDataChannel.this.receiveRtpPacket(this.rtpPacket);
                }
            }
            catch (PortUnreachableException e) {
                try {
                    RTPDataChannel.this.rtpChannel.disconnect();
                }
                catch (IOException ex) {
                    RTPDataChannel.this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            catch (Exception e) {
                RTPDataChannel.this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            RTPDataChannel.this.rtpHandler.isReading = false;
        }
    }

    private class RTCPHandler
    implements ProtocolHandler {
        private RTCPHandler() {
        }

        public void receive(DatagramChannel channel) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void send(DatagramChannel channel) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setKey(SelectionKey key) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isReadable() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isWriteable() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void onClosed() {
        }
    }

    private class RTPHandler
    implements ProtocolHandler {
        private RxTask rx;
        private volatile boolean isReading;
        private SelectionKey selectionKey;

        private RTPHandler() {
            this.rx = new RxTask();
            this.isReading = false;
        }

        public void receive(DatagramChannel channel) {
            RTPDataChannel.this.count++;
            this.rx.perform();
        }

        public boolean isReadable() {
            return !this.isReading;
        }

        public boolean isWriteable() {
            return true;
        }

        private void flush() {
            if (RTPDataChannel.this.rtpChannelBound) {
                this.rx.flush();
            }
        }

        public void onClosed() {
            if (RTPDataChannel.this.rtpChannelListener != null) {
                RTPDataChannel.this.rtpChannelListener.onRtpFailure();
            }
        }

        public void send(DatagramChannel channel) {
        }

        public void setKey(SelectionKey key) {
            this.selectionKey = key;
        }
    }
}

