/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtp;

import java.io.IOException;
import org.mobicents.media.server.component.audio.AudioComponent;
import org.mobicents.media.server.component.audio.AudioInput;
import org.mobicents.media.server.component.audio.AudioOutput;
import org.mobicents.media.server.component.oob.OOBComponent;
import org.mobicents.media.server.component.oob.OOBInput;
import org.mobicents.media.server.component.oob.OOBOutput;
import org.mobicents.media.server.impl.AbstractSink;
import org.mobicents.media.server.impl.rtp.ChannelsManager;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ModeNotSupportedException;
import org.mobicents.media.server.spi.format.AudioFormat;
import org.mobicents.media.server.spi.format.FormatFactory;

public class LocalDataChannel {
    private AudioFormat format = FormatFactory.createAudioFormat((String)"LINEAR", (int)8000, (int)16, (int)1);
    private long period = 20000000L;
    private int packetSize = (int)(this.period / 1000000L) * this.format.getSampleRate() / 1000 * this.format.getSampleSize() / 8;
    private AudioComponent audioComponent;
    private AudioInput input;
    private AudioOutput output;
    private OOBComponent oobComponent;
    private OOBInput oobInput;
    private OOBOutput oobOutput;
    private LocalDataChannel otherChannel = null;

    protected LocalDataChannel(ChannelsManager channelsManager, int channelId) {
        this.audioComponent = new AudioComponent(channelId);
        this.input = new AudioInput(1, this.packetSize);
        this.output = new AudioOutput(channelsManager.getScheduler(), 2);
        this.audioComponent.addInput(this.input);
        this.audioComponent.addOutput(this.output);
        this.oobComponent = new OOBComponent(channelId);
        this.oobInput = new OOBInput(1);
        this.oobOutput = new OOBOutput(channelsManager.getScheduler(), 2);
        this.oobComponent.addInput(this.oobInput);
        this.oobComponent.addOutput(this.oobOutput);
    }

    public AudioInput getAudioInput() {
        return this.input;
    }

    public AudioOutput getAudioOutput() {
        return this.output;
    }

    public AudioComponent getAudioComponent() {
        return this.audioComponent;
    }

    public OOBInput getOOBInput() {
        return this.oobInput;
    }

    public OOBOutput getOOBOutput() {
        return this.oobOutput;
    }

    public OOBComponent getOOBComponent() {
        return this.oobComponent;
    }

    public void join(LocalDataChannel otherChannel) throws IOException {
        if (this.otherChannel != null) {
            throw new IOException("Channel already joined");
        }
        this.otherChannel = otherChannel;
        otherChannel.otherChannel = this;
        this.otherChannel.getAudioOutput().join((AbstractSink)this.input);
        this.otherChannel.getOOBOutput().join((AbstractSink)this.oobInput);
        this.output.join((AbstractSink)this.otherChannel.getAudioInput());
        this.oobOutput.join((AbstractSink)this.otherChannel.getOOBInput());
    }

    public void unjoin() {
        if (this.otherChannel == null) {
            return;
        }
        this.output.deactivate();
        this.oobOutput.deactivate();
        this.output.unjoin();
        this.oobOutput.unjoin();
        this.otherChannel = null;
    }

    public void updateMode(ConnectionMode connectionMode) throws ModeNotSupportedException {
        if (this.otherChannel == null) {
            throw new ModeNotSupportedException("You should join channel first");
        }
        switch (connectionMode) {
            case SEND_ONLY: {
                this.audioComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(true));
                this.oobComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(true));
                this.output.activate();
                this.oobOutput.activate();
                break;
            }
            case RECV_ONLY: {
                this.audioComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(false));
                this.oobComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(false));
                this.output.deactivate();
                this.oobOutput.deactivate();
                break;
            }
            case INACTIVE: {
                this.audioComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
                this.oobComponent.updateMode(Boolean.valueOf(false), Boolean.valueOf(false));
                this.output.deactivate();
                this.oobOutput.deactivate();
                break;
            }
            case SEND_RECV: 
            case CONFERENCE: {
                this.audioComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(true));
                this.oobComponent.updateMode(Boolean.valueOf(true), Boolean.valueOf(true));
                this.output.activate();
                this.oobOutput.activate();
                break;
            }
            case NETWORK_LOOPBACK: {
                throw new ModeNotSupportedException("Loopback not supported on local channel");
            }
        }
    }
}

