/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

public class RtcpSdesItem {
    public static final short RTCP_SDES_END = 0;
    public static final short RTCP_SDES_CNAME = 1;
    public static final short RTCP_SDES_NAME = 2;
    public static final short RTCP_SDES_EMAIL = 3;
    public static final short RTCP_SDES_PHONE = 4;
    public static final short RTCP_SDES_LOC = 5;
    public static final short RTCP_SDES_TOOL = 6;
    public static final short RTCP_SDES_NOTE = 7;
    public static final short RTCP_SDES_PRIV = 8;
    private int type = 0;
    private int length = 0;
    private String text = null;

    public RtcpSdesItem(short type, String text) {
        this.type = type;
        this.text = text;
    }

    protected RtcpSdesItem() {
    }

    protected int decode(byte[] rawData, int offSet) {
        this.type = rawData[offSet++] & 0xFF;
        if (this.type == 0) {
            while (offSet < rawData.length && rawData[offSet] == 0) {
                ++offSet;
            }
            return offSet;
        }
        this.length = (short)rawData[offSet++] & 0xFF;
        byte[] chunkData = new byte[this.length];
        System.arraycopy(rawData, offSet, chunkData, 0, this.length);
        this.text = new String(chunkData);
        return offSet += this.length;
    }

    protected int encode(byte[] rawData, int offSet) {
        byte[] textData = this.text.getBytes();
        this.length = (short)textData.length;
        rawData[offSet++] = (byte)(this.type & 0xFF);
        rawData[offSet++] = (byte)(this.length & 0xFF);
        System.arraycopy(textData, 0, rawData, offSet, this.length);
        return offSet + this.length;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SDES ITEM: \n");
        builder.append("type= ").append(this.resolveType(this.type)).append(", ");
        builder.append("value= ").append(this.text).append(", ");
        builder.append("length= ").append(this.length).append("\n");
        return builder.toString();
    }

    private String resolveType(int type) {
        switch (type) {
            case 0: {
                return "END";
            }
            case 1: {
                return "CNAME";
            }
            case 2: {
                return "NAME";
            }
            case 3: {
                return "EMAIL";
            }
            case 4: {
                return "PHONE";
            }
            case 5: {
                return "LOC";
            }
            case 6: {
                return "TOOL";
            }
            case 7: {
                return "NOTE";
            }
            case 8: {
                return "PRIV";
            }
        }
        return "UNKNOWN";
    }
}

