/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import java.util.ArrayList;
import java.util.List;
import org.mobicents.media.server.impl.rtcp.RtcpSdesItem;

public class RtcpSdesChunk {
    public static final int MAX_ITEMS = 9;
    private long ssrc;
    private final List<RtcpSdesItem> rtcpSdesItems;
    private int itemCount = 0;

    public RtcpSdesChunk(long ssrc) {
        this.ssrc = ssrc;
        this.rtcpSdesItems = new ArrayList<RtcpSdesItem>(9);
    }

    protected RtcpSdesChunk() {
        this.rtcpSdesItems = new ArrayList<RtcpSdesItem>(9);
    }

    protected int decode(byte[] rawData, int offSet) {
        RtcpSdesItem sdesItem;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        do {
            sdesItem = new RtcpSdesItem();
            offSet = sdesItem.decode(rawData, offSet);
            this.addRtcpSdesItem(sdesItem);
        } while (0 != sdesItem.getType());
        return offSet;
    }

    public void addRtcpSdesItem(RtcpSdesItem rtcpSdesItem) {
        if (this.itemCount >= 9) {
            throw new ArrayIndexOutOfBoundsException("Reached maximum number of items: 9");
        }
        this.rtcpSdesItems.add(rtcpSdesItem);
        ++this.itemCount;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public String getCname() {
        for (RtcpSdesItem item : this.rtcpSdesItems) {
            if (1 != item.getType()) continue;
            return item.getText();
        }
        return "";
    }

    public RtcpSdesItem[] getRtcpSdesItems() {
        RtcpSdesItem[] items = new RtcpSdesItem[this.rtcpSdesItems.size()];
        return this.rtcpSdesItems.toArray(items);
    }

    public int getItemCount() {
        return this.itemCount;
    }

    protected int encode(byte[] rawData, int offSet) {
        int temp = offSet;
        rawData[offSet++] = (byte)((this.ssrc & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.ssrc & 0xFFL);
        for (RtcpSdesItem rtcpSdesItem : this.rtcpSdesItems) {
            if (rtcpSdesItem == null) break;
            offSet = rtcpSdesItem.encode(rawData, offSet);
        }
        rawData[offSet++] = 0;
        int remainder = (offSet - temp) % 4;
        if (remainder != 0) {
            int pad = 4 - remainder;
            for (int i = 0; i < pad; ++i) {
                rawData[offSet++] = 0;
            }
        }
        return offSet;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SDES CHUNK:\n");
        builder.append("ssrc= ").append(this.ssrc).append(", ");
        builder.append("item count= ").append(this.itemCount);
        for (RtcpSdesItem item : this.rtcpSdesItems) {
            builder.append("\n").append(item.toString());
        }
        return builder.toString();
    }
}

