/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import java.util.Date;
import java.util.List;
import org.apache.commons.net.ntp.TimeStamp;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtcp.RtcpBye;
import org.mobicents.media.server.impl.rtcp.RtcpPacket;
import org.mobicents.media.server.impl.rtcp.RtcpPacketType;
import org.mobicents.media.server.impl.rtcp.RtcpReceiverReport;
import org.mobicents.media.server.impl.rtcp.RtcpReport;
import org.mobicents.media.server.impl.rtcp.RtcpReportBlock;
import org.mobicents.media.server.impl.rtcp.RtcpSdes;
import org.mobicents.media.server.impl.rtcp.RtcpSdesChunk;
import org.mobicents.media.server.impl.rtcp.RtcpSdesItem;
import org.mobicents.media.server.impl.rtcp.RtcpSenderReport;
import org.mobicents.media.server.impl.rtp.statistics.RtpMember;
import org.mobicents.media.server.impl.rtp.statistics.RtpStatistics;

public class RtcpPacketFactory {
    public static final Logger logger = Logger.getLogger(RtcpPacketFactory.class);

    private static RtcpSenderReport buildSenderReport(RtpStatistics statistics, boolean padding) {
        long ssrc = statistics.getSsrc();
        long currentTime = statistics.getCurrentTime();
        TimeStamp ntpTs = new TimeStamp(new Date(currentTime));
        long ntpSec = ntpTs.getSeconds();
        long ntpFrac = ntpTs.getFraction();
        long elapsedTime = statistics.getCurrentTime() - statistics.getRtpSentOn();
        long rtpTs = statistics.getRtpTimestamp() + statistics.getRtpTime(elapsedTime);
        long psent = statistics.getRtpPacketsSent();
        long osent = statistics.getRtpOctetsSent();
        RtcpSenderReport senderReport = new RtcpSenderReport(padding, ssrc, ntpSec, ntpFrac, rtpTs, psent, osent);
        List<Long> members = statistics.getMembersList();
        for (Long memberSsrc : members) {
            if (ssrc == memberSsrc) continue;
            RtpMember memberStats = statistics.getMember(memberSsrc);
            RtcpReportBlock rcvrReport = RtcpPacketFactory.buildSubReceiverReport(memberStats);
            senderReport.addReceiverReport(rcvrReport);
        }
        return senderReport;
    }

    private static RtcpReceiverReport buildReceiverReport(RtpStatistics statistics, boolean padding) {
        RtcpReceiverReport report = new RtcpReceiverReport(padding, statistics.getSsrc());
        long ssrc = statistics.getSsrc();
        List<Long> members = statistics.getMembersList();
        for (Long memberSsrc : members) {
            if (ssrc == memberSsrc) continue;
            RtpMember memberStats = statistics.getMember(memberSsrc);
            RtcpReportBlock rcvrReport = RtcpPacketFactory.buildSubReceiverReport(memberStats);
            report.addReceiverReport(rcvrReport);
        }
        return report;
    }

    private static RtcpSdes buildSdes(RtpStatistics statistics, boolean padding) {
        RtcpSdes sdes = new RtcpSdes(padding);
        RtcpSdesChunk chunk = new RtcpSdesChunk(statistics.getSsrc());
        RtcpSdesItem cname = new RtcpSdesItem(1, statistics.getCname());
        chunk.addRtcpSdesItem(cname);
        sdes.addRtcpSdesChunk(chunk);
        return sdes;
    }

    private static RtcpReportBlock buildSubReceiverReport(RtpMember statistics) {
        long ssrc = statistics.getSsrc();
        int fraction = (int)statistics.getFractionLost();
        int lost = (int)statistics.getPacketsLost();
        int seqNumCycle = statistics.getSequenceCycle();
        long lastSeq = statistics.getExtHighSequence();
        int jitter = (int)statistics.getJitter();
        long lsr = statistics.getLastSR();
        long dlsr = statistics.getLastSRdelay();
        return new RtcpReportBlock(ssrc, fraction, lost, seqNumCycle, lastSeq, jitter, lsr, dlsr);
    }

    public static RtcpPacket buildReport(RtpStatistics statistics) {
        boolean padding = false;
        RtcpReport report = statistics.hasSent() ? RtcpPacketFactory.buildSenderReport(statistics, padding) : RtcpPacketFactory.buildReceiverReport(statistics, padding);
        RtcpSdes sdes = RtcpPacketFactory.buildSdes(statistics, padding);
        return new RtcpPacket(report, sdes);
    }

    public static RtcpPacket buildBye(RtpStatistics statistics) {
        boolean padding = false;
        RtcpReport report = statistics.hasSent() ? RtcpPacketFactory.buildSenderReport(statistics, padding) : RtcpPacketFactory.buildReceiverReport(statistics, padding);
        RtcpSdes sdes = RtcpPacketFactory.buildSdes(statistics, padding);
        RtcpBye bye = new RtcpBye(padding);
        bye.addSsrc(statistics.getSsrc());
        return new RtcpPacket(report, sdes, bye);
    }

    public static RtcpPacket buildPacket(RtcpPacketType packetType, RtpStatistics statistics) {
        switch (packetType) {
            case RTCP_REPORT: {
                return RtcpPacketFactory.buildReport(statistics);
            }
            case RTCP_BYE: {
                return RtcpPacketFactory.buildBye(statistics);
            }
        }
        throw new IllegalArgumentException("Unsupported RTCP packet type.");
    }
}

