/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtcp.RtcpAppDefined;
import org.mobicents.media.server.impl.rtcp.RtcpBye;
import org.mobicents.media.server.impl.rtcp.RtcpPacketType;
import org.mobicents.media.server.impl.rtcp.RtcpReceiverReport;
import org.mobicents.media.server.impl.rtcp.RtcpReport;
import org.mobicents.media.server.impl.rtcp.RtcpSdes;
import org.mobicents.media.server.impl.rtcp.RtcpSenderReport;

public class RtcpPacket
implements Serializable {
    private static final long serialVersionUID = -7175947723683038337L;
    private static final Logger logger = Logger.getLogger(RtcpPacket.class);
    public static final int MAX_SOURCES = 31;
    private RtcpSenderReport senderReport = null;
    private RtcpReceiverReport receiverReport = null;
    private RtcpSdes sdes = null;
    private RtcpBye bye = null;
    private RtcpAppDefined appDefined = null;
    private int packetCount = 0;
    private int size = 0;

    public RtcpPacket() {
    }

    public RtcpPacket(RtcpSenderReport senderReport, RtcpReceiverReport receiverReport, RtcpSdes sdes, RtcpBye bye, RtcpAppDefined appDefined) {
        this.senderReport = senderReport;
        this.receiverReport = receiverReport;
        this.sdes = sdes;
        this.bye = bye;
        this.appDefined = appDefined;
    }

    public RtcpPacket(RtcpReport report, RtcpSdes sdes, RtcpBye bye) {
        if (report.isSender()) {
            this.senderReport = (RtcpSenderReport)report;
        } else {
            this.receiverReport = (RtcpReceiverReport)report;
        }
        this.sdes = sdes;
        this.bye = bye;
    }

    public RtcpPacket(RtcpReport report, RtcpSdes sdes) {
        this(report, sdes, null);
    }

    public int decode(byte[] rawData, int offSet) {
        this.size = 0;
        block7: while (offSet < rawData.length) {
            int type = rawData[offSet + 1] & 0xFF;
            switch (type) {
                case 200: {
                    ++this.packetCount;
                    this.senderReport = new RtcpSenderReport();
                    offSet = this.senderReport.decode(rawData, offSet);
                    this.size += this.senderReport.length;
                    continue block7;
                }
                case 201: {
                    ++this.packetCount;
                    this.receiverReport = new RtcpReceiverReport();
                    offSet = this.receiverReport.decode(rawData, offSet);
                    this.size += this.receiverReport.length;
                    continue block7;
                }
                case 202: {
                    ++this.packetCount;
                    this.sdes = new RtcpSdes();
                    offSet = this.sdes.decode(rawData, offSet);
                    this.size += this.sdes.length;
                    continue block7;
                }
                case 204: {
                    ++this.packetCount;
                    this.appDefined = new RtcpAppDefined();
                    offSet = this.appDefined.decode(rawData, offSet);
                    this.size += this.appDefined.length;
                    continue block7;
                }
                case 203: {
                    ++this.packetCount;
                    this.bye = new RtcpBye();
                    offSet = this.bye.decode(rawData, offSet);
                    this.size += this.bye.length;
                    continue block7;
                }
            }
            logger.error((Object)("Received type = " + type + " RTCP Packet decoding falsed. offSet = " + offSet + ". Packet count = " + this.packetCount));
            offSet = rawData.length;
        }
        return offSet;
    }

    public int encode(byte[] rawData, int offSet) {
        int initalOffSet = offSet;
        if (this.senderReport != null) {
            ++this.packetCount;
            offSet = this.senderReport.encode(rawData, offSet);
        }
        if (this.receiverReport != null) {
            ++this.packetCount;
            offSet = this.receiverReport.encode(rawData, offSet);
        }
        if (this.sdes != null) {
            ++this.packetCount;
            offSet = this.sdes.encode(rawData, offSet);
        }
        if (this.appDefined != null) {
            ++this.packetCount;
            offSet = this.appDefined.encode(rawData, offSet);
        }
        if (this.bye != null) {
            ++this.packetCount;
            offSet = this.bye.encode(rawData, offSet);
        }
        this.size = offSet - initalOffSet;
        return offSet;
    }

    public boolean isSender() {
        return this.senderReport != null;
    }

    public RtcpPacketType getPacketType() {
        if (this.bye == null) {
            return RtcpPacketType.RTCP_REPORT;
        }
        return RtcpPacketType.RTCP_BYE;
    }

    public RtcpReport getReport() {
        if (this.isSender()) {
            return this.senderReport;
        }
        return this.receiverReport;
    }

    public RtcpSenderReport getSenderReport() {
        return this.senderReport;
    }

    public RtcpReceiverReport getReceiverReport() {
        return this.receiverReport;
    }

    public RtcpSdes getSdes() {
        return this.sdes;
    }

    public RtcpBye getBye() {
        return this.bye;
    }

    public boolean hasBye() {
        return this.bye != null;
    }

    public RtcpAppDefined getAppDefined() {
        return this.appDefined;
    }

    public int getPacketCount() {
        return this.packetCount;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        RtcpReport report = this.getReport();
        if (report != null) {
            builder.append(report.toString());
        }
        if (this.sdes != null) {
            builder.append(this.sdes.toString());
        }
        if (this.bye != null) {
            builder.append(this.bye.toString());
        }
        return builder.toString();
    }
}

