/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import org.mobicents.media.server.impl.utils.XSRandom;

public class RtcpIntervalCalculator {
    public static final double MIN_TIME = 5.0;
    public static final double INITIAL_MIN_TIME = 2.5;
    private static final double COMPENSATION = 1.218281828459045;
    private static final XSRandom RANDOM = new XSRandom();

    public static long calculateInterval(boolean initial, boolean weSent, int senders, int members, double rtcpAvgSize, double rtcpBw, double rtcpBwFraction, double senderBwFraction, double receiverBwFraction) {
        int n;
        double c;
        if ((double)senders <= (double)members * senderBwFraction) {
            if (weSent) {
                c = rtcpAvgSize / (senderBwFraction * rtcpBw);
                n = senders;
            } else {
                c = rtcpAvgSize / (receiverBwFraction * rtcpBw);
                n = members - senders;
            }
        } else {
            c = rtcpAvgSize / rtcpBw;
            n = members;
        }
        double tMin = initial ? 2.5 : 5.0;
        double td = Math.max(tMin, (double)n * c);
        double min = td * 0.5;
        double max = td * 1.5;
        double t = min + (max - min) * RANDOM.nextDouble();
        return (long)(t / 1.218281828459045 * 1000.0);
    }
}

