/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

public abstract class RtcpHeader {
    public static final int RTCP_SR = 200;
    public static final int RTCP_RR = 201;
    public static final int RTCP_SDES = 202;
    public static final int RTCP_BYE = 203;
    public static final int RTCP_APP = 204;
    protected int version;
    protected boolean padding;
    protected int count;
    protected int packetType;
    protected int length;

    protected RtcpHeader() {
        this(false, 0);
    }

    public RtcpHeader(boolean padding, int pt) {
        this.padding = padding;
        this.packetType = pt;
        this.count = 0;
        this.length = 0;
        this.version = 2;
    }

    protected int decode(byte[] rawData, int offSet) {
        int b = rawData[offSet++] & 0xFF;
        this.version = (b & 0xC0) >> 6;
        this.padding = (b & 0x20) == 32;
        this.count = b & 0x1F;
        this.packetType = rawData[offSet++] & 0xFF;
        this.length |= rawData[offSet++] & 0xFF;
        this.length <<= 8;
        this.length |= rawData[offSet++] & 0xFF;
        this.length = this.length * 4 + 4;
        return offSet;
    }

    protected int encode(byte[] rawData, int offSet) {
        rawData[offSet] = (byte)(this.version << 6);
        if (this.padding) {
            rawData[offSet] = (byte)(rawData[offSet] | 0x20);
        }
        rawData[offSet] = (byte)(rawData[offSet] | this.count & 0x1F);
        int n = ++offSet;
        ++offSet;
        rawData[n] = (byte)(this.packetType & 0xFF);
        return offSet += 2;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isPadding() {
        return this.padding;
    }

    public int getCount() {
        return this.count;
    }

    public int getPacketType() {
        return this.packetType;
    }

    public int getLength() {
        return this.length;
    }
}

