/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtcp.RtcpPacket;
import org.mobicents.media.server.impl.rtcp.RtcpPacketFactory;
import org.mobicents.media.server.impl.rtcp.RtcpPacketType;
import org.mobicents.media.server.impl.rtp.statistics.RtpStatistics;
import org.mobicents.media.server.impl.srtp.DtlsHandler;
import org.mobicents.media.server.io.network.channel.PacketHandler;
import org.mobicents.media.server.io.network.channel.PacketHandlerException;

public class RtcpHandler
implements PacketHandler {
    private static final Logger logger = Logger.getLogger(RtcpHandler.class);
    private static final long SSRC_TASK_DELAY = 7000L;
    private DatagramChannel channel;
    private ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8192);
    private int pipelinePriority = 0;
    private Timer txTimer = new Timer();
    private Timer ssrcTimer = new Timer();
    private TxTask scheduledTask;
    private SsrcTask ssrcTask;
    private final RtpStatistics statistics;
    private long tp;
    private long tn;
    private boolean initial;
    private boolean joined;
    private boolean secure;
    private DtlsHandler dtlsHandler;

    public RtcpHandler(RtpStatistics statistics) {
        this.statistics = statistics;
        this.scheduledTask = null;
        this.tp = 0L;
        this.tn = -1L;
        this.initial = true;
        this.joined = false;
        this.secure = false;
        this.dtlsHandler = null;
    }

    public int getPipelinePriority() {
        return this.pipelinePriority;
    }

    public void setPipelinePriority(int pipelinePriority) {
        this.pipelinePriority = pipelinePriority;
    }

    private long resolveInterval(long timestamp) {
        long interval = timestamp - this.statistics.getCurrentTime();
        return interval < 0L ? 0L : interval;
    }

    public void setChannel(DatagramChannel channel) {
        this.channel = channel;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public boolean isJoined() {
        return this.joined;
    }

    public void joinRtpSession() {
        if (!this.joined) {
            long t = this.statistics.rtcpInterval(this.initial);
            this.tn = this.statistics.getCurrentTime() + t;
            this.scheduleRtcp(this.tn, RtcpPacketType.RTCP_REPORT);
            this.ssrcTask = new SsrcTask();
            this.ssrcTimer.schedule((TimerTask)this.ssrcTask, 7000L);
            this.joined = true;
        }
    }

    public void leaveRtpSession() {
        if (this.joined) {
            this.joined = false;
            this.tp = this.statistics.getCurrentTime();
            this.statistics.resetMembers();
            this.initial = true;
            this.statistics.clearSenders();
            this.scheduledTask.cancel();
            this.scheduleNow(RtcpPacketType.RTCP_BYE);
        }
    }

    public long getNextScheduledReport() {
        long delay = this.tn - this.statistics.getCurrentTime();
        return delay < 0L ? -1L : delay;
    }

    private void scheduleRtcp(long timestamp, RtcpPacketType packetType) {
        long interval = this.resolveInterval(timestamp);
        this.scheduledTask = new TxTask(packetType);
        try {
            this.txTimer.schedule((TimerTask)this.scheduledTask, interval);
            this.statistics.setRtcpPacketType(packetType);
        }
        catch (IllegalStateException e) {
            logger.warn((Object)"RTCP timer already canceled. No more reports will be scheduled.");
        }
    }

    private void scheduleNow(RtcpPacketType packetType) {
        this.scheduledTask = new TxTask(packetType);
        try {
            this.txTimer.schedule((TimerTask)this.scheduledTask, 0L);
            this.statistics.setRtcpPacketType(packetType);
        }
        catch (IllegalStateException e) {
            logger.warn((Object)"RTCP timer already canceled. No more reports will be scheduled.");
        }
    }

    private void rescheduleRtcp(TxTask task, long timestamp) {
        task.cancel();
        long interval = this.resolveInterval(timestamp);
        try {
            this.txTimer.schedule((TimerTask)task, interval);
        }
        catch (IllegalStateException e) {
            logger.warn((Object)"RTCP timer already canceled. Scheduled report was canceled and cannot be re-scheduled.");
        }
    }

    private void scheduleSsrc(SsrcTask task, long delay) {
        try {
            this.ssrcTask = new SsrcTask();
            this.ssrcTimer.schedule((TimerTask)this.ssrcTask, 7000L);
        }
        catch (IllegalStateException e) {
            logger.warn((Object)("Could not schedule SSRC task: " + e.getMessage()), (Throwable)e);
        }
    }

    public void enableSRTCP(DtlsHandler dtlsHandler) {
        this.dtlsHandler = dtlsHandler;
        this.secure = true;
    }

    public void disableSRTCP() {
        this.dtlsHandler = null;
        this.secure = false;
    }

    public boolean canHandle(byte[] packet) {
        return this.canHandle(packet, packet.length, 0);
    }

    public boolean canHandle(byte[] packet, int dataLength, int offset) {
        int padding;
        int type;
        int version = (packet[offset] & 0xC0) >> 6;
        return version == 2 && ((type = packet[offset + 1] & 0xFF) == 200 || type == 201) && (padding = (packet[offset] & 0x20) >> 5) == 0;
    }

    public byte[] handle(byte[] packet, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        return this.handle(packet, packet.length, 0, localPeer, remotePeer);
    }

    public byte[] handle(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        if (this.secure && !this.dtlsHandler.isHandshakeComplete()) {
            return null;
        }
        if (!this.canHandle(packet, dataLength, offset)) {
            logger.warn((Object)"Cannot handle incoming packet!");
            throw new PacketHandlerException("Cannot handle incoming packet");
        }
        RtcpPacket rtcpPacket = new RtcpPacket();
        if (this.secure) {
            byte[] decoded = this.dtlsHandler.decodeRTCP(packet, offset, dataLength);
            if (decoded == null || decoded.length == 0) {
                logger.warn((Object)"Could not decode incoming SRTCP packet. Packet will be dropped.");
                return null;
            }
            rtcpPacket.decode(decoded, 0);
        } else {
            rtcpPacket.decode(packet, offset);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\nRECEIVED " + rtcpPacket.toString()));
        }
        this.statistics.onRtcpReceive(rtcpPacket);
        if (RtcpPacketType.RTCP_BYE.equals((Object)rtcpPacket.getPacketType()) && RtcpPacketType.RTCP_REPORT.equals((Object)this.scheduledTask.getPacketType()) && this.statistics.getMembers() < this.statistics.getPmembers()) {
            long tc = this.statistics.getCurrentTime();
            this.tn = tc + (long)(this.statistics.getMembers() / this.statistics.getPmembers()) * (this.tn - tc);
            this.tp = tc - (long)(this.statistics.getMembers() / this.statistics.getPmembers()) * (tc - this.tp);
            this.rescheduleRtcp(this.scheduledTask, this.tn);
            this.statistics.confirmMembers();
        }
        return null;
    }

    private void sendRtcpPacket(RtcpPacket packet) throws IOException {
        RtcpPacketType type;
        if (this.secure && !this.dtlsHandler.isHandshakeComplete()) {
            return;
        }
        RtcpPacketType rtcpPacketType = type = packet.hasBye() ? RtcpPacketType.RTCP_BYE : RtcpPacketType.RTCP_REPORT;
        if (this.channel != null && this.channel.isOpen() && this.channel.isConnected()) {
            byte[] data = new byte[8192];
            packet.encode(data, 0);
            int dataLength = packet.getSize();
            if (this.secure) {
                data = this.dtlsHandler.encodeRTCP(data, 0, dataLength);
                dataLength = data.length;
            }
            this.byteBuffer.clear();
            this.byteBuffer.rewind();
            this.byteBuffer.put(data, 0, dataLength);
            this.byteBuffer.flip();
            this.byteBuffer.rewind();
            if (logger.isDebugEnabled()) {
                logger.info((Object)("\nSENDING " + packet.toString()));
            }
            if (!this.channel.isOpen() || !this.channel.isConnected()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not send " + (Object)((Object)type) + " packet because channel is closed or disconnected."));
                }
                return;
            }
            this.channel.send(this.byteBuffer, this.channel.getRemoteAddress());
            this.initial = false;
            this.statistics.onRtcpSent(packet);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Could not send " + (Object)((Object)type) + " packet because channel is closed or disconnected."));
        }
    }

    public void reset() {
        if (this.joined) {
            throw new IllegalStateException("Cannot reset handler while is part of active RTP session.");
        }
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            this.scheduledTask = null;
        }
        this.txTimer.purge();
        if (this.ssrcTask != null) {
            this.ssrcTask.cancel();
            this.ssrcTask = null;
        }
        this.ssrcTimer.purge();
        this.tp = 0L;
        this.tn = -1L;
        this.initial = true;
        this.joined = false;
        if (this.secure) {
            this.disableSRTCP();
        }
    }

    private void closeChannel() {
        if (this.channel != null) {
            if (this.channel.isConnected()) {
                try {
                    this.channel.disconnect();
                }
                catch (IOException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int compareTo(PacketHandler o) {
        if (o == null) {
            return 1;
        }
        return this.getPipelinePriority() - o.getPipelinePriority();
    }

    private class SsrcTask
    extends TimerTask {
        private SsrcTask() {
        }

        @Override
        public void run() {
            RtcpHandler.this.statistics.isSenderTimeout();
            RtcpHandler.this.scheduleSsrc(new SsrcTask(), 7000L);
        }
    }

    private class TxTask
    extends TimerTask {
        private final RtcpPacketType packetType;

        public TxTask(RtcpPacketType packetType) {
            this.packetType = packetType;
        }

        public RtcpPacketType getPacketType() {
            return this.packetType;
        }

        @Override
        public void run() {
            try {
                this.onExpire();
            }
            catch (IOException e) {
                logger.error((Object)"An error occurred while executing a scheduled task. Stopping handler.", (Throwable)e);
                RtcpHandler.this.reset();
            }
        }

        private void onExpire() throws IOException {
            long tc = RtcpHandler.this.statistics.getCurrentTime();
            switch (this.packetType) {
                case RTCP_REPORT: {
                    if (!RtcpHandler.this.joined) break;
                    long t = RtcpHandler.this.statistics.rtcpInterval(RtcpHandler.this.initial);
                    RtcpHandler.this.tn = RtcpHandler.this.tp + t;
                    if (RtcpHandler.this.tn <= tc) {
                        RtcpPacket report = RtcpPacketFactory.buildReport(RtcpHandler.this.statistics);
                        RtcpHandler.this.sendRtcpPacket(report);
                        RtcpHandler.this.tp = tc;
                        t = RtcpHandler.this.statistics.rtcpInterval(RtcpHandler.this.initial);
                        RtcpHandler.this.tn = tc + t;
                    }
                    RtcpHandler.this.scheduleRtcp(RtcpHandler.this.tn, RtcpPacketType.RTCP_REPORT);
                    RtcpHandler.this.statistics.confirmMembers();
                    break;
                }
                case RTCP_BYE: {
                    long t = 0L;
                    RtcpHandler.this.tn = RtcpHandler.this.tp + t;
                    if (RtcpHandler.this.tn <= tc) {
                        RtcpPacket bye = RtcpPacketFactory.buildBye(RtcpHandler.this.statistics);
                        RtcpHandler.this.statistics.setRtcpAvgSize(bye.getSize());
                        RtcpHandler.this.sendRtcpPacket(bye);
                        RtcpHandler.this.closeChannel();
                        RtcpHandler.this.reset();
                        return;
                    }
                    RtcpHandler.this.scheduleRtcp(RtcpHandler.this.tn, RtcpPacketType.RTCP_BYE);
                    break;
                }
                default: {
                    logger.warn((Object)"Unkown scheduled event type!");
                }
            }
        }
    }
}

