/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import org.mobicents.media.server.impl.rtcp.RtcpHeader;

public class RtcpBye
extends RtcpHeader {
    private long[] ssrcs = new long[31];

    protected RtcpBye() {
    }

    public RtcpBye(boolean padding) {
        super(padding, 203);
    }

    @Override
    protected int decode(byte[] rawData, int offSet) {
        int tmp = offSet;
        offSet = super.decode(rawData, offSet);
        int i = 0;
        while (i < this.count) {
            int n = i;
            this.ssrcs[n] = this.ssrcs[n] | (long)(rawData[offSet++] & 0xFF);
            int n2 = i;
            this.ssrcs[n2] = this.ssrcs[n2] << 8;
            int n3 = i;
            this.ssrcs[n3] = this.ssrcs[n3] | (long)(rawData[offSet++] & 0xFF);
            int n4 = i;
            this.ssrcs[n4] = this.ssrcs[n4] << 8;
            int n5 = i;
            this.ssrcs[n5] = this.ssrcs[n5] | (long)(rawData[offSet++] & 0xFF);
            int n6 = i;
            this.ssrcs[n6] = this.ssrcs[n6] << 8;
            int n7 = i++;
            this.ssrcs[n7] = this.ssrcs[n7] | (long)(rawData[offSet++] & 0xFF);
        }
        return offSet;
    }

    @Override
    protected int encode(byte[] rawData, int offSet) {
        int startPosition = offSet;
        offSet = super.encode(rawData, offSet);
        for (int i = 0; i < this.count; ++i) {
            long ssrc = this.ssrcs[i];
            rawData[offSet++] = (byte)((ssrc & 0xFFFFFFFFFF000000L) >> 24);
            rawData[offSet++] = (byte)((ssrc & 0xFF0000L) >> 16);
            rawData[offSet++] = (byte)((ssrc & 0xFF00L) >> 8);
            rawData[offSet++] = (byte)(ssrc & 0xFFL);
        }
        this.length = (offSet - startPosition - 4) / 4;
        rawData[startPosition + 2] = (byte)((this.length & 0xFF00) >> 8);
        rawData[startPosition + 3] = (byte)(this.length & 0xFF);
        return offSet;
    }

    public void addSsrc(long ssrc) {
        this.ssrcs[this.count++] = ssrc;
    }

    public long[] getSsrcs() {
        return this.ssrcs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BYE:\n");
        builder.append("version= ").append(this.version).append(", ");
        builder.append("padding= ").append(this.padding).append(", ");
        builder.append("source count=").append(this.count).append(", ");
        builder.append("packet type=").append(this.packetType).append(", ");
        builder.append("length=").append(this.length).append(", ");
        for (int i = 0; i < this.ssrcs.length; ++i) {
            builder.append("ssrc= ").append(this.ssrcs[i]);
            if (i >= this.ssrcs.length - 1) continue;
            builder.append(", ");
        }
        builder.append("\n");
        return builder.toString();
    }
}

