/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.rtcp;

import org.mobicents.media.server.impl.rtcp.RtcpHeader;

public class RtcpAppDefined
extends RtcpHeader {
    private byte[] data;
    private String name;
    private long ssrc;

    public RtcpAppDefined() {
    }

    protected RtcpAppDefined(boolean padding, int subType, long ssrc, String name, byte[] data) {
        super(padding, 204);
        this.count = subType;
        this.ssrc = ssrc;
        this.name = name;
        this.data = data;
    }

    @Override
    protected int decode(byte[] rawData, int offSet) {
        int tmp = offSet;
        offSet = super.decode(rawData, offSet);
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        this.ssrc <<= 8;
        this.ssrc |= (long)(rawData[offSet++] & 0xFF);
        byte[] nameBytes = new byte[4];
        System.arraycopy(rawData, offSet, nameBytes, 0, 4);
        this.name = new String(nameBytes);
        this.data = new byte[this.length - 12];
        System.arraycopy(rawData, offSet += 4, this.data, 0, this.data.length);
        return offSet += this.data.length;
    }

    @Override
    protected int encode(byte[] rawData, int offSet) {
        int startPosition = offSet;
        offSet = super.encode(rawData, offSet);
        rawData[offSet++] = (byte)((this.ssrc & 0xFFFFFFFFFF000000L) >> 24);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF0000L) >> 16);
        rawData[offSet++] = (byte)((this.ssrc & 0xFF00L) >> 8);
        rawData[offSet++] = (byte)(this.ssrc & 0xFFL);
        byte[] nameBytes = this.name.getBytes();
        for (int i = 0; i < 4; ++i) {
            rawData[offSet++] = nameBytes[i];
        }
        System.arraycopy(this.data, 0, rawData, offSet, this.data.length);
        this.length = ((offSet += this.data.length) - startPosition - 4) / 4;
        rawData[startPosition + 2] = (byte)((this.length & 0xFF00) >> 8);
        rawData[startPosition + 3] = (byte)(this.length & 0xFF);
        return offSet;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public int getSubType() {
        return this.count;
    }
}

