/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.schema;

import com.github.fge.Thawed;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.schema.SchemaDescriptor;
import com.github.fge.jsonschema.core.schema.SchemaDescriptors;
import com.github.fge.jsonschema.core.schema.SchemaSelectorConfiguration;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

public final class SchemaSelectorConfigurationBuilder
implements Thawed<SchemaSelectorConfiguration> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    final Map<URI, SchemaDescriptor> descriptors = Maps.newHashMap();
    SchemaDescriptor defaultDescriptor;

    SchemaSelectorConfigurationBuilder(SchemaSelectorConfiguration cfg) {
        this.descriptors.putAll(cfg.descriptors);
        this.defaultDescriptor = cfg.defaultDescriptor;
    }

    SchemaSelectorConfigurationBuilder() {
        this.defaultDescriptor = SchemaDescriptors.byDefault();
        SchemaDescriptor descriptor = SchemaDescriptors.draftv3();
        this.descriptors.put(descriptor.getLocator(), descriptor);
        descriptor = SchemaDescriptors.draftv4();
        this.descriptors.put(descriptor.getLocator(), descriptor);
        descriptor = SchemaDescriptors.draftv4HyperSchema();
        this.descriptors.put(descriptor.getLocator(), descriptor);
    }

    public SchemaSelectorConfigurationBuilder setDefaultVersion(SchemaVersion version) {
        BUNDLE.checkNotNull((Object)version, "schemaSelector.nullVersion");
        this.defaultDescriptor = this.descriptors.get(version.getLocation());
        return this;
    }

    public SchemaSelectorConfigurationBuilder addDescriptor(SchemaDescriptor descriptor, boolean makeDefault) {
        URI uri = ((SchemaDescriptor)BUNDLE.checkNotNull((Object)descriptor, "schemaSelector.nullDescriptor")).getLocator();
        BUNDLE.checkArgumentPrintf(this.descriptors.put(uri, descriptor) == null, "schemaSelector.duplicateSchema", new Object[]{uri});
        if (makeDefault) {
            this.defaultDescriptor = descriptor;
        }
        return this;
    }

    public SchemaSelectorConfiguration freeze() {
        return new SchemaSelectorConfiguration(this);
    }
}

