/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.schema;

import com.github.fge.Frozen;
import com.github.fge.jsonschema.core.schema.SchemaDescriptor;
import com.github.fge.jsonschema.core.schema.SchemaSelectorConfigurationBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

public final class SchemaSelectorConfiguration
implements Frozen<SchemaSelectorConfigurationBuilder> {
    final Map<URI, SchemaDescriptor> descriptors = Maps.newHashMap();
    SchemaDescriptor defaultDescriptor;

    public static SchemaSelectorConfigurationBuilder newBuilder() {
        return new SchemaSelectorConfigurationBuilder();
    }

    public static SchemaSelectorConfiguration byDefault() {
        return SchemaSelectorConfiguration.newBuilder().freeze();
    }

    SchemaSelectorConfiguration(SchemaSelectorConfigurationBuilder builder) {
        this.defaultDescriptor = builder.defaultDescriptor;
        this.descriptors.putAll(builder.descriptors);
    }

    public Map<URI, SchemaDescriptor> getDescriptors() {
        return ImmutableMap.copyOf(this.descriptors);
    }

    public SchemaDescriptor getDefaultDescriptor() {
        return this.defaultDescriptor;
    }

    public SchemaSelectorConfigurationBuilder thaw() {
        return new SchemaSelectorConfigurationBuilder(this);
    }
}

