/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.core.exceptions.JsonReferenceException;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.schema.SchemaDescriptor;
import com.github.fge.jsonschema.core.schema.SchemaSelectorConfiguration;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;

@Beta
public final class SchemaSelector {
    private final Map<URI, SchemaDescriptor> descriptors;
    private final SchemaDescriptor defaultDescriptor;

    public SchemaSelector(SchemaSelectorConfiguration cfg) {
        this.defaultDescriptor = cfg.getDefaultDescriptor();
        this.descriptors = ImmutableMap.copyOf(cfg.getDescriptors());
    }

    public SchemaDescriptor selectDescriptor(SchemaTree schemaTree) {
        JsonRef ref;
        JsonNode node = schemaTree.getBaseNode().path("$schema");
        if (!node.isTextual()) {
            return this.defaultDescriptor;
        }
        try {
            ref = JsonRef.fromString(node.textValue());
        }
        catch (JsonReferenceException ignored) {
            return this.defaultDescriptor;
        }
        return (SchemaDescriptor)Optional.fromNullable((Object)this.descriptors.get(ref.getLocator())).or((Object)this.defaultDescriptor);
    }
}

