/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.schema;

import com.github.fge.jsonschema.SchemaVersion;
import com.github.fge.jsonschema.core.keyword.KeywordDescriptor;
import com.github.fge.jsonschema.core.keyword.collectors.DraftV3PointerCollectorDictionary;
import com.github.fge.jsonschema.core.keyword.collectors.DraftV4PointerCollectorDictionary;
import com.github.fge.jsonschema.core.keyword.collectors.PointerCollector;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.keyword.syntax.dictionaries.DraftV3SyntaxCheckerDictionary;
import com.github.fge.jsonschema.core.keyword.syntax.dictionaries.DraftV4HyperSchemaSyntaxCheckerDictionary;
import com.github.fge.jsonschema.core.keyword.syntax.dictionaries.DraftV4SyntaxCheckerDictionary;
import com.github.fge.jsonschema.core.schema.SchemaDescriptor;
import com.github.fge.jsonschema.core.schema.SchemaDescriptorBuilder;
import com.github.fge.jsonschema.core.util.Dictionary;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Beta
public final class SchemaDescriptors {
    private static final SchemaDescriptor DRAFTV4 = SchemaDescriptors.draftv4Descriptor();
    private static final SchemaDescriptor DRAFTV4_HYPERSCHEMA = SchemaDescriptors.draftv4HyperSchemaDescriptor();
    private static final SchemaDescriptor DRAFTV3 = SchemaDescriptors.draftv3Descriptor();
    private static final SchemaDescriptor DEFAULT = DRAFTV4;

    private SchemaDescriptors() {
    }

    public static SchemaDescriptor draftv4() {
        return DRAFTV4;
    }

    public static SchemaDescriptor draftv4HyperSchema() {
        return DRAFTV4_HYPERSCHEMA;
    }

    public static SchemaDescriptor draftv3() {
        return DRAFTV3;
    }

    public static SchemaDescriptor byDefault() {
        return DEFAULT;
    }

    private static SchemaDescriptor draftv4Descriptor() {
        SchemaDescriptorBuilder builder = SchemaDescriptor.newBuilder();
        List<KeywordDescriptor> list = SchemaDescriptors.mergeDicts(DraftV4SyntaxCheckerDictionary.get(), DraftV4PointerCollectorDictionary.get());
        builder.setLocator(SchemaVersion.DRAFTV4.getLocation());
        for (KeywordDescriptor descriptor : list) {
            builder.addKeyword(descriptor);
        }
        return builder.freeze();
    }

    private static SchemaDescriptor draftv4HyperSchemaDescriptor() {
        SchemaDescriptorBuilder builder = SchemaDescriptor.newBuilder();
        List<KeywordDescriptor> list = SchemaDescriptors.mergeDicts(DraftV4HyperSchemaSyntaxCheckerDictionary.get(), DraftV4PointerCollectorDictionary.get());
        builder.setLocator(SchemaVersion.DRAFTV4_HYPERSCHEMA.getLocation());
        for (KeywordDescriptor descriptor : list) {
            builder.addKeyword(descriptor);
        }
        return builder.freeze();
    }

    private static SchemaDescriptor draftv3Descriptor() {
        SchemaDescriptorBuilder builder = SchemaDescriptor.newBuilder();
        List<KeywordDescriptor> list = SchemaDescriptors.mergeDicts(DraftV3SyntaxCheckerDictionary.get(), DraftV3PointerCollectorDictionary.get());
        builder.setLocator(SchemaVersion.DRAFTV3.getLocation());
        for (KeywordDescriptor descriptor : list) {
            builder.addKeyword(descriptor);
        }
        return builder.freeze();
    }

    private static List<KeywordDescriptor> mergeDicts(Dictionary<SyntaxChecker> checkers, Dictionary<PointerCollector> collectors) {
        KeywordDescriptor.Builder builder;
        String name;
        HashMap map = Maps.newHashMap();
        for (Map.Entry<String, SyntaxChecker> entry : checkers.entries().entrySet()) {
            name = entry.getKey();
            builder = (KeywordDescriptor.Builder)map.get(name);
            if (builder == null) {
                builder = KeywordDescriptor.withName(name);
                map.put(name, builder);
            }
            builder.setSyntaxChecker(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : collectors.entries().entrySet()) {
            name = entry.getKey();
            builder = (KeywordDescriptor.Builder)map.get(name);
            if (builder == null) {
                builder = KeywordDescriptor.withName(name);
                map.put(name, builder);
            }
            builder.setPointerCollector((PointerCollector)entry.getValue());
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (KeywordDescriptor.Builder k : map.values()) {
            listBuilder.add((Object)k.build());
        }
        return listBuilder.build();
    }
}

