/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.schema;

import com.github.fge.Thawed;
import com.github.fge.jsonschema.core.keyword.KeywordDescriptor;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.schema.SchemaDescriptor;
import com.github.fge.jsonschema.core.util.URIUtils;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;

@Beta
public final class SchemaDescriptorBuilder
implements Thawed<SchemaDescriptor> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    URI locator;
    final Map<String, KeywordDescriptor> keywords;

    SchemaDescriptorBuilder() {
        this.keywords = Maps.newHashMap();
    }

    SchemaDescriptorBuilder(SchemaDescriptor descriptor) {
        this.locator = descriptor.locator;
        this.keywords = Maps.newHashMap(descriptor.keywords);
    }

    public SchemaDescriptorBuilder setLocator(URI uri) {
        BUNDLE.checkNotNull((Object)uri, "schemaDescriptor.nullLocator");
        URI normalized = URIUtils.normalizeSchemaURI(uri);
        URIUtils.checkSchemaURI(normalized);
        this.locator = normalized;
        return this;
    }

    public SchemaDescriptorBuilder addKeyword(KeywordDescriptor descriptor) {
        BUNDLE.checkNotNull((Object)descriptor, "schemaDescriptor.nullDescriptor");
        this.keywords.put(descriptor.getName(), descriptor);
        return this;
    }

    public SchemaDescriptorBuilder removeKeyword(String name) {
        this.keywords.remove(name);
        return this;
    }

    public SchemaDescriptor freeze() {
        BUNDLE.checkNotNull((Object)this.locator, "schemaDescriptor.nullLocator");
        return new SchemaDescriptor(this);
    }
}

