/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.schema;

import com.github.fge.Frozen;
import com.github.fge.jsonschema.core.keyword.KeywordDescriptor;
import com.github.fge.jsonschema.core.keyword.collectors.PointerCollector;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.schema.SchemaDescriptorBuilder;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.Set;

@Beta
public final class SchemaDescriptor
implements Frozen<SchemaDescriptorBuilder> {
    final URI locator;
    final Map<String, KeywordDescriptor> keywords;

    public static SchemaDescriptorBuilder newBuilder() {
        return new SchemaDescriptorBuilder();
    }

    SchemaDescriptor(SchemaDescriptorBuilder builder) {
        this.locator = builder.locator;
        this.keywords = ImmutableMap.copyOf(builder.keywords);
    }

    public URI getLocator() {
        return this.locator;
    }

    public Set<String> getSupportedKeywords() {
        return this.keywords.keySet();
    }

    public Map<String, SyntaxChecker> getSyntaxCheckers() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, KeywordDescriptor> entry : this.keywords.entrySet()) {
            SyntaxChecker checker = entry.getValue().getSyntaxChecker();
            if (checker == null) continue;
            builder.put((Object)entry.getKey(), (Object)checker);
        }
        return builder.build();
    }

    public Map<String, PointerCollector> getPointerCollectors() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, KeywordDescriptor> entry : this.keywords.entrySet()) {
            PointerCollector collector = entry.getValue().getPointerCollector();
            if (collector == null) continue;
            builder.put((Object)entry.getKey(), (Object)collector);
        }
        return builder.build();
    }

    public SchemaDescriptorBuilder thaw() {
        return new SchemaDescriptorBuilder(this);
    }

    public String toString() {
        return this.locator + " (" + this.keywords.size() + " keywords)";
    }
}

