/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.misc.expand;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.CanonicalSchemaTree;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.walk.SchemaListener;
import com.google.common.annotations.Beta;
import com.google.common.base.Equivalence;
import com.google.common.collect.Iterables;
import com.google.common.collect.Queues;
import java.util.Deque;

@Beta
public final class SchemaExpander
implements SchemaListener<SchemaTree> {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    private final JsonRef baseRef;
    private JsonNode baseNode = MissingNode.getInstance();
    private JsonNode currentNode;
    private JsonPointer path = JsonPointer.empty();
    private final Deque<JsonPointer> paths = Queues.newArrayDeque();

    public SchemaExpander(SchemaTree tree) {
        this.baseRef = tree.getLoadingRef();
        this.baseNode = tree.getBaseNode().deepCopy();
    }

    @Override
    public void enteringPath(JsonPointer path, ProcessingReport report) throws ProcessingException {
        this.paths.push(path);
        this.path = path;
        this.currentNode = (JsonNode)path.get((TreeNode)this.baseNode);
    }

    @Override
    public void visiting(SchemaTree schemaTree, ProcessingReport report) throws ProcessingException {
        JsonNode node = schemaTree.getNode();
        if (EQUIVALENCE.equivalent((Object)node, (Object)this.currentNode)) {
            return;
        }
        JsonNode newNode = node.deepCopy();
        if (this.path.isEmpty()) {
            this.baseNode = this.currentNode = newNode;
            return;
        }
        JsonPointer parent = this.path.parent();
        String token = SchemaExpander.getLastToken(this.path);
        JsonNode parentNode = (JsonNode)parent.get((TreeNode)this.baseNode);
        NodeType type = NodeType.getNodeType((JsonNode)parentNode);
        switch (type) {
            case OBJECT: {
                ((ObjectNode)parentNode).put(token, newNode);
                break;
            }
            case ARRAY: {
                ((ArrayNode)parentNode).set(Integer.parseInt(token), newNode);
                break;
            }
            default: {
                throw new IllegalStateException("was expecting an object or an array");
            }
        }
        this.currentNode = (JsonNode)this.path.get((TreeNode)this.baseNode);
    }

    @Override
    public void exitingPath(JsonPointer path, ProcessingReport report) throws ProcessingException {
        this.path = this.paths.pop();
        this.currentNode = (JsonNode)this.path.get((TreeNode)this.baseNode);
    }

    @Override
    public SchemaTree getValue() {
        return new CanonicalSchemaTree(this.baseRef, this.baseNode);
    }

    private static String getLastToken(JsonPointer ptr) {
        return ((TokenResolver)Iterables.getLast((Iterable)ptr)).getToken().getRaw();
    }
}

