/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.misc.analyzer;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.misc.analyzer.SchemaAnalysis;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.schema.SchemaDescriptor;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.walk.SchemaListener;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class SchemaSyntaxListener
implements SchemaListener<SchemaAnalysis> {
    private final Set<JsonPointer> visited = Sets.newHashSet();
    private final ListProcessingReport messages = new ListProcessingReport();
    private final Set<String> supported;
    private final Map<String, SyntaxChecker> checkers;
    private final MessageBundle bundle;

    public SchemaSyntaxListener(SchemaDescriptor descriptor, MessageBundle bundle) {
        this.supported = descriptor.getSupportedKeywords();
        this.checkers = Maps.newTreeMap();
        this.checkers.putAll(descriptor.getSyntaxCheckers());
        this.bundle = bundle;
    }

    @Override
    public void enteringPath(JsonPointer path, ProcessingReport report) throws ProcessingException {
        this.visited.add(path);
    }

    @Override
    public void visiting(SchemaTree schemaTree, ProcessingReport report) throws ProcessingException {
        JsonNode node = schemaTree.getNode();
        if (!node.isObject()) {
            ProcessingMessage message = new ProcessingMessage().setMessage(this.bundle.getMessage("core.notASchema")).putArgument("found", NodeType.getNodeType((JsonNode)node)).put("schema", schemaTree);
            this.messages.error(message);
            return;
        }
        HashSet fields = Sets.newHashSet((Iterator)node.fieldNames());
        Sets.SetView unknown = Sets.difference((Set)fields, this.supported);
        if (!unknown.isEmpty()) {
            ProcessingMessage message = new ProcessingMessage().put("domain", "syntax").setMessage(this.bundle.getMessage("core.unknownKeywords")).putArgument("ignored", Ordering.natural().sortedCopy((Iterable)unknown));
            this.messages.warn(message);
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, SyntaxChecker> entry : this.checkers.entrySet()) {
            if (!fields.contains(entry.getKey())) continue;
            entry.getValue().checkSyntax(list, this.bundle, this.messages, schemaTree);
        }
    }

    @Override
    public void exitingPath(JsonPointer path, ProcessingReport report) throws ProcessingException {
    }

    @Override
    public SchemaAnalysis getValue() {
        return new SchemaAnalysis(this.visited, this.messages);
    }
}

