/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.misc.analyzer;

import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.google.common.annotations.Beta;
import com.google.common.primitives.Longs;

@Beta
final class SchemaKey {
    private final SchemaTree tree;
    private final long id;
    private final JsonPointer ptr;

    static SchemaKey atRoot(SchemaTree tree) {
        return new SchemaKey(tree, JsonPointer.empty());
    }

    static SchemaKey atPointer(SchemaTree tree) {
        return new SchemaKey(tree);
    }

    private SchemaKey(SchemaTree tree, JsonPointer ptr) {
        this.tree = tree;
        this.id = tree.getId();
        this.ptr = ptr;
    }

    private SchemaKey(SchemaTree tree) {
        this(tree, tree.getPointer());
    }

    SchemaTree getTree() {
        return this.tree;
    }

    public int hashCode() {
        return 31 * Longs.hashCode((long)this.id) + this.ptr.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SchemaKey other = (SchemaKey)obj;
        return this.id == other.id && this.ptr.equals((Object)other.ptr);
    }

    public String toString() {
        return "id: " + this.id + ", ptr: " + this.ptr;
    }
}

