/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.misc.analyzer;

import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.misc.analyzer.SchemaAnalysis;
import com.github.fge.jsonschema.core.misc.analyzer.SchemaKey;
import com.github.fge.jsonschema.core.misc.analyzer.SchemaSyntaxListener;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.schema.SchemaDescriptor;
import com.github.fge.jsonschema.core.schema.SchemaSelector;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.core.walk.DefaultSchemaWalker;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.annotations.Beta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;

@Beta
public final class SchemaAnalyzer {
    private final LoadingCache<SchemaKey, SchemaAnalysis> cache;

    SchemaAnalyzer(MessageBundle bundle, SchemaSelector selector) {
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new SchemaAnalyzerLoader(selector, bundle));
    }

    public ProcessingReport analyze(SchemaTree tree) throws ProcessingException {
        JsonPointer ptr = tree.getPointer();
        try {
            SchemaAnalysis analysis = (SchemaAnalysis)this.cache.get((Object)SchemaKey.atRoot(tree));
            if (!analysis.isVisited(ptr)) {
                analysis = (SchemaAnalysis)this.cache.get((Object)SchemaKey.atPointer(tree));
            }
            return analysis.getReport();
        }
        catch (ExecutionException e) {
            throw (ProcessingException)e.getCause();
        }
    }

    private static final class SchemaAnalyzerLoader
    extends CacheLoader<SchemaKey, SchemaAnalysis> {
        private final SchemaSelector selector;
        private final MessageBundle bundle;

        private SchemaAnalyzerLoader(SchemaSelector selector, MessageBundle bundle) {
            this.selector = selector;
            this.bundle = bundle;
        }

        public SchemaAnalysis load(SchemaKey key) throws ProcessingException {
            SchemaTree tree = key.getTree();
            SchemaDescriptor descriptor = this.selector.selectDescriptor(tree);
            DefaultSchemaWalker walker = new DefaultSchemaWalker(descriptor);
            SchemaSyntaxListener validator = new SchemaSyntaxListener(descriptor, this.bundle);
            ListProcessingReport report = new ListProcessingReport();
            walker.walk(tree, validator, report);
            return validator.getValue();
        }
    }
}

