/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.load;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.download.URIDownloader;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;

public final class URIManager {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private final Map<String, URIDownloader> downloaders;
    private final ObjectReader reader;

    public URIManager() {
        this(LoadingConfiguration.byDefault());
    }

    public URIManager(LoadingConfiguration cfg) {
        this.downloaders = cfg.getDownloaderMap();
        this.reader = cfg.getObjectReader();
    }

    public JsonNode getContent(URI uri) throws ProcessingException {
        BUNDLE.checkNotNull((Object)uri, "jsonRef.nullURI");
        if (!uri.isAbsolute()) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.uriNotAbsolute")).put("uri", uri));
        }
        String scheme = uri.getScheme();
        URIDownloader downloader = this.downloaders.get(scheme);
        if (downloader == null) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.unhandledScheme")).putArgument("scheme", scheme).putArgument("uri", uri));
        }
        try {
            InputStream in = downloader.fetch(uri);
            return this.reader.readTree(in);
        }
        catch (JsonProcessingException e) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.uriNotJson")).putArgument("uri", uri).put("parsingMessage", e.getOriginalMessage()));
        }
        catch (IOException e) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.uriIOError")).putArgument("uri", uri).put("exceptionMessage", e.getMessage()));
        }
    }
}

