/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.keyword;

import com.github.fge.jsonschema.core.keyword.collectors.PointerCollector;
import com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.annotations.Beta;

@Beta
public final class KeywordDescriptor {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private final String name;
    private final PointerCollector pointerCollector;
    private final SyntaxChecker syntaxChecker;

    public static Builder withName(String name) {
        return new Builder(name);
    }

    private KeywordDescriptor(Builder builder) {
        this.name = builder.name;
        this.pointerCollector = builder.pointerCollector;
        this.syntaxChecker = builder.syntaxChecker;
    }

    public String getName() {
        return this.name;
    }

    public PointerCollector getPointerCollector() {
        return this.pointerCollector;
    }

    public SyntaxChecker getSyntaxChecker() {
        return this.syntaxChecker;
    }

    public static final class Builder {
        private final String name;
        private PointerCollector pointerCollector = null;
        private SyntaxChecker syntaxChecker = null;

        private Builder(String name) {
            this.name = (String)BUNDLE.checkNotNull((Object)name, "keywordDescriptor.nullName");
        }

        public Builder setPointerCollector(PointerCollector pointerCollector) {
            this.pointerCollector = (PointerCollector)BUNDLE.checkNotNull((Object)pointerCollector, "keywordDescriptor.nullPointerCollector");
            return this;
        }

        public Builder setSyntaxChecker(SyntaxChecker syntaxChecker) {
            this.syntaxChecker = (SyntaxChecker)BUNDLE.checkNotNull((Object)syntaxChecker, "keywordDescriptor.nullSyntaxChecker");
            return this;
        }

        public KeywordDescriptor build() {
            if (this.pointerCollector != null) {
                BUNDLE.checkArgument(this.syntaxChecker != null, "keywordDescriptor.illegal");
            }
            return new KeywordDescriptor(this);
        }
    }
}

