/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.tx.cmd;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.media.server.mgcp.MgcpEvent;
import org.mobicents.media.server.mgcp.controller.MgcpCall;
import org.mobicents.media.server.mgcp.controller.MgcpConnection;
import org.mobicents.media.server.mgcp.controller.MgcpEndpoint;
import org.mobicents.media.server.mgcp.controller.naming.UnknownEndpointException;
import org.mobicents.media.server.mgcp.message.MgcpRequest;
import org.mobicents.media.server.mgcp.message.MgcpResponse;
import org.mobicents.media.server.mgcp.message.Parameter;
import org.mobicents.media.server.mgcp.tx.Action;
import org.mobicents.media.server.mgcp.tx.cmd.MgcpCommandException;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.scheduler.TaskChain;
import org.mobicents.media.server.utils.Text;

public class DeleteConnectionCmd
extends Action {
    private static final Text CALLID_MISSING = new Text("Missing call identifier");
    private static final Text UNKNOWN_CALL_IDENTIFIER = new Text("Could not find this call with specified identifier");
    private static final Text CONNECTIONID_EXPECTED = new Text("Connection identifier was not specified");
    private static final Text SUCCESS = new Text("Success");
    private MgcpRequest request;
    private Parameter connectionID;
    private Text localName = new Text();
    private Text domainName = new Text();
    private Text[] endpointName = new Text[]{this.localName, this.domainName};
    private MgcpEndpoint endpoint;
    private MgcpEndpoint[] endpoints = new MgcpEndpoint[1];
    private TaskChain handler;
    private int code;
    private Text message;
    private int tx;
    private int rx;
    private static final Logger logger = Logger.getLogger(DeleteConnectionCmd.class);

    public DeleteConnectionCmd(Scheduler scheduler) {
        this.handler = new TaskChain(2, scheduler);
        Delete delete = new Delete();
        Responder responder = new Responder();
        this.handler.add((Task)delete);
        this.handler.add((Task)responder);
        ErrorHandler errorHandler = new ErrorHandler();
        this.setActionHandler(this.handler);
        this.setRollbackHandler(errorHandler);
    }

    private class ErrorHandler
    extends Task {
        public int getQueueNumber() {
            return Scheduler.MANAGEMENT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            DeleteConnectionCmd.this.code = ((MgcpCommandException)DeleteConnectionCmd.this.transaction().getLastError()).getCode();
            DeleteConnectionCmd.this.message = ((MgcpCommandException)DeleteConnectionCmd.this.transaction().getLastError()).getErrorMessage();
            MgcpEvent evt = DeleteConnectionCmd.this.transaction().getProvider().createEvent(2, DeleteConnectionCmd.this.getEvent().getAddress());
            MgcpResponse response = (MgcpResponse)evt.getMessage();
            response.setResponseCode(DeleteConnectionCmd.this.code);
            response.setResponseString(DeleteConnectionCmd.this.message);
            response.setTxID(DeleteConnectionCmd.this.transaction().getId());
            if (DeleteConnectionCmd.this.connectionID != null) {
                response.setParameter(Parameter.CONNECTION_ID, DeleteConnectionCmd.this.connectionID.getValue());
            }
            try {
                DeleteConnectionCmd.this.transaction().getProvider().send(evt);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                evt.recycle();
            }
            return 0L;
        }
    }

    private class Responder
    extends Task {
        public int getQueueNumber() {
            return Scheduler.MANAGEMENT_QUEUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long perform() {
            MgcpEvent evt = DeleteConnectionCmd.this.transaction().getProvider().createEvent(2, DeleteConnectionCmd.this.getEvent().getAddress());
            MgcpResponse response = (MgcpResponse)evt.getMessage();
            response.setResponseCode(200);
            response.setResponseString(SUCCESS);
            response.setTxID(DeleteConnectionCmd.this.transaction().getId());
            if (DeleteConnectionCmd.this.connectionID != null) {
                response.setParameter(Parameter.CONNECTION_ID, DeleteConnectionCmd.this.connectionID.getValue());
            }
            response.setParameter(Parameter.CONNECTION_PARAMETERS, new Text("PS=" + DeleteConnectionCmd.this.tx + ", PR=" + DeleteConnectionCmd.this.rx));
            try {
                DeleteConnectionCmd.this.transaction().getProvider().send(evt);
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            finally {
                evt.recycle();
            }
            return 0L;
        }
    }

    private class EndpointLocator
    extends Task {
        public int getQueueNumber() {
            return Scheduler.MANAGEMENT_QUEUE;
        }

        public long perform() {
            try {
                int n = DeleteConnectionCmd.this.transaction().find(DeleteConnectionCmd.this.localName, DeleteConnectionCmd.this.endpoints);
                if (n == 0) {
                    throw new MgcpCommandException(410, new Text("Endpoint not available"));
                }
                DeleteConnectionCmd.this.endpoint = DeleteConnectionCmd.this.endpoints[0];
                if (DeleteConnectionCmd.this.endpoint.getState() == 3) {
                    throw new MgcpCommandException(410, new Text("Endpoint not available"));
                }
            }
            catch (Exception e) {
                throw new MgcpCommandException(410, new Text("Endpoint not available"));
            }
            return 0L;
        }
    }

    private class Delete
    extends Task {
        public int getQueueNumber() {
            return Scheduler.MANAGEMENT_QUEUE;
        }

        private void deleteForEndpoint(MgcpRequest request) {
            request.getEndpoint().divide('@', DeleteConnectionCmd.this.endpointName);
            try {
                int n = DeleteConnectionCmd.this.transaction().find(DeleteConnectionCmd.this.localName, DeleteConnectionCmd.this.endpoints);
                if (n == 0) {
                    throw new MgcpCommandException(410, new Text("Endpoint not available"));
                }
            }
            catch (UnknownEndpointException e) {
                throw new MgcpCommandException(500, new Text("Endpoint not available"));
            }
            DeleteConnectionCmd.this.endpoint = DeleteConnectionCmd.this.endpoints[0];
            DeleteConnectionCmd.this.endpoint.deleteAllConnections();
        }

        private void deleteForCall(Parameter callID, MgcpRequest request) {
            MgcpCall call = DeleteConnectionCmd.this.transaction().getCall(callID.getValue().hexToInteger(), false);
            if (call == null) {
                throw new MgcpCommandException(516, UNKNOWN_CALL_IDENTIFIER);
            }
            call.deleteConnections();
        }

        public long perform() {
            DeleteConnectionCmd.this.request = (MgcpRequest)DeleteConnectionCmd.this.getEvent().getMessage();
            Parameter callID = DeleteConnectionCmd.this.request.getParameter(Parameter.CALL_ID);
            DeleteConnectionCmd.this.connectionID = DeleteConnectionCmd.this.request.getParameter(Parameter.CONNECTION_ID);
            if (callID == null && DeleteConnectionCmd.this.connectionID == null) {
                this.deleteForEndpoint(DeleteConnectionCmd.this.request);
                return 0L;
            }
            if (callID != null && DeleteConnectionCmd.this.connectionID == null) {
                this.deleteForCall(callID, DeleteConnectionCmd.this.request);
                return 0L;
            }
            if (callID == null) {
                throw new MgcpCommandException(510, CALLID_MISSING);
            }
            MgcpCall call = DeleteConnectionCmd.this.transaction().getCall(callID.getValue().hexToInteger(), false);
            if (call == null) {
                throw new MgcpCommandException(516, UNKNOWN_CALL_IDENTIFIER);
            }
            if (DeleteConnectionCmd.this.connectionID == null) {
                throw new MgcpCommandException(510, CONNECTIONID_EXPECTED);
            }
            DeleteConnectionCmd.this.request.getEndpoint().divide('@', DeleteConnectionCmd.this.endpointName);
            try {
                int n = DeleteConnectionCmd.this.transaction().find(DeleteConnectionCmd.this.localName, DeleteConnectionCmd.this.endpoints);
                if (n == 0) {
                    throw new MgcpCommandException(410, new Text("Endpoint not available"));
                }
            }
            catch (UnknownEndpointException e) {
                throw new MgcpCommandException(500, new Text("Endpoint not available"));
            }
            DeleteConnectionCmd.this.endpoint = DeleteConnectionCmd.this.endpoints[0];
            MgcpConnection connection = DeleteConnectionCmd.this.endpoint.getConnection(DeleteConnectionCmd.this.connectionID.getValue().hexToInteger());
            if (connection != null) {
                DeleteConnectionCmd.this.rx = connection.getPacketsReceived();
                DeleteConnectionCmd.this.tx = connection.getPacketsTransmitted();
                DeleteConnectionCmd.this.endpoint.deleteConnection(DeleteConnectionCmd.this.connectionID.getValue().hexToInteger());
            }
            return 0L;
        }
    }
}

