/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.mgcp.pkg.trunk;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.media.ComponentType;
import org.mobicents.media.server.impl.resource.phone.PhoneSignalDetector;
import org.mobicents.media.server.impl.resource.phone.PhoneSignalGenerator;
import org.mobicents.media.server.mgcp.controller.signal.Event;
import org.mobicents.media.server.mgcp.controller.signal.NotifyImmediately;
import org.mobicents.media.server.mgcp.controller.signal.Signal;
import org.mobicents.media.server.mgcp.pkg.trunk.Options;
import org.mobicents.media.server.scheduler.Scheduler;
import org.mobicents.media.server.scheduler.Task;
import org.mobicents.media.server.spi.MediaType;
import org.mobicents.media.server.spi.tone.ToneDetectorListener;
import org.mobicents.media.server.spi.tone.ToneEvent;
import org.mobicents.media.server.utils.Text;

public class ContinuityTransporder
extends Signal
implements ToneDetectorListener {
    private Event of = new Event(new Text("of"));
    private Event oc = new Event(new Text("oc"));
    private volatile Options options;
    private PhoneSignalGenerator phoneGenerator;
    private PhoneSignalDetector phoneDetector;
    private static final Logger logger = Logger.getLogger(ContinuityTransporder.class);
    private Heartbeat heartbeat;
    public static final Text[] toneOptions = new Text[]{new Text("co1"), new Text("co2")};
    public static final int[] toneValues = new int[]{2010, 1780};
    private Scheduler scheduler;
    private Boolean hasReceivingTone = false;

    public ContinuityTransporder(String name) {
        super(name);
        this.of.add(new NotifyImmediately("N"));
        this.oc.add(new NotifyImmediately("N"));
    }

    @Override
    public void execute() {
        this.phoneGenerator = this.getPhoneGenerator();
        this.phoneDetector = this.getPhoneDetector();
        if (this.phoneGenerator == null || this.phoneDetector == null) {
            this.of.fire(this, new Text("Endpoint is not ss7 endpoint"));
            this.complete();
            return;
        }
        this.options = new Options(this.getTrigger().getParams());
        if (this.options.isDeactivation()) {
            this.endToneReceiving();
        } else {
            if (this.heartbeat == null) {
                this.scheduler = this.getEndpoint().getScheduler();
                this.heartbeat = new Heartbeat(this);
            }
            this.prepareToneReceiving();
        }
    }

    @Override
    public boolean doAccept(Text event) {
        if (!this.of.isActive() && this.of.matches(event)) {
            return true;
        }
        return !this.oc.isActive() && this.oc.matches(event);
    }

    @Override
    public void reset() {
        super.reset();
        this.endToneReceiving();
        if (this.heartbeat != null) {
            this.heartbeat.disable();
        }
        this.oc.reset();
        this.of.reset();
    }

    @Override
    public void cancel() {
        this.endToneReceiving();
        if (this.heartbeat != null) {
            this.heartbeat.disable();
        }
    }

    private PhoneSignalGenerator getPhoneGenerator() {
        return (PhoneSignalGenerator)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.SIGNAL_GENERATOR);
    }

    private PhoneSignalDetector getPhoneDetector() {
        return (PhoneSignalDetector)this.getEndpoint().getResource(MediaType.AUDIO, ComponentType.SIGNAL_DETECTOR);
    }

    private void prepareToneReceiving() {
        int i;
        Boolean found = false;
        for (i = 0; i < toneOptions.length; ++i) {
            if (!toneOptions[i].equals((Object)this.options.getInTone())) continue;
            found = true;
            this.phoneDetector.setFrequency(new int[]{toneValues[i]});
            this.phoneDetector.activate();
            break;
        }
        for (i = 0; i < toneOptions.length; ++i) {
            if (!toneOptions[i].equals((Object)this.options.getOutTone())) continue;
            this.hasReceivingTone = true;
            this.phoneGenerator.setFrequency(new int[]{toneValues[i]});
            break;
        }
        if (!found.booleanValue()) {
            this.of.fire(this, new Text("t/co1"));
            this.complete();
            return;
        }
        this.heartbeat.setTtl(20);
        this.heartbeat.activate();
        this.getEndpoint().getScheduler().submitHeatbeat((Task)this.heartbeat);
        try {
            this.phoneDetector.addListener((ToneDetectorListener)this);
        }
        catch (Exception ex) {
            logger.error((Object)"OPERATION FAILURE", (Throwable)ex);
        }
    }

    private void endToneReceiving() {
        if (this.phoneDetector != null) {
            this.phoneDetector.removeListener((ToneDetectorListener)this);
            this.phoneDetector.deactivate();
            this.phoneDetector = null;
        }
        if (this.phoneGenerator != null) {
            this.phoneGenerator.deactivate();
            this.phoneGenerator = null;
        }
    }

    public void process(ToneEvent event) {
        if (this.phoneDetector != null) {
            this.phoneDetector.removeListener((ToneDetectorListener)this);
            this.phoneDetector.deactivate();
            this.phoneDetector = null;
        }
        this.heartbeat.disable();
        if (!this.hasReceivingTone.booleanValue()) {
            this.of.fire(this, new Text("t/co2"));
            this.complete();
            return;
        }
        this.phoneGenerator.activate();
    }

    private class Heartbeat
    extends Task {
        private AtomicInteger ttl = new AtomicInteger(-1);
        private AtomicBoolean active = new AtomicBoolean(false);
        private Signal signal;

        public Heartbeat(Signal signal) {
            this.signal = signal;
        }

        public int getQueueNumber() {
            return Scheduler.HEARTBEAT_QUEUE;
        }

        public void setTtl(int value) {
            this.ttl.set(value);
        }

        public void disable() {
            this.active.set(false);
        }

        public void activate() {
            this.active.set(true);
        }

        public long perform() {
            if (!this.active.get()) {
                return 0L;
            }
            int ttlValue = this.ttl.get();
            if (ttlValue != 0) {
                if (ttlValue > 0) {
                    this.ttl.set(ttlValue - 1);
                }
                ContinuityTransporder.this.scheduler.submitHeatbeat((Task)this);
                return 0L;
            }
            logger.info((Object)String.format("(%s) Timeout expired waiting for tone", ContinuityTransporder.this.getEndpoint().getLocalName()));
            ContinuityTransporder.this.endToneReceiving();
            ContinuityTransporder.this.oc.fire(this.signal, ContinuityTransporder.this.options.getInTone());
            ContinuityTransporder.this.complete();
            this.disable();
            return 0L;
        }
    }
}

