/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.telephony.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import org.mobicents.servlet.restcomm.dao.ClientsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.entities.Client;
import org.mobicents.servlet.restcomm.util.DigestAuthentication;
import org.mobicents.servlet.restcomm.util.HexadecimalUtils;

public class CallControlHelper {
    static boolean permitted(String authorization, String method, DaoManager daoManager) {
        Map<String, String> map = CallControlHelper.authHeaderToMap(authorization);
        String user = map.get("username");
        String algorithm = map.get("algorithm");
        String realm = map.get("realm");
        String uri = map.get("uri");
        String nonce = map.get("nonce");
        String nc = map.get("nc");
        String cnonce = map.get("cnonce");
        String qop = map.get("qop");
        String response = map.get("response");
        ClientsDao clients = daoManager.getClientsDao();
        Client client = clients.getClient(user);
        if (client != null && 1 == client.getStatus()) {
            String password = client.getPassword();
            String result = DigestAuthentication.response((String)algorithm, (String)user, (String)realm, (String)password, (String)nonce, (String)nc, (String)cnonce, (String)method, (String)uri, null, (String)qop);
            return result.equals(response);
        }
        return false;
    }

    public static boolean checkAuthentication(SipServletRequest request, DaoManager storage) throws IOException {
        String authorization = request.getHeader("Proxy-Authorization");
        String method = request.getMethod();
        if (authorization == null || !CallControlHelper.permitted(authorization, method, storage)) {
            CallControlHelper.authenticate(request);
            return false;
        }
        return true;
    }

    static void authenticate(SipServletRequest request) throws IOException {
        SipServletResponse response = request.createResponse(407);
        String nonce = CallControlHelper.nonce();
        SipURI uri = (SipURI)request.getTo().getURI();
        String realm = uri.getHost();
        String header = CallControlHelper.header(nonce, realm, "Digest");
        response.addHeader("Proxy-Authenticate", header);
        response.send();
    }

    private static Map<String, String> authHeaderToMap(String header) {
        String[] tokens;
        HashMap<String, String> map = new HashMap<String, String>();
        int endOfScheme = header.indexOf(" ");
        map.put("scheme", header.substring(0, endOfScheme).trim());
        for (String token : tokens = header.substring(endOfScheme + 1).split(",")) {
            String[] values = token.trim().split("=");
            map.put(values[0].toLowerCase(), values[1].replace("\"", ""));
        }
        return map;
    }

    static String nonce() {
        byte[] uuid = UUID.randomUUID().toString().getBytes();
        char[] hex = HexadecimalUtils.toHex((byte[])uuid);
        return new String(hex).substring(0, 31);
    }

    static String header(String nonce, String realm, String scheme) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(scheme).append(" ");
        buffer.append("realm=\"").append(realm).append("\", ");
        buffer.append("nonce=\"").append(nonce).append("\"");
        return buffer.toString();
    }

    public static String getUserSipId(SipServletRequest request, boolean useTo) {
        String toUser;
        if (useTo) {
            SipURI toUri = (SipURI)request.getTo().getURI();
            toUser = toUri.getUser();
        } else {
            SipURI toUri = (SipURI)request.getRequestURI();
            toUser = toUri.getUser();
        }
        return toUser;
    }
}

