/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.restcomm.telephony.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Currency;
import java.util.Vector;
import javax.sdp.Connection;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;
import javax.sdp.SessionName;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.mobicents.javax.servlet.sip.SipSessionExt;
import org.mobicents.servlet.restcomm.dao.CallDetailRecordsDao;
import org.mobicents.servlet.restcomm.dao.DaoManager;
import org.mobicents.servlet.restcomm.dao.RegistrationsDao;
import org.mobicents.servlet.restcomm.entities.CallDetailRecord;
import org.mobicents.servlet.restcomm.entities.Client;
import org.mobicents.servlet.restcomm.entities.Registration;
import org.mobicents.servlet.restcomm.entities.Sid;
import org.mobicents.servlet.restcomm.telephony.CallStateChanged;

public class B2BUAHelper {
    public static final String B2BUA_LAST_REQUEST = "lastRequest";
    public static final String B2BUA_LAST_RESPONSE = "lastResponse";
    public static final String B2BUA_LAST_FINAL_RESPONSE = "lastFinalResponse";
    private static final String B2BUA_LINKED_SESSION = "linkedSession";
    private static final String CDR_SID = "callDetailRecord_sid";
    private static final Logger logger = Logger.getLogger(B2BUAHelper.class);
    private static DaoManager daoManager;

    public static boolean redirectToB2BUA(SipServletRequest request, Client client, Client toClient, DaoManager storage, SipFactory sipFactory) throws IOException {
        block12: {
            request.getSession().setAttribute(B2BUA_LAST_REQUEST, (Object)request);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("B2BUA (p2p proxy): Got request:\n" + request.getMethod()));
                logger.info((Object)String.format("B2BUA: Proxying a session between %s and %s", client.getLogin(), toClient.getLogin()));
            }
            if (daoManager == null) {
                daoManager = storage;
            }
            String user = ((SipURI)request.getTo().getURI()).getUser();
            RegistrationsDao registrations = daoManager.getRegistrationsDao();
            Registration registration = registrations.getRegistration(user);
            if (registration != null) {
                String location = registration.getLocation();
                try {
                    SipURI to = (SipURI)sipFactory.createURI(location);
                    SipURI from = (SipURI)sipFactory.createURI(registrations.getRegistration(client.getLogin()).getLocation());
                    SipSession incomingSession = request.getSession();
                    incomingSession.setAttribute(B2BUA_LAST_REQUEST, (Object)request);
                    SipServletRequest outRequest = sipFactory.createRequest(request.getApplicationSession(), request.getMethod(), request.getFrom().getURI(), request.getTo().getURI());
                    outRequest.setRequestURI((URI)to);
                    if (request.getContent() != null) {
                        byte[] sdp = request.getRawContent();
                        String offer = null;
                        if (request.getContentType().equalsIgnoreCase("application/sdp")) {
                            String externalIp = request.getInitialRemoteAddr();
                            String initialIpBeforeLB = request.getHeader("X-Sip-Balancer-InitialRemoteAddr");
                            try {
                                offer = initialIpBeforeLB != null && !initialIpBeforeLB.isEmpty() ? B2BUAHelper.patch(sdp, initialIpBeforeLB) : B2BUAHelper.patch(sdp, externalIp);
                            }
                            catch (SdpException e) {
                                logger.error((Object)"Unexpected exception while patching sdp ", (Throwable)e);
                            }
                        }
                        if (offer != null) {
                            outRequest.setContent(offer, request.getContentType());
                        } else {
                            outRequest.setContent((Object)sdp, request.getContentType());
                        }
                    }
                    SipSession outgoingSession = outRequest.getSession();
                    if (request.isInitial()) {
                        incomingSession.setAttribute(B2BUA_LINKED_SESSION, (Object)outgoingSession);
                        outgoingSession.setAttribute(B2BUA_LINKED_SESSION, (Object)incomingSession);
                    }
                    outgoingSession.setAttribute(B2BUA_LAST_REQUEST, (Object)outRequest);
                    request.createResponse(100).send();
                    request.getSession().setAttribute("toInetUri", (Object)to);
                    ((SipSessionExt)outRequest.getSession()).setBypassLoadBalancer(true);
                    ((SipSessionExt)outRequest.getSession()).setBypassProxy(true);
                    outRequest.send();
                    outRequest.getSession().setAttribute("fromInetUri", (Object)from);
                    CallDetailRecord.Builder builder = CallDetailRecord.builder();
                    builder.setSid(Sid.generate((Sid.Type)Sid.Type.CALL));
                    builder.setDateCreated(DateTime.now());
                    builder.setAccountSid(client.getAccountSid());
                    builder.setTo(toClient.getFriendlyName());
                    builder.setCallerName(client.getFriendlyName());
                    builder.setFrom(client.getFriendlyName());
                    builder.setStatus(CallStateChanged.State.QUEUED.name());
                    builder.setDirection("Client-To-Client");
                    builder.setApiVersion(client.getApiVersion());
                    builder.setPrice(new BigDecimal("0.00"));
                    builder.setPriceUnit(Currency.getInstance("USD"));
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("/").append(client.getApiVersion()).append("/Accounts/");
                    buffer.append(client.getAccountSid().toString()).append("/Calls/");
                    buffer.append(client.getSid().toString());
                    java.net.URI uri = java.net.URI.create(buffer.toString());
                    builder.setUri(uri);
                    CallDetailRecordsDao records = daoManager.getCallDetailRecordsDao();
                    CallDetailRecord callRecord = builder.build();
                    records.addCallDetailRecord(callRecord);
                    incomingSession.setAttribute(CDR_SID, (Object)callRecord.getSid());
                    outgoingSession.setAttribute(CDR_SID, (Object)callRecord.getSid());
                    return true;
                }
                catch (ServletParseException badUriEx) {
                    if (!logger.isInfoEnabled()) break block12;
                    logger.info((Object)String.format("B2BUA: Error parsing Client Contact URI: %s", location), (Throwable)badUriEx);
                }
            }
        }
        return false;
    }

    public static boolean redirectToB2BUA(SipServletRequest request, Client fromClient, SipURI from, SipURI to, String proxyUsername, String proxyPassword, DaoManager storage, SipFactory sipFactory, boolean callToSipUri) {
        request.getSession().setAttribute(B2BUA_LAST_REQUEST, (Object)request);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("B2BUA (p2p proxy for DID and SIP URIs) - : Got request:\n" + request.getMethod()));
            logger.info((Object)String.format("B2BUA: Proxying a session from %s to %s", from, to));
        }
        if (daoManager == null) {
            daoManager = storage;
        }
        try {
            SipSession incomingSession = request.getSession();
            incomingSession.setAttribute(B2BUA_LAST_REQUEST, (Object)request);
            SipServletRequest outRequest = null;
            if (fromClient != null) {
                Address fromAddress = sipFactory.createAddress((URI)from, fromClient.getFriendlyName());
                Address toAddress = sipFactory.createAddress((URI)to, to.getUser());
                outRequest = sipFactory.createRequest(request.getApplicationSession(), request.getMethod(), fromAddress, toAddress);
            } else {
                outRequest = sipFactory.createRequest(request.getApplicationSession(), request.getMethod(), (URI)from, (URI)to);
            }
            outRequest.setRequestURI((URI)to);
            logger.info((Object)("Request: " + request.getMethod() + " content exists: " + request.getContent() != null + " content type: " + request.getContentType() ? 1 : 0));
            if (request.getContent() != null) {
                byte[] sdp = request.getRawContent();
                String offer = null;
                if (request.getContentType().equalsIgnoreCase("application/sdp")) {
                    String externalIp = request.getInitialRemoteAddr();
                    String initialIpBeforeLB = request.getHeader("X-Sip-Balancer-InitialRemoteAddr");
                    try {
                        offer = initialIpBeforeLB != null && !initialIpBeforeLB.isEmpty() ? B2BUAHelper.patch(sdp, initialIpBeforeLB) : B2BUAHelper.patch(sdp, externalIp);
                    }
                    catch (SdpException e) {
                        logger.error((Object)"Unexpected exception while patching sdp ", (Throwable)e);
                    }
                }
                logger.info((Object)("Offer is: " + offer));
                if (offer != null) {
                    outRequest.setContent((Object)offer, request.getContentType());
                } else {
                    outRequest.setContent((Object)sdp, request.getContentType());
                }
            }
            SipSession outgoingSession = outRequest.getSession();
            if (request.isInitial()) {
                incomingSession.setAttribute(B2BUA_LINKED_SESSION, (Object)outgoingSession);
                outgoingSession.setAttribute(B2BUA_LINKED_SESSION, (Object)incomingSession);
            }
            outgoingSession.setAttribute(B2BUA_LAST_REQUEST, (Object)outRequest);
            request.createResponse(100).send();
            request.getSession().setAttribute("toInetUri", (Object)to);
            if (callToSipUri) {
                ((SipSessionExt)outRequest.getSession()).setBypassLoadBalancer(true);
                ((SipSessionExt)outRequest.getSession()).setBypassProxy(true);
            }
            outRequest.send();
            Address originalFromAddress = request.getFrom();
            SipURI originalFromUri = (SipURI)originalFromAddress.getURI();
            int port = originalFromUri.getPort();
            if (port == -1) {
                port = request.getRemotePort();
                originalFromUri.setPort(port);
            }
            outRequest.getSession().setAttribute("fromInetUri", (Object)originalFromUri);
            CallDetailRecord.Builder builder = CallDetailRecord.builder();
            builder.setSid(Sid.generate((Sid.Type)Sid.Type.CALL));
            builder.setDateCreated(DateTime.now());
            builder.setAccountSid(fromClient.getAccountSid());
            builder.setTo(to.toString());
            builder.setCallerName(fromClient.getFriendlyName());
            builder.setFrom(fromClient.getFriendlyName());
            builder.setStatus(CallStateChanged.State.QUEUED.name());
            builder.setDirection("Client-To-Client");
            builder.setApiVersion(fromClient.getApiVersion());
            builder.setPrice(new BigDecimal("0.00"));
            builder.setPriceUnit(Currency.getInstance("USD"));
            StringBuilder buffer = new StringBuilder();
            buffer.append("/").append(fromClient.getApiVersion()).append("/Accounts/");
            buffer.append(fromClient.getAccountSid().toString()).append("/Calls/");
            buffer.append(fromClient.getSid().toString());
            java.net.URI uri = java.net.URI.create(buffer.toString());
            builder.setUri(uri);
            CallDetailRecordsDao records = daoManager.getCallDetailRecordsDao();
            CallDetailRecord callRecord = builder.build();
            records.addCallDetailRecord(callRecord);
            incomingSession.setAttribute(CDR_SID, (Object)callRecord.getSid());
            outgoingSession.setAttribute(CDR_SID, (Object)callRecord.getSid());
            return true;
        }
        catch (IOException exception) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("B2BUA: Error while trying to proxy request from %s to %s", from, to));
                logger.info((Object)("Exception: " + exception));
            }
            return false;
        }
    }

    private static String patch(byte[] data, String externalIp) throws UnknownHostException, SdpException {
        String text = new String(data);
        logger.info((Object)"About to patch ");
        logger.info((Object)("SDP :" + text));
        logger.info((Object)("Using externalIP: " + externalIp));
        SessionDescription sdp = SdpFactory.getInstance().createSessionDescription(text);
        SessionName sessionName = SdpFactory.getInstance().createSessionName("Restcomm B2BUA");
        sdp.setSessionName(sessionName);
        B2BUAHelper.fix(sdp.getConnection(), externalIp);
        Vector descriptions = sdp.getMediaDescriptions(false);
        for (MediaDescription description : descriptions) {
            B2BUAHelper.fix(description.getConnection(), externalIp);
        }
        sdp.getOrigin().setAddress(externalIp);
        return sdp.toString();
    }

    private static void fix(Connection connection, String externalIp) throws UnknownHostException, SdpException {
        InetAddress address;
        if (connection != null && "IN".equals(connection.getNetworkType()) && "IP4".equals(connection.getAddressType()) && ((address = InetAddress.getByName(connection.getAddress())).isSiteLocalAddress() || address.isAnyLocalAddress() || address.isLoopbackAddress())) {
            String ip = address.getHostAddress();
            connection.setAddress(externalIp);
        }
    }

    public static SipServletResponse getLinkedResponse(SipServletMessage message) {
        SipSession linkedB2BUASession = B2BUAHelper.getLinkedSession(message);
        if (linkedB2BUASession != null) {
            SipServletResponse response = (SipServletResponse)linkedB2BUASession.getAttribute(B2BUA_LAST_RESPONSE);
            return response;
        }
        return null;
    }

    public static SipServletRequest getLinkedRequest(SipServletMessage message) {
        SipSession linkedB2BUASession = B2BUAHelper.getLinkedSession(message);
        if (linkedB2BUASession != null) {
            SipServletRequest linkedRequest = (SipServletRequest)linkedB2BUASession.getAttribute(B2BUA_LAST_REQUEST);
            return linkedRequest;
        }
        return null;
    }

    public static SipSession getLinkedSession(SipServletMessage message) {
        SipSession sipSession = null;
        if (message.getSession().isValid()) {
            sipSession = (SipSession)message.getSession().getAttribute(B2BUA_LINKED_SESSION);
        }
        if (sipSession == null) {
            logger.info((Object)"SIP SESSION is NULL");
        }
        return sipSession;
    }

    public static void forwardResponse(SipServletResponse response) throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("B2BUA: Got response: \n %s", response));
        }
        CallDetailRecordsDao records = daoManager.getCallDetailRecordsDao();
        if (response.getStatus() > 200) {
            response.getSession().setAttribute(B2BUA_LAST_FINAL_RESPONSE, (Object)response);
        }
        if (response.getStatus() == 487 || response.getStatus() == 200 && response.getMethod().equalsIgnoreCase("CANCEL")) {
            SipServletRequest request;
            CallDetailRecord callRecord;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"response to CANCEL not forwarding");
            }
            if ((callRecord = records.getCallDetailRecord((Sid)(request = (SipServletRequest)B2BUAHelper.getLinkedSession((SipServletMessage)response).getAttribute(B2BUA_LAST_REQUEST)).getSession().getAttribute(CDR_SID))) != null) {
                logger.info((Object)"CDR found! Updating");
                callRecord = callRecord.setStatus(CallStateChanged.State.CANCELED.name());
                DateTime now = DateTime.now();
                callRecord = callRecord.setEndTime(now);
                int seconds = callRecord.getStartTime() != null ? (int)(DateTime.now().getMillis() - callRecord.getStartTime().getMillis()) / 1000 : 0;
                callRecord = callRecord.setDuration(Integer.valueOf(seconds));
                records.updateCallDetailRecord(callRecord);
            }
            return;
        }
        if (response.getStatus() == 200 && response.getMethod().equalsIgnoreCase("BYE")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"response to BYE not forwarding");
            }
            return;
        }
        response.getSession().setAttribute(B2BUA_LAST_RESPONSE, (Object)response);
        SipServletRequest request = (SipServletRequest)B2BUAHelper.getLinkedSession((SipServletMessage)response).getAttribute(B2BUA_LAST_REQUEST);
        SipServletResponse resp = request.createResponse(response.getStatus());
        SipURI originalURI = null;
        Address contact = null;
        try {
            originalURI = (SipURI)response.getAddressHeader("Contact").getURI();
            ((SipURI)resp.getAddressHeader("Contact").getURI()).setUser(originalURI.getUser());
            contact = resp.getAddressHeader("Contact");
        }
        catch (ServletParseException e1) {
        }
        catch (NullPointerException e2) {
            // empty catch block
        }
        logger.info((Object)("Contact: " + contact));
        CallDetailRecord callRecord = records.getCallDetailRecord((Sid)request.getSession().getAttribute(CDR_SID));
        if (response.getContent() != null) {
            byte[] sdp = response.getRawContent();
            String offer = null;
            if (response.getContentType().equalsIgnoreCase("application/sdp")) {
                Registration registration = daoManager.getRegistrationsDao().getRegistration(callRecord.getTo());
                String externalIp = registration != null ? registration.getLocation().split(":")[1].split("@")[1] : callRecord.getTo().split(":")[1].split("@")[1];
                try {
                    logger.debug((Object)("Got original address from Registration :" + externalIp));
                    offer = B2BUAHelper.patch(sdp, externalIp);
                }
                catch (SdpException e) {
                    logger.error((Object)"Unexpected exception while patching sdp ", (Throwable)e);
                }
                if (offer != null) {
                    resp.setContent(offer, response.getContentType());
                } else {
                    resp.setContent((Object)sdp, response.getContentType());
                }
            }
        }
        resp.send();
        if (callRecord != null) {
            DateTime now;
            logger.info((Object)"CDR found! Updating");
            if (!request.getMethod().equalsIgnoreCase("BYE")) {
                if (response.getStatus() == 100 || response.getStatus() == 180 || response.getStatus() == 183) {
                    callRecord = callRecord.setStatus(CallStateChanged.State.RINGING.name());
                } else if (response.getStatus() == 200 || response.getStatus() == 202) {
                    callRecord = callRecord.setStatus(CallStateChanged.State.IN_PROGRESS.name());
                    callRecord = callRecord.setAnsweredBy(((SipURI)response.getTo().getURI()).getUser());
                    now = DateTime.now();
                    callRecord = callRecord.setStartTime(now);
                } else if (response.getStatus() == 486 || response.getStatus() == 600) {
                    callRecord = callRecord.setStatus(CallStateChanged.State.BUSY.name());
                } else if (response.getStatus() > 400) {
                    callRecord = callRecord.setStatus(CallStateChanged.State.FAILED.name());
                }
            } else {
                callRecord = callRecord.setStatus(CallStateChanged.State.COMPLETED.name());
                now = DateTime.now();
                callRecord = callRecord.setEndTime(now);
                int seconds = (int)((DateTime.now().getMillis() - callRecord.getStartTime().getMillis()) / 1000L);
                callRecord = callRecord.setDuration(Integer.valueOf(seconds));
            }
            records.updateCallDetailRecord(callRecord);
        }
    }

    public static void updateCDR(SipServletMessage message, CallStateChanged.State state) {
        CallDetailRecordsDao records = daoManager.getCallDetailRecordsDao();
        SipServletRequest request = null;
        if (message instanceof SipServletResponse) {
            request = (SipServletRequest)B2BUAHelper.getLinkedSession((SipServletMessage)((SipServletResponse)message)).getAttribute(B2BUA_LAST_REQUEST);
        } else if (message instanceof SipServletRequest) {
            request = (SipServletRequest)message;
        }
        CallDetailRecord callRecord = records.getCallDetailRecord((Sid)request.getSession().getAttribute(CDR_SID));
        if (callRecord != null) {
            logger.info((Object)"CDR found! Updating");
            callRecord = callRecord.setStatus(state.name());
            DateTime now = DateTime.now();
            callRecord = callRecord.setEndTime(now);
            int seconds = callRecord.getStartTime() != null ? (int)(DateTime.now().getMillis() - callRecord.getStartTime().getMillis()) / 1000 : 0;
            callRecord = callRecord.setDuration(Integer.valueOf(seconds));
            records.updateCallDetailRecord(callRecord);
        }
    }

    public static boolean isB2BUASession(SipServletMessage sipMessage) {
        SipSession linkedB2BUASession = B2BUAHelper.getLinkedSession(sipMessage);
        return linkedB2BUASession != null;
    }
}

