/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.SecurityActions;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;

public class WriteAttributeHandler
implements OperationStepHandler {
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("write-attribute", ControllerResolver.getResolver("global")).setParameters(GlobalOperationHandlers.NAME, GlobalOperationHandlers.VALUE).setRuntimeOnly().build();
    public static final OperationStepHandler INSTANCE = new WriteAttributeHandler();
    private ParametersValidator nameValidator = new ParametersValidator();

    WriteAttributeHandler() {
        this.nameValidator.registerValidator(GlobalOperationHandlers.NAME.getName(), new StringLengthValidator(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.nameValidator.validate(operation);
        String attributeName = operation.require(GlobalOperationHandlers.NAME.getName()).asString();
        AttributeAccess attributeAccess = context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
        if (attributeAccess == null) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.unknownAttribute(attributeName)));
        }
        if (attributeAccess.getAccessType() != AttributeAccess.AccessType.READ_WRITE) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.attributeNotWritable(attributeName)));
        }
        OperationStepHandler handler = attributeAccess.getWriteHandler();
        ClassLoader oldTccl = SecurityActions.setThreadContextClassLoader(handler.getClass());
        try {
            handler.execute(context, operation);
        }
        finally {
            SecurityActions.setThreadContextClassLoader(oldTccl);
        }
    }
}

