/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadResourceHandler
extends GlobalOperationHandlers.AbstractMultiTargetHandler
implements OperationStepHandler {
    private static final SimpleAttributeDefinition ATTRIBUTES_ONLY = new SimpleAttributeDefinitionBuilder("attributes-only", ModelType.BOOLEAN).setAllowNull(true).setDefaultValue(new ModelNode(false)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-resource", ControllerResolver.getResolver("global")).setParameters(GlobalOperationHandlers.RECURSIVE, GlobalOperationHandlers.RECURSIVE_DEPTH, GlobalOperationHandlers.PROXIES, GlobalOperationHandlers.INCLUDE_RUNTIME, GlobalOperationHandlers.INCLUDE_DEFAULTS, ATTRIBUTES_ONLY, GlobalOperationHandlers.INCLUDE_ALIASES).setReadOnly().setRuntimeOnly().setReplyType(ModelType.OBJECT).build();
    public static final OperationStepHandler INSTANCE = new ReadResourceHandler();
    private final ParametersValidator validator = new ParametersValidator(){

        @Override
        public void validate(ModelNode operation) throws OperationFailedException {
            super.validate(operation);
            if (operation.hasDefined("attributes-only")) {
                if (operation.hasDefined("recursive")) {
                    throw ControllerMessages.MESSAGES.cannotHaveBothParameters("attributes-only", "recursive");
                }
                if (operation.hasDefined("recursive-depth")) {
                    throw ControllerMessages.MESSAGES.cannotHaveBothParameters("attributes-only", "recursive-depth");
                }
            }
        }
    };

    public ReadResourceHandler() {
        this.validator.registerValidator("recursive", new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator("recursive-depth", new ModelTypeValidator(ModelType.INT, true));
        this.validator.registerValidator("include-runtime", new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator("proxies", new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator("include-defaults", new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator("attributes-only", new ModelTypeValidator(ModelType.BOOLEAN, true));
    }

    @Override
    void doExecute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Locale locale;
        DescriptionProvider descriptionProvider;
        ModelNode nodeDescription;
        this.validator.validate(operation);
        String opName = operation.require("operation").asString();
        ModelNode opAddr = operation.get("address");
        PathAddress address = PathAddress.pathAddress(opAddr);
        int recursiveDepth = operation.get("recursive-depth").asInt(0);
        boolean recursive = recursiveDepth > 0 ? true : operation.get("recursive").asBoolean(false);
        boolean queryRuntime = operation.get("include-runtime").asBoolean(false);
        boolean proxies = operation.get("proxies").asBoolean(false);
        boolean aliases = operation.get("include-aliases").asBoolean(false);
        boolean defaults = operation.get("include-defaults").asBoolean(true);
        boolean attributesOnly = operation.get("attributes-only").asBoolean(false);
        HashMap<String, ModelNode> directAttributes = new HashMap<String, ModelNode>();
        HashMap<String, ModelNode> directChildren = new HashMap<String, ModelNode>();
        HashMap<String, ModelNode> metrics = queryRuntime ? new HashMap<String, ModelNode>() : Collections.emptyMap();
        HashMap<String, ModelNode> otherAttributes = new HashMap<String, ModelNode>();
        LinkedHashMap<PathElement, ModelNode> childResources = recursive ? new LinkedHashMap<PathElement, ModelNode>() : Collections.emptyMap();
        ReadResourceAssemblyHandler assemblyHandler = new ReadResourceAssemblyHandler(directAttributes, metrics, otherAttributes, directChildren, childResources);
        context.addStep(assemblyHandler, queryRuntime ? OperationContext.Stage.VERIFY : OperationContext.Stage.IMMEDIATE, queryRuntime);
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        Resource resource = ReadResourceHandler.nullSafeReadResource(context, registry);
        Map childrenByType = registry != null ? GlobalOperationHandlers.getChildAddresses(context, address, registry, resource, null) : Collections.emptyMap();
        ModelNode model = resource.getModel();
        if (model.isDefined()) {
            for (String string : model.keys()) {
                if (childrenByType.containsKey(string)) continue;
                directAttributes.put(string, model.get(string));
            }
        }
        if (defaults && (nodeDescription = (descriptionProvider = registry.getModelDescription(PathAddress.EMPTY_ADDRESS)).getModelDescription(locale = GlobalOperationHandlers.getLocale(context, operation))).isDefined() && nodeDescription.hasDefined("attributes")) {
            for (String key : nodeDescription.get("attributes").keys()) {
                if (childrenByType.containsKey(key) || directAttributes.containsKey(key) && ((ModelNode)directAttributes.get(key)).isDefined() || !nodeDescription.get("attributes").hasDefined(key) || !nodeDescription.get(new String[]{"attributes", key}).hasDefined("default")) continue;
                directAttributes.put(key, nodeDescription.get(new String[]{"attributes", key, "default"}));
            }
        }
        if (!attributesOnly) {
            for (Map.Entry entry : childrenByType.entrySet()) {
                String childType = (String)entry.getKey();
                Set children = (Set)entry.getValue();
                if (children.isEmpty()) {
                    directAttributes.put(childType, new ModelNode());
                    continue;
                }
                for (String child : children) {
                    if (recursive) {
                        boolean getChild;
                        PathElement childPE = PathElement.pathElement(childType, child);
                        PathAddress relativeAddr = PathAddress.pathAddress(childPE);
                        ImmutableManagementResourceRegistration childReg = registry.getSubModel(relativeAddr);
                        if (childReg == null) {
                            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.noChildRegistry(childType, child)));
                        }
                        boolean proxy = childReg.isRemote();
                        boolean runtimeResource = childReg.isRuntimeOnly();
                        boolean bl = getChild = !runtimeResource || queryRuntime && !proxy || proxies && proxy;
                        if (!aliases && childReg.isAlias()) {
                            getChild = false;
                        }
                        if (!getChild) continue;
                        int newDepth = recursiveDepth > 0 ? recursiveDepth - 1 : 0;
                        ModelNode rrOp = new ModelNode();
                        rrOp.get("operation").set(opName);
                        rrOp.get("address").set(PathAddress.pathAddress(address, childPE).toModelNode());
                        rrOp.get("recursive").set(operation.get("recursive"));
                        rrOp.get("recursive-depth").set(newDepth);
                        rrOp.get("proxies").set(proxies);
                        rrOp.get("include-runtime").set(queryRuntime);
                        rrOp.get("include-aliases").set(aliases);
                        rrOp.get("include-defaults").set(defaults);
                        ModelNode rrRsp = new ModelNode();
                        childResources.put(childPE, rrRsp);
                        OperationStepHandler rrHandler = childReg.getOperationHandler(PathAddress.EMPTY_ADDRESS, opName);
                        context.addStep(rrRsp, rrOp, rrHandler, OperationContext.Stage.IMMEDIATE);
                        continue;
                    }
                    ModelNode childMap = (ModelNode)directChildren.get(childType);
                    if (childMap == null) {
                        childMap = new ModelNode();
                        childMap.setEmptyObject();
                        directChildren.put(childType, childMap);
                    }
                    childMap.get(child);
                }
            }
        }
        Set<String> attributeNames = registry != null ? registry.getAttributeNames(PathAddress.EMPTY_ADDRESS) : Collections.emptySet();
        for (String attributeName : attributeNames) {
            AttributeAccess access = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
            if (access == null || access.getFlags().contains((Object)AttributeAccess.Flag.ALIAS) && !aliases) continue;
            AttributeAccess.Storage storage = access.getStorageType();
            if (!queryRuntime && storage != AttributeAccess.Storage.CONFIGURATION) continue;
            AttributeAccess.AccessType type = access.getAccessType();
            OperationStepHandler handler = access.getReadHandler();
            if (handler == null) continue;
            directAttributes.remove(attributeName);
            ModelNode attributeOperation = new ModelNode();
            attributeOperation.get("address").set(opAddr);
            attributeOperation.get("operation").set("read-attribute");
            attributeOperation.get(GlobalOperationHandlers.NAME.getName()).set(attributeName);
            ModelNode attrResponse = new ModelNode();
            if (type == AttributeAccess.AccessType.METRIC) {
                metrics.put(attributeName, attrResponse);
            } else {
                otherAttributes.put(attributeName, attrResponse);
            }
            context.addStep(attrResponse, attributeOperation, handler, OperationContext.Stage.IMMEDIATE);
        }
        context.stepCompleted();
    }

    private static Resource nullSafeReadResource(OperationContext context, ImmutableManagementResourceRegistration registry) {
        Resource result;
        if (registry != null && registry.isRuntimeOnly()) {
            try {
                result = context.readResource(PathAddress.EMPTY_ADDRESS, false);
            }
            catch (RuntimeException e) {
                result = PlaceholderResource.INSTANCE;
            }
        } else {
            result = context.readResource(PathAddress.EMPTY_ADDRESS, false);
        }
        return result;
    }

    private static class ReadResourceAssemblyHandler
    implements OperationStepHandler {
        private final Map<String, ModelNode> directAttributes;
        private final Map<String, ModelNode> directChildren;
        private final Map<String, ModelNode> metrics;
        private final Map<String, ModelNode> otherAttributes;
        private final Map<PathElement, ModelNode> childResources;

        private ReadResourceAssemblyHandler(Map<String, ModelNode> directAttributes, Map<String, ModelNode> metrics, Map<String, ModelNode> otherAttributes, Map<String, ModelNode> directChildren, Map<PathElement, ModelNode> childResources) {
            this.directAttributes = directAttributes;
            this.metrics = metrics;
            this.otherAttributes = otherAttributes;
            this.directChildren = directChildren;
            this.childResources = childResources;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode value;
            TreeMap<Object, ModelNode> sortedAttributes = new TreeMap<Object, ModelNode>();
            TreeMap<Object, ModelNode> sortedChildren = new TreeMap<Object, ModelNode>();
            boolean failed = false;
            for (Map.Entry<String, ModelNode> entry : this.otherAttributes.entrySet()) {
                value = entry.getValue();
                if (!value.has("failure-description")) {
                    sortedAttributes.put(entry.getKey(), value.get("result"));
                    continue;
                }
                if (failed || !value.hasDefined("failure-description")) continue;
                context.getFailureDescription().set(value.get("failure-description"));
                failed = true;
                break;
            }
            if (!failed) {
                for (Map.Entry<Object, ModelNode> entry : this.childResources.entrySet()) {
                    PathElement path = (PathElement)entry.getKey();
                    ModelNode value2 = entry.getValue();
                    if (!value2.has("failure-description")) {
                        ModelNode childTypeNode = (ModelNode)sortedChildren.get(path.getKey());
                        if (childTypeNode == null) {
                            childTypeNode = new ModelNode();
                            sortedChildren.put(path.getKey(), childTypeNode);
                        }
                        childTypeNode.get(path.getValue()).set(value2.get("result"));
                        continue;
                    }
                    if (failed || !value2.hasDefined("failure-description")) continue;
                    context.getFailureDescription().set(value2.get("failure-description"));
                    failed = true;
                }
            }
            if (!failed) {
                for (Map.Entry<Object, ModelNode> entry : this.directAttributes.entrySet()) {
                    sortedAttributes.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<Object, ModelNode> entry : this.directChildren.entrySet()) {
                    sortedChildren.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<Object, ModelNode> entry : this.metrics.entrySet()) {
                    value = entry.getValue();
                    if (value.has("failure-description")) continue;
                    sortedAttributes.put(entry.getKey(), value.get("result"));
                }
                ModelNode result = context.getResult();
                result.setEmptyObject();
                for (Map.Entry entry : sortedAttributes.entrySet()) {
                    result.get((String)entry.getKey()).set((ModelNode)entry.getValue());
                }
                for (Map.Entry entry : sortedChildren.entrySet()) {
                    result.get((String)entry.getKey()).set((ModelNode)entry.getValue());
                }
            }
            context.stepCompleted();
        }
    }
}

