/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParallelBootOperationContext;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class ParallelBootOperationStepHandler
implements OperationStepHandler {
    private final Executor executor;
    private final ImmutableManagementResourceRegistration rootRegistration;
    private final ControlledProcessState processState;
    private final Map<String, List<ParsedBootOp>> opsBySubsystem = new LinkedHashMap<String, List<ParsedBootOp>>();

    ParallelBootOperationStepHandler(ExecutorService executorService, ImmutableManagementResourceRegistration rootRegistration, ControlledProcessState processState) {
        this.executor = executorService;
        this.rootRegistration = rootRegistration;
        this.processState = processState;
    }

    boolean addSubsystemOperation(ParsedBootOp parsedOp) {
        String subsystemName = this.getSubsystemName(parsedOp.address);
        if (subsystemName != null) {
            List<ParsedBootOp> list = this.opsBySubsystem.get(subsystemName);
            if (list == null) {
                list = new ArrayList<ParsedBootOp>();
                this.opsBySubsystem.put(subsystemName, list);
            }
            list.add(parsedOp);
        }
        return subsystemName != null;
    }

    private String getSubsystemName(PathAddress address) {
        String key = null;
        if (address.size() > 0 && "subsystem".equals(address.getElement(0).getKey())) {
            key = address.getElement(0).getValue();
        }
        return key;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (!context.isNormalServer()) {
            throw ControllerMessages.MESSAGES.fullServerBootRequired(this.getClass());
        }
        long start = System.currentTimeMillis();
        context.getResourceRegistrationForUpdate();
        Resource rootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        context.acquireControllerLock();
        LinkedHashMap<String, List<ParsedBootOp>> runtimeOpsBySubsystem = new LinkedHashMap<String, List<ParsedBootOp>>();
        final LinkedHashMap<String, ParallelBootTransactionControl> transactionControls = new LinkedHashMap<String, ParallelBootTransactionControl>();
        CountDownLatch preparedLatch = new CountDownLatch(this.opsBySubsystem.size());
        final CountDownLatch committedLatch = new CountDownLatch(1);
        final CountDownLatch completeLatch = new CountDownLatch(this.opsBySubsystem.size());
        Thread controllingThread = Thread.currentThread();
        for (Map.Entry<String, List<ParsedBootOp>> entry : this.opsBySubsystem.entrySet()) {
            String subsystemName = entry.getKey();
            ArrayList<ParsedBootOp> arrayList = new ArrayList<ParsedBootOp>();
            runtimeOpsBySubsystem.put(subsystemName, arrayList);
            ParallelBootTransactionControl txControl = new ParallelBootTransactionControl(preparedLatch, committedLatch, completeLatch);
            transactionControls.put(entry.getKey(), txControl);
            ParallelBootTask subsystemTask = new ParallelBootTask(subsystemName, entry.getValue(), context, txControl, arrayList, controllingThread);
            this.executor.execute(subsystemTask);
        }
        try {
            preparedLatch.await();
            this.checkForSubsystemFailures(context, transactionControls, OperationContext.Stage.MODEL);
            List loggingOps = (List)runtimeOpsBySubsystem.remove("logging");
            if (loggingOps != null) {
                for (ParsedBootOp loggingOp : loggingOps) {
                    context.addStep(loggingOp.response, loggingOp.operation, loggingOp.handler, OperationContext.Stage.RUNTIME);
                }
            }
            LinkedHashMap<String, Resource> subsystemResources = new LinkedHashMap<String, Resource>();
            for (String string : this.opsBySubsystem.keySet()) {
                Resource resource = rootResource.removeChild(PathElement.pathElement("subsystem", string));
                if (resource == null) continue;
                subsystemResources.put(string, resource);
            }
            for (Map.Entry entry : subsystemResources.entrySet()) {
                rootResource.registerChild(PathElement.pathElement("subsystem", (String)entry.getKey()), (Resource)entry.getValue());
            }
            context.addStep(this.getRuntimeStep(runtimeOpsBySubsystem), OperationContext.Stage.RUNTIME);
        }
        catch (InterruptedException e) {
            context.getFailureDescription().set(new ModelNode().set(ControllerMessages.MESSAGES.subsystemBootInterrupted()));
            Thread.currentThread().interrupt();
        }
        if (ControllerLogger.MGMT_OP_LOGGER.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - start;
            ControllerLogger.MGMT_OP_LOGGER.debugf("Ran subsystem model operations in [%d] ms", elapsed);
        }
        context.completeStep(new OperationContext.ResultHandler(){

            @Override
            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                ParallelBootOperationStepHandler.this.notifySubsystemTransactions(transactionControls, resultAction == OperationContext.ResultAction.ROLLBACK, committedLatch, OperationContext.Stage.RUNTIME);
                try {
                    completeLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    private void checkForSubsystemFailures(OperationContext context, Map<String, ParallelBootTransactionControl> transactionControls, OperationContext.Stage stage) {
        boolean failureRecorded = false;
        for (Map.Entry<String, ParallelBootTransactionControl> entry : transactionControls.entrySet()) {
            ParallelBootTransactionControl txControl = entry.getValue();
            if (txControl.transaction == null) {
                String failureDesc = txControl.response.hasDefined("failure-description") ? txControl.response.get("failure-description").toString() : ControllerMessages.MESSAGES.subsystemBootOperationFailed(entry.getKey());
                ControllerLogger.MGMT_OP_LOGGER.error(failureDesc);
                if (failureRecorded) continue;
                context.getFailureDescription().set(failureDesc);
                failureRecorded = true;
                continue;
            }
            ControllerLogger.MGMT_OP_LOGGER.debugf("Stage %s boot ops for subsystem %s succeeded", (Object)stage, entry.getKey());
        }
    }

    private void notifySubsystemTransactions(Map<String, ParallelBootTransactionControl> transactionControls, boolean rollback, CountDownLatch committedLatch, OperationContext.Stage stage) {
        for (Map.Entry<String, ParallelBootTransactionControl> entry : transactionControls.entrySet()) {
            ParallelBootTransactionControl txControl = entry.getValue();
            if (txControl.transaction == null) continue;
            if (!rollback) {
                txControl.transaction.commit();
                ControllerLogger.MGMT_OP_LOGGER.debugf("Committed transaction for %s subsystem %s stage boot operations", entry.getKey(), (Object)stage);
                continue;
            }
            txControl.transaction.rollback();
            ControllerLogger.MGMT_OP_LOGGER.debugf("Rolled back transaction for %s subsystem %s stage boot operations", entry.getKey(), (Object)stage);
        }
        committedLatch.countDown();
    }

    private OperationStepHandler getRuntimeStep(final Map<String, List<ParsedBootOp>> runtimeOpsBySubsystem) {
        return new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                long start = System.currentTimeMillis();
                context.getServiceRegistry(true);
                final LinkedHashMap<String, ParallelBootTransactionControl> transactionControls = new LinkedHashMap<String, ParallelBootTransactionControl>();
                CountDownLatch preparedLatch = new CountDownLatch(runtimeOpsBySubsystem.size());
                final CountDownLatch committedLatch = new CountDownLatch(1);
                final CountDownLatch completeLatch = new CountDownLatch(runtimeOpsBySubsystem.size());
                Thread controllingThread = Thread.currentThread();
                for (Map.Entry entry : runtimeOpsBySubsystem.entrySet()) {
                    String subsystemName = (String)entry.getKey();
                    ParallelBootTransactionControl txControl = new ParallelBootTransactionControl(preparedLatch, committedLatch, completeLatch);
                    transactionControls.put(subsystemName, txControl);
                    ParallelBootTask subsystemTask = new ParallelBootTask(subsystemName, (List)entry.getValue(), context, txControl, null, controllingThread);
                    ParallelBootOperationStepHandler.this.executor.execute(subsystemTask);
                }
                try {
                    preparedLatch.await();
                    ParallelBootOperationStepHandler.this.checkForSubsystemFailures(context, transactionControls, OperationContext.Stage.RUNTIME);
                }
                catch (InterruptedException e) {
                    context.getFailureDescription().set(new ModelNode().set(ControllerMessages.MESSAGES.subsystemBootInterrupted()));
                    Thread.currentThread().interrupt();
                }
                if (ControllerLogger.MGMT_OP_LOGGER.isDebugEnabled()) {
                    long elapsed = System.currentTimeMillis() - start;
                    ControllerLogger.MGMT_OP_LOGGER.debugf("Ran subsystem runtime operations in [%d] ms", elapsed);
                }
                context.completeStep(new OperationContext.ResultHandler(){

                    @Override
                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        ParallelBootOperationStepHandler.this.notifySubsystemTransactions(transactionControls, resultAction == OperationContext.ResultAction.ROLLBACK, committedLatch, OperationContext.Stage.MODEL);
                        try {
                            completeLatch.await();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                });
            }
        };
    }

    private static class ParallelBootTransactionControl
    implements ProxyController.ProxyOperationControl {
        private final CountDownLatch preparedLatch;
        private final CountDownLatch committedLatch;
        private final CountDownLatch completeLatch;
        private ModelNode response;
        private ModelController.OperationTransaction transaction;
        private boolean signalled;

        public ParallelBootTransactionControl(CountDownLatch preparedLatch, CountDownLatch committedLatch, CountDownLatch completeLatch) {
            this.preparedLatch = preparedLatch;
            this.committedLatch = committedLatch;
            this.completeLatch = completeLatch;
        }

        @Override
        public void operationFailed(ModelNode response) {
            if (!this.signalled) {
                this.response = response;
                this.preparedLatch.countDown();
                this.completeLatch.countDown();
                this.signalled = true;
            }
        }

        @Override
        public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            if (!this.signalled) {
                this.transaction = transaction;
                this.preparedLatch.countDown();
                this.signalled = true;
                try {
                    this.committedLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw ControllerMessages.MESSAGES.transactionInterrupted();
                }
            }
        }

        @Override
        public void operationCompleted(ModelNode response) {
            this.response = response;
            this.completeLatch.countDown();
        }
    }

    private class ParallelBootTask
    implements Runnable {
        private final String subsystemName;
        private final List<ParsedBootOp> bootOperations;
        private final OperationContext primaryContext;
        private final OperationContext.Stage executionStage;
        private final ParallelBootTransactionControl transactionControl;
        private final List<ParsedBootOp> runtimeOps;
        private final Thread controllingThread;

        public ParallelBootTask(String subsystemName, List<ParsedBootOp> bootOperations, OperationContext primaryContext, ParallelBootTransactionControl transactionControl, List<ParsedBootOp> runtimeOps, Thread controllingThread) {
            this.subsystemName = subsystemName;
            this.bootOperations = bootOperations;
            this.primaryContext = primaryContext;
            this.executionStage = primaryContext.getCurrentStage();
            this.transactionControl = transactionControl;
            this.runtimeOps = runtimeOps;
            this.controllingThread = controllingThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean interrupted = false;
            ParallelBootOperationContext operationContext = null;
            try {
                operationContext = new ParallelBootOperationContext(this.transactionControl, ParallelBootOperationStepHandler.this.processState, this.primaryContext, this.runtimeOps, this.controllingThread);
                for (ParsedBootOp op : this.bootOperations) {
                    OperationStepHandler osh = op.handler == null ? ParallelBootOperationStepHandler.this.rootRegistration.getOperationHandler(op.address, op.operationName) : op.handler;
                    operationContext.addStep(op.response, op.operation, osh, this.executionStage);
                }
                operationContext.executeOperation();
            }
            catch (Throwable t) {
                block23: {
                    try {
                        interrupted = t instanceof InterruptedException;
                        ControllerLogger.MGMT_OP_LOGGER.failedSubsystemBootOperations(t, this.subsystemName);
                        if (this.transactionControl.signalled) break block23;
                        ModelNode failure = new ModelNode();
                        failure.get("success").set(false);
                        failure.get("failure-description").set(t.toString());
                        this.transactionControl.operationFailed(failure);
                    }
                    catch (Throwable throwable) {
                        if (!this.transactionControl.signalled) {
                            for (ParsedBootOp op : this.bootOperations) {
                                if (!op.response.hasDefined("success") || op.response.get("success").asBoolean()) continue;
                                this.transactionControl.operationFailed(op.response);
                                break;
                            }
                            if (!this.transactionControl.signalled) {
                                ModelNode failure = new ModelNode();
                                failure.get("success").set(false);
                                failure.get("failure-description").set(ControllerMessages.MESSAGES.subsystemBootOperationFailedExecuting(this.subsystemName));
                                this.transactionControl.operationFailed(failure);
                            }
                        } else {
                            this.transactionControl.operationCompleted(this.transactionControl.response);
                        }
                        if (operationContext != null) {
                            operationContext.close();
                        }
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                        throw throwable;
                    }
                }
                if (!this.transactionControl.signalled) {
                    for (ParsedBootOp op : this.bootOperations) {
                        if (!op.response.hasDefined("success") || op.response.get("success").asBoolean()) continue;
                        this.transactionControl.operationFailed(op.response);
                        break;
                    }
                    if (!this.transactionControl.signalled) {
                        ModelNode failure = new ModelNode();
                        failure.get("success").set(false);
                        failure.get("failure-description").set(ControllerMessages.MESSAGES.subsystemBootOperationFailedExecuting(this.subsystemName));
                        this.transactionControl.operationFailed(failure);
                    }
                } else {
                    this.transactionControl.operationCompleted(this.transactionControl.response);
                }
                if (operationContext != null) {
                    operationContext.close();
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (!this.transactionControl.signalled) {
                for (ParsedBootOp op : this.bootOperations) {
                    if (!op.response.hasDefined("success") || op.response.get("success").asBoolean()) continue;
                    this.transactionControl.operationFailed(op.response);
                    break;
                }
                if (!this.transactionControl.signalled) {
                    ModelNode failure = new ModelNode();
                    failure.get("success").set(false);
                    failure.get("failure-description").set(ControllerMessages.MESSAGES.subsystemBootOperationFailedExecuting(this.subsystemName));
                    this.transactionControl.operationFailed(failure);
                }
            } else {
                this.transactionControl.operationCompleted(this.transactionControl.response);
            }
            if (operationContext != null) {
                operationContext.close();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

