/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.video;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxy;
import com.vendor.dialogic.javax.media.mscontrol.DlgcProxyHelper;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSync2AsyncMonitor;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynCallbackImpl;
import com.vendor.dialogic.javax.media.mscontrol.asyncMgr.DlgcAsynDispatcher;
import com.vendor.dialogic.javax.media.mscontrol.mixer.DlgcXMediaMixer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.UnsupportedException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.resource.ResourceContainer;
import javax.media.mscontrol.resource.video.VideoLayout;
import javax.media.mscontrol.resource.video.VideoRenderer;
import javax.media.mscontrol.resource.video.VideoRendererEvent;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcVideoRendererProxy
extends DlgcProxy
implements VideoRenderer,
Serializable {
    private static final long serialVersionUID = 1L;
    private Lock confSetLayoutLock = new ReentrantLock();
    private static Logger log = LoggerFactory.getLogger(DlgcVideoRendererProxy.class);

    public DlgcVideoRendererProxy(String id, String mediaSessionId, String msObjId) {
        super(id, mediaSessionId, msObjId);
    }

    public MediaSession getMediaSession() {
        return DlgcProxyHelper.getMediaSession(this);
    }

    public void setLayout(final VideoLayout layout) throws MsControlException {
        boolean wasUnlocked = false;
        try {
            final String mediaId = this.getMsObjectId();
            final String containerProxId = this.getContainerProxyId();
            String sasId = this.getProxyId();
            this.confSetLayoutLock.lock();
            DlgcMediaSession session = (DlgcMediaSession)this.getMediaSessionX();
            DlgcAsynDispatcher myAsyncDispatcher = session.getAsyncDispatcher();
            final DlgcSync2AsyncMonitor monitor = new DlgcSync2AsyncMonitor("VideoRender:setLayout Request");
            DlgcAsynDispatcher.asyncDispatch(sasId, new DlgcAsynCallbackImpl(){
                private static final long serialVersionUID = 1L;

                @Override
                public void run(SipApplicationSession appSession) {
                    log.debug("Entering DlgcVideoRendererProxy::setLayout Task run() => Media Server");
                    DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
                    session.setRequestTypeToProxy();
                    DlgcXMediaMixer mx = (DlgcXMediaMixer)session.getMediaObjectByProxyId(containerProxId);
                    if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                        mx.setMonitor(monitor);
                    }
                    mx.setVideoLayout(layout);
                    mx.getProxy().saveMediaSession(appSession, session);
                    log.debug("Exiting DlgcVideoRenderer::setLayout Task run() => Media Server");
                }
            });
            if (DlgcInstrumentPropertyMgr.bSync309ApiSupport) {
                log.debug("SYNC_2_ASYNC setLayout:: OUTSIDE Waiting synchronously for setLayout request to return");
                monitor.waitForRequestCompletion();
                log.debug("SYNC_2_ASYNC setLayout: OUTSIDE setLayout Monitor returned with the following status: " + monitor.getStatusString());
                boolean status = monitor.getStatus();
                String statusMsg = monitor.getStatusString();
                DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS extype = monitor.getExceptionType();
                DlgcXMediaMixer mx = (DlgcXMediaMixer)session.getMediaObjectByProxyId(containerProxId);
                mx.setMonitor(null);
                if (!status) {
                    if (extype.compareTo(DlgcSync2AsyncMonitor.TYPE_OF_EXCEPTIONS.UNSUPPORTED_EXCEPTION) == 0) {
                        log.debug("DlgcVideoRendererProxy-Exception ... executing Monitor Notify UNSUPPORTED method");
                        wasUnlocked = true;
                        this.confSetLayoutLock.unlock();
                        throw new UnsupportedException(statusMsg);
                    }
                    log.debug("DlgcVideoRendererProxy-Exception ... executing Monitor Notify MsControl method");
                    wasUnlocked = true;
                    this.confSetLayoutLock.unlock();
                    throw new MsControlException(statusMsg);
                }
                this.confSetLayoutLock.unlock();
            }
        }
        catch (Exception e) {
            if (e instanceof UnsupportedException) {
                if (!wasUnlocked) {
                    this.confSetLayoutLock.unlock();
                }
                throw new UnsupportedException(e.getMessage());
            }
            log.debug(e.toString());
            if (!wasUnlocked) {
                this.confSetLayoutLock.unlock();
            }
            throw new MsControlException(e.getMessage());
        }
    }

    public ResourceContainer getContainer() {
        DlgcXMediaMixer mxImpl = null;
        try {
            SipApplicationSession appSession = this.getProxySAS(this.getProxyId());
            String mediaId = this.getMsObjectId();
            String containerProxId = this.getContainerProxyId();
            DlgcMediaSession session = (DlgcMediaSession)appSession.getAttribute(mediaId);
            mxImpl = (DlgcXMediaMixer)session.getMediaObjectByProxyId(containerProxId);
        }
        catch (Exception e) {
            String appLogId = ((DlgcMediaSession)this.getMediaSession()).getAppCallLogId() + " - ";
            log.error(appLogId + "Failed to getContainer", (Throwable)e);
        }
        return (MediaGroup)mxImpl.getProxy();
    }

    public void addListener(MediaEventListener<VideoRendererEvent> arg0) {
        DlgcProxyHelper.addListenerVideoRenderer(this, arg0);
    }

    public void removeListener(MediaEventListener<VideoRendererEvent> arg0) {
        DlgcProxyHelper.removeListenerVideoRenderer(this, arg0);
    }
}

