/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.video;

import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceEvent;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.resource.ResourceEvent;
import javax.media.mscontrol.resource.video.VideoRenderer;
import javax.media.mscontrol.resource.video.VideoRendererEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcVideoRenderEvent
extends DlgcResourceEvent<VideoRenderer>
implements VideoRendererEvent {
    private static final long serialVersionUID = 1L;
    private String errorTxt;
    private static Logger log = LoggerFactory.getLogger(DlgcVideoRenderEvent.class);

    public DlgcVideoRenderEvent(boolean status, String msmlStatus, VideoRenderer source) {
        super((MsmlDocument.Msml)null, source);
        this.errorTxt = msmlStatus;
        this.setQualifier(ResourceEvent.NO_QUALIFIER);
        this.setEventType(VideoRendererEvent.RENDERING_COMPLETED);
        if (status) {
            this.setError(MediaErr.NO_ERROR);
            this.setErrorText("NO ERRORS");
        } else {
            this.setError(MediaErr.BAD_ARG);
            this.setErrorText(msmlStatus);
        }
    }

    public void setStatus(String status) {
        this.setErrorText(this.errorTxt);
        if (status == "404") {
            this.setError(MediaErr.RESOURCE_UNAVAILABLE);
        } else if (status == "400") {
            this.setError(MediaErr.BAD_ARG);
        } else {
            this.setError(MediaErr.UNKNOWN_ERROR);
        }
    }

    public void print() {
        log.debug("DlgcVideoRenderEvent::Print: eventType: " + this.eventType.toString());
        log.debug("DlgcVideoRenderEvent::Print: Qualifier: " + this.qualifier.toString());
        log.debug("DlgcVideoRenderEvent::Print: Media Error Indicator: " + this.error.toString());
        log.debug("DlgcVideoRenderEvent::Print: Media Error Text: " + this.getErrorText());
        log.debug("DlgcVideoRenderEvent::Print: Source ObjectID: " + ((VideoRenderer)this.source).toString());
    }
}

