/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.video;

import com.vendor.dialogic.javax.media.mscontrol.dlgcsmil.DlgcsmilDocument;
import com.vendor.dialogic.javax.media.mscontrol.dlgcsmil.ImgDocument;
import com.vendor.dialogic.javax.media.mscontrol.dlgcsmil.LayoutDocument;
import com.vendor.dialogic.javax.media.mscontrol.dlgcsmil.RefDocument;
import com.vendor.dialogic.javax.media.mscontrol.dlgcsmil.TemplateDocument;
import com.vendor.dialogic.javax.media.mscontrol.dlgcsmil.TextDocument;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.media.mscontrol.resource.video.VideoLayout;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcVideoLayout
implements VideoLayout,
Serializable {
    private static Logger log = LoggerFactory.getLogger(DlgcVideoLayout.class);
    private static final long serialVersionUID = 1L;
    private String defLayoutMimeString = "application/dlgcsmil+xml";
    private String rawXmlLayoutString = null;
    private String layoutType = "";
    private DlgcsmilDocument dlgcsmilDoc = null;
    private DlgcsmilDocument.Dlgcsmil dlgcsmil = null;
    public Map<String, regionLayout> regionNameMap;
    public List<displayRegion> displayRegionList;
    public LayoutDocument.Layout.Size.Enum rootSize;

    public DlgcVideoLayout(String mimetype, String xmlLayoutString) {
        this.init(mimetype, xmlLayoutString);
    }

    public void releaseRegion(String name) {
        regionLayout r = this.regionNameMap.get(name);
        if (r != null) {
            r.bAvail = true;
        }
    }

    public void occupyRegion(String name) {
        regionLayout r = this.regionNameMap.get(name);
        if (r != null) {
            r.bAvail = false;
        }
    }

    public void resetAllRegions() {
        for (Map.Entry<String, regionLayout> entry : this.regionNameMap.entrySet()) {
            entry.getValue().bAvail = true;
        }
    }

    public Boolean isFreeRangeRegion(String ncId) {
        Boolean bFree = true;
        Integer i = 0;
        while (i < this.displayRegionList.size()) {
            if (this.displayRegionList.get((int)i.intValue()).type == "ref" && this.displayRegionList.get((int)i.intValue()).src.equalsIgnoreCase(ncId)) {
                bFree = false;
                break;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return bFree;
    }

    public String getRegionName(String ncId) {
        String regionName = this.getMostActiveRegion();
        Integer i = 0;
        while (i < this.displayRegionList.size()) {
            Serializable rlayout;
            if (this.displayRegionList.get((int)i.intValue()).type == "ref" && this.displayRegionList.get((int)i.intValue()).src.equalsIgnoreCase(ncId)) {
                regionName = this.displayRegionList.get((int)i.intValue()).name;
                rlayout = this.regionNameMap.get(regionName);
                if (rlayout != null) {
                    ((regionLayout)rlayout).bAvail = false;
                    break;
                }
                log.warn("Video Layout Region " + regionName + " is not being set");
                return null;
            }
            rlayout = i;
            Integer n = i = Integer.valueOf(i + 1);
        }
        if (regionName == null) {
            for (Map.Entry<String, regionLayout> entry : this.regionNameMap.entrySet()) {
                if (!entry.getValue().bAvail.booleanValue()) continue;
                Integer i2 = 0;
                while (i2 < this.displayRegionList.size()) {
                    if (this.displayRegionList.get((int)i2.intValue()).name.equals(entry.getKey()) && this.displayRegionList.get((int)i2.intValue()).type == "ref" && this.displayRegionList.get((int)i2.intValue()).src.equalsIgnoreCase(VideoLayout.anyStream.toString())) {
                        regionName = entry.getKey();
                        entry.getValue().bAvail = false;
                        return regionName;
                    }
                    Integer n = i2;
                    Integer n2 = i2 = Integer.valueOf(i2 + 1);
                }
            }
        }
        return regionName;
    }

    private String getMostActiveRegion() {
        String regionName = null;
        Integer i = 0;
        while (i < this.displayRegionList.size()) {
            if (this.displayRegionList.get((int)i.intValue()).type == "ref") {
                if (!this.displayRegionList.get((int)i.intValue()).src.equalsIgnoreCase(VideoLayout.mostActiveStream.toString())) break;
                regionLayout rlayout = this.regionNameMap.get(this.displayRegionList.get((int)i.intValue()).name);
                if (rlayout == null) {
                    log.warn("Video Layout Region " + regionName + " is not being set");
                    break;
                }
                regionName = this.displayRegionList.get((int)i.intValue()).name;
                break;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return regionName;
    }

    private void init(String mimetype, String xmlLayoutString) {
        Integer n;
        Integer n2;
        this.rawXmlLayoutString = xmlLayoutString;
        this.defLayoutMimeString = mimetype;
        this.regionNameMap = new LinkedHashMap<String, regionLayout>();
        this.displayRegionList = new Vector<displayRegion>();
        try {
            this.dlgcsmilDoc = DlgcsmilDocument.Factory.parse((String)this.rawXmlLayoutString);
        }
        catch (XmlException e) {
            log.error("invaild xml doc: " + e.toString());
        }
        this.dlgcsmil = this.dlgcsmilDoc.getDlgcsmil();
        log.debug("dlgcsmil xml version " + this.dlgcsmil.getVersion().toString());
        this.rootSize = this.dlgcsmil.getHead().getLayout().getSize();
        Integer i = 0;
        i = 0;
        while (i < this.dlgcsmil.getHead().getLayout().getRegionList().size()) {
            this.regionNameMap.put(((LayoutDocument.Layout.Region)this.dlgcsmil.getHead().getLayout().getRegionList().get(i)).getId(), new regionLayout(((LayoutDocument.Layout.Region)this.dlgcsmil.getHead().getLayout().getRegionList().get(i)).getTop(), ((LayoutDocument.Layout.Region)this.dlgcsmil.getHead().getLayout().getRegionList().get(i)).getLeft(), ((LayoutDocument.Layout.Region)this.dlgcsmil.getHead().getLayout().getRegionList().get(i)).getRelativesize(), ((LayoutDocument.Layout.Region)this.dlgcsmil.getHead().getLayout().getRegionList().get(i)).isSetPriority() ? ((LayoutDocument.Layout.Region)this.dlgcsmil.getHead().getLayout().getRegionList().get(i)).getPriority() : -1.0f));
            n2 = i;
            n = i = Integer.valueOf(i + 1);
        }
        i = 0;
        while (i < this.dlgcsmil.getBody().getPar().getRefList().size()) {
            this.displayRegionList.add(new displayRegion("ref", ((RefDocument.Ref)this.dlgcsmil.getBody().getPar().getRefList().get(i)).getRegion(), ((RefDocument.Ref)this.dlgcsmil.getBody().getPar().getRefList().get(i)).getSrc(), null, null));
            n2 = i;
            n = i = Integer.valueOf(i + 1);
        }
        i = 0;
        while (i < this.dlgcsmil.getBody().getPar().getTemplateList().size()) {
            this.displayRegionList.add(new displayRegion("template", ((TemplateDocument.Template)this.dlgcsmil.getBody().getPar().getTemplateList().get(i)).getRegion(), ((TemplateDocument.Template)this.dlgcsmil.getBody().getPar().getTemplateList().get(i)).getSrc(), null, null));
            n2 = i;
            n = i = Integer.valueOf(i + 1);
        }
        i = 0;
        while (i < this.dlgcsmil.getBody().getPar().getImgList().size()) {
            this.displayRegionList.add(new displayRegion("img", ((ImgDocument.Img)this.dlgcsmil.getBody().getPar().getImgList().get(i)).getRegion(), ((ImgDocument.Img)this.dlgcsmil.getBody().getPar().getImgList().get(i)).getSrc(), (ImgDocument.Img)this.dlgcsmil.getBody().getPar().getImgList().get(i), null));
            n2 = i;
            n = i = Integer.valueOf(i + 1);
        }
        i = 0;
        while (i < this.dlgcsmil.getBody().getPar().getTextList().size()) {
            ((TextDocument.Text)this.dlgcsmil.getBody().getPar().getTextList().get(i)).getDuration();
            this.displayRegionList.add(new displayRegion("text", ((TextDocument.Text)this.dlgcsmil.getBody().getPar().getTextList().get(i)).getRegion(), ((TextDocument.Text)this.dlgcsmil.getBody().getPar().getTextList().get(i)).getSrc(), null, (TextDocument.Text)this.dlgcsmil.getBody().getPar().getTextList().get(i)));
            n2 = i;
            n = i = Integer.valueOf(i + 1);
        }
    }

    public DlgcVideoLayout(String mimetype, String xmlLayoutString, String layoutTypeString) {
        this.layoutType = layoutTypeString;
        this.init(mimetype, xmlLayoutString);
    }

    public String getType() {
        return this.layoutType;
    }

    public String marshall() {
        return this.rawXmlLayoutString;
    }

    public static class displayRegion
    implements Serializable {
        public String type;
        public String name;
        public String src;
        public String overlayId;
        public ImgDocument.Img img = null;
        public TextDocument.Text text = null;

        public displayRegion(String sType, String sName, String sSrc, ImgDocument.Img img, TextDocument.Text txt) {
            this.type = sType;
            this.name = sName;
            this.src = sSrc;
            this.overlayId = null;
            this.img = img;
            this.text = txt;
        }
    }

    public static class regionLayout
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String top;
        public String left;
        public String relativeSize;
        public float priority;
        public Boolean bAvail;

        public regionLayout(String sTop, String sLeft, String size, float sPriority) {
            this.top = sTop;
            this.left = sLeft;
            this.relativeSize = size;
            this.bAvail = true;
            this.priority = sPriority;
        }
    }
}

