/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.spi;

import com.vendor.dialogic.javax.media.mscontrol.DlgcXMsControlFactory;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.MsControlFactory;
import javax.media.mscontrol.spi.Driver;
import javax.media.mscontrol.spi.PropertyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcDriver
implements Driver {
    public static final String MEDIA_SERVER_TYPE = "mediaserver.msType";
    static final String DLGC_DRIVER_NAME = "com.dialogic.dlg309";
    static final String DLGC_PROPERTY_ENV_FILENAME = "DLG_PROPERTY_FILE";
    static final String DEFAULT_PROPERTY_ENV_FILENAME = "dlg309_samples.properties";
    public static final String DLGC_MS_SESSION_TIMER_SWITCH = "mediaserver.sessionTimer.switch";
    public static final String DLGC_MS_SESSION_TIMER_MAX_TIMEOUT = "mediaserver.sessionTimer.maxTimeout";
    public static final String DLGC_MS_SESSION_TIMER_MIN_TIMEOUT = "mediaserver.sessionTimer.minTimeout";
    static Logger log = LoggerFactory.getLogger(DlgcDriver.class);

    public DlgcDriver() {
        log.debug("DlgcDriver CTOR empty CTOR");
    }

    public MsControlFactory getFactory(Properties properties) throws MsControlException {
        try {
            DlgcSipServlet.instance.ready();
            MsControlFactory factory = DlgcDriver.getControlFactory(this.getClass(), properties);
            return factory;
        }
        catch (MsControlException mex) {
            String msg = "Dialogic Connector 309 Driver Servlets not ready or initilized...can't retrieve Factory";
            log.warn("DlgcDriver::getFactory: " + msg);
            throw new MsControlException(msg);
        }
    }

    public PropertyInfo[] getFactoryPropertyInfo() {
        log.debug("Entering getFactoryPropertyInfo");
        try {
            log.debug("DlgcDriver::getFactoryPropertyInfo() checking connector Servlets initialization");
            DlgcSipServlet.instance.ready();
            log.debug("DlgcDriver::getFactoryPropertyInfo() connector Servlets initialization ready...");
        }
        catch (MsControlException e) {
            log.debug("DlgcDriver::getFactoryPropertyInfo() exception: " + e.toString());
            return null;
        }
        String DEFAULT_APP_SERVER_HOST = DlgcSipServlet.DEFAULT_APP_SERVER_HOST;
        Integer DEFAULT_APP_SERVER_PORT = new Integer(DlgcSipServlet.DEFAULT_APP_SERVER_PORT);
        String DEFALT_APP_SERVER_TRANSPORT = DlgcSipServlet.DEFALT_APP_SERVER_TRANSPORT;
        PropertyInfo[] propertyInfo = new PropertyInfo[11];
        String platform = DlgcInstrumentPropertyMgr.getPlatformFromManifest();
        propertyInfo[0] = DEFAULT_APP_SERVER_HOST != null ? new PropertyInfo("connector.sip.address", true, "Connector Application Server IP Address", null, DEFAULT_APP_SERVER_HOST) : new PropertyInfo("connector.sip.address", true, "Connector Application Server IP Address", null, "x.x.x.x");
        propertyInfo[1] = DEFAULT_APP_SERVER_PORT != null ? new PropertyInfo("connector.sip.port", true, "Connector Application Server SIP Port", null, DEFAULT_APP_SERVER_PORT.toString()) : new PropertyInfo("connector.sip.port", true, "Connector Application Server SIP Port", null, "5060");
        String[] choices6 = new String[]{new String("XMS")};
        propertyInfo[2] = new PropertyInfo(MEDIA_SERVER_TYPE, false, "Dialogic has depricated IPMS support. It only supports XMS", choices6, "XMS");
        String[] sesssionTimeOut = new String[]{new String("on"), new String("off")};
        propertyInfo[3] = new PropertyInfo(DLGC_MS_SESSION_TIMER_SWITCH, true, "The mediaserver SIP session timer timeout property must be set to either on or off.", sesssionTimeOut, "on");
        propertyInfo[4] = new PropertyInfo(DLGC_MS_SESSION_TIMER_MAX_TIMEOUT, true, "Maximum SIP Session Timeout in seconds.", null, "1800");
        propertyInfo[5] = new PropertyInfo(DLGC_MS_SESSION_TIMER_MIN_TIMEOUT, true, "Minimum SIP Session Timeout in seconds.", null, "100");
        propertyInfo[6] = new PropertyInfo("connector.conferenceControlLeg", false, "Enable Conference Control Leg per Mixer instantiation", null, "yes");
        propertyInfo[7] = new PropertyInfo("mediaserver.sip.ipaddress", true, "Media Server SIP IP ADDRESS", null, "x.y.z.w");
        propertyInfo[8] = new PropertyInfo("mediaserver.sip.port", true, "Media Server SIP Port", null, "5060");
        propertyInfo[9] = new PropertyInfo("connector.sip.transport", false, "Connector Application Server SIP Transport", null, DEFALT_APP_SERVER_TRANSPORT);
        propertyInfo[10] = new PropertyInfo("APPSERVER_PLATFORM", false, "Derived Application Server Platform - Read Only", null, platform);
        return propertyInfo;
    }

    public String getName() {
        return DLGC_DRIVER_NAME;
    }

    public static Properties LoadProperties(Class<?> cls) {
        Properties properties = new Properties();
        String configPath = System.getenv(DLGC_PROPERTY_ENV_FILENAME);
        if (configPath == null) {
            log.warn("Configuration File: " + DLGC_PROPERTY_ENV_FILENAME + " not provided");
            try {
                properties.load(cls.getClassLoader().getResourceAsStream(DEFAULT_PROPERTY_ENV_FILENAME));
                log.debug("Configuration File: dlg309_samples.properties Successfully Loaded");
            }
            catch (Exception e) {
                log.debug("Default Configuration File not found...connector must be in dynamic configuration mode");
                properties = null;
            }
        } else {
            try {
                FileInputStream inputStream = new FileInputStream(configPath);
                properties.load(inputStream);
                inputStream.close();
                log.debug("Configuration File: " + configPath + " Successfully Loaded");
            }
            catch (IOException ioe) {
                log.info(ioe.toString());
                log.info("Configuration File: " + configPath + " load failed");
                log.debug("Trying to load default configuration filedlg309_samples.properties");
                try {
                    properties.load(cls.getClassLoader().getResourceAsStream(DEFAULT_PROPERTY_ENV_FILENAME));
                    log.debug("Configuration File: dlg309_samples.properties Successfully Loaded");
                }
                catch (Exception e) {
                    log.info(e.toString());
                    log.error("Fail to find connector legacy property configuration file.");
                    properties = null;
                }
            }
        }
        return properties;
    }

    public static MsControlFactory getControlFactory(Class<?> cls, Properties properties) throws MsControlException {
        DlgcXMsControlFactory factory = null;
        if (properties != null) {
            log.debug("DlgcDriver::getControlFactory() property passed in: ");
            boolean useDynamic = true;
            factory = new DlgcXMsControlFactory(properties, useDynamic);
        } else {
            Properties props = properties == null ? DlgcDriver.LoadProperties(cls) : properties;
            log.debug("DlgcDriver::getControlFactory loading XMS Factory.");
            if (props == null) {
                String majorError = "DlgcDriver::getControlFactory...Dialogic JSR 309 Connector - MAJOR ERROR - Neither a connector property file was found or a dynamic connector configuration was passed in by the application.";
                log.error(majorError);
                throw new MsControlException(majorError);
            }
            factory = new DlgcXMsControlFactory(props);
        }
        return factory;
    }
}

