/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.sip;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXMediaGroup;
import com.vendor.dialogic.javax.media.mscontrol.msml.MsmlDocument;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResource;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcAbstractB2BUAReceiver;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServletRequestProxy;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcXmsB2BUAReceiver
extends DlgcAbstractB2BUAReceiver {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(DlgcXmsB2BUAReceiver.class);

    public DlgcXmsB2BUAReceiver() {
        this.setReceiverName("XMS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSipRequestInfo(SipServletRequest request) {
        log.warn("<RESTCOMM ISSUE TRACE> Entering processSipRequestInfo() ");
        DlgcSipConnectorContentIdsProxy masterContainerReqProxy = null;
        DlgcSipConnectorContentIdsProxy infoWithMsmlReqNotifierProxy = null;
        DlgcSipConnectorContentIdsProxy infoWithNoMsmlReqNotifierProxy = null;
        SipSession reqSipSession = request.getSession();
        SipServletResponse response = request.createResponse(200);
        log.debug("<TRY BLOCK> DELAY 200 OK Response for this XMS request");
        try {
            StringReader xmlContent = new StringReader(new String(request.getRawContent()));
            MsmlDocument msmlDoc = MsmlDocument.Factory.parse((Reader)xmlContent);
            MsmlDocument.Msml msmlMessage = msmlDoc.getMsml();
            masterContainerReqProxy = (DlgcSipConnectorContentIdsProxy)request.getSession().getAttribute("container");
            log.debug(" processSipRequestInfo() found Master Connector Proxy Component that is to handle request: " + masterContainerReqProxy.toDebug());
            masterContainerReqProxy.Load();
            DlgcJoinableContainer jc = masterContainerReqProxy.getCachedContainer();
            log.debug("processSipRequestInfo() from Master Connector Proxy Component obtained real JoinableContainer ObjectID: " + jc.getMediaObject());
            DlgcMediaSession ms = (DlgcMediaSession)jc.getMediaSession();
            if (ms == null) {
                log.error("DlgcMediaSession returned as null from masterContainerReqProxy.getCachedContainer()");
            }
            DlgcNetworkConnection dlgcXNetworkConnection = null;
            if (jc instanceof DlgcXNetworkConnection) {
                dlgcXNetworkConnection = (DlgcXNetworkConnection)jc;
            }
            DlgcIpmsSession dlgsession = dlgcXNetworkConnection.getDlgIpmsSession();
            dlgsession.setSipSession(reqSipSession);
            MsmlDocument.Msml.Event dialogExitEvent = msmlMessage.getEvent();
            String eventName = dialogExitEvent.getName2();
            if (eventName != null) {
                if (eventName.compareToIgnoreCase("cpa") == 0) {
                    log.debug("DlgcXmsB2BUAReceiver::processSipRequestInfo  cpa Event received");
                    log.debug(request.toString());
                    DlgcXSdpPortManager sdpMgr = (DlgcXSdpPortManager)((DlgcXNetworkConnection)jc).getSdpPortMgrResource();
                    sdpMgr.processCPA(msmlMessage);
                } else if (eventName.compareToIgnoreCase("msml.conf.asn") != 0) {
                    int index;
                    String fullDialogId = dialogExitEvent.getId();
                    String dialogId = fullDialogId.substring(0, index = fullDialogId.indexOf(47));
                    if (dialogId == null) {
                        log.error("XMS processSipRequestInfo error null dialogId received in info message");
                    }
                    if (dialogId != null) {
                        log.debug("XMS processSipRequestInfo(): Info REQUEST msmlMessage.dialogId: " + dialogId);
                        if (dlgsession == null) {
                            log.error("XMS processSipRequestInfo(): DlgSession Object is NULL... major problem");
                        }
                        log.debug("REPLY NOTIFIER_ID= " + fullDialogId);
                        if (eventName.compareToIgnoreCase("msml.dialog.exit") == 0) {
                            log.debug("STARTS REPLY calling dlgsession.removeMediaEventNotifier(fullDialogId)");
                            infoWithMsmlReqNotifierProxy = dlgsession.removeMediaEventNotifier(fullDialogId);
                            log.debug("Got msml.dialog.exit -> Calling removeActiveDialog with fullDialogId = " + fullDialogId);
                            dlgsession.removeActiveDialog(fullDialogId);
                            log.debug("ENDS REPLY calling dlgsession.removeMediaEventNotifier(fullDialogId)");
                        } else {
                            if (eventName != null) {
                                log.debug("StARTS REPLY calling dlgsession.getMediaEventNotifier(fullDialogId)");
                            }
                            infoWithMsmlReqNotifierProxy = dlgsession.getMediaEventNotifier(fullDialogId);
                            log.debug("END REPLY calling dlgsession.getMediaEventNotifier(fullDialogId)");
                        }
                        infoWithMsmlReqNotifierProxy.Load();
                        DlgcResource<?, ?> resource = infoWithMsmlReqNotifierProxy.getCachedResource();
                        log.debug("calling XMS processSipRequestDoAction to handle Info Request for this resource: " + resource.getProxy().getProxyId());
                        log.info("+++++++++++++++++++++++++++++++INFO REQUEST RECEIVER BEGINS++++++++++++++++++++++++++++++++++++++++++");
                        log.info("JSR309:SIP-INFO-REQUEST-RECEIVER() : SIP MSG RECEIVED: " + request.toString());
                        log.info("JSR309:SIP-INFO-REQUEST-RECEIVER() : SIP MSG OWNER Media OBJID: " + jc.getMediaObject());
                        log.info("JSR309:SIP-INFO-REQUEST-RECEIVER() : JSR309 Callback Resource Unique Assigned ObjectID:: " + resource.getResourceId());
                        log.info("JSR309:SIP-INFO-REQUEST-RECEIVER() : JSR309 Callback Resource ObjectID String: " + resource.toString());
                        log.info("JSR309:SIP-INFO-REQUEST-RECEIVER() : JSR309 Container Resource ObjectID: " + ((DlgcResourceContainer)resource.getContainer()).getMediaObject());
                        log.info("+++++++++++++++++++++++++++++++INFO REQUEST RECEIVER ENDS++++++++++++++++++++++++++++++++++++++++++++");
                        resource.setServletResponse(response);
                        resource.processSipInfoRequest(msmlMessage, infoWithMsmlReqNotifierProxy);
                        log.debug("Resource returned from handling processSipInfoRequest");
                        if (DlgcInstrumentPropertyMgr.bRcvSerialize && infoWithMsmlReqNotifierProxy != null) {
                            log.debug("XMS SaveMediaSession inside dlgSipB2BUA:processSipRequestInfo for INFO Request");
                            infoWithMsmlReqNotifierProxy.saveMediaSession();
                        }
                    } else {
                        log.warn("XMS INVALID TRANSACTION ID RETURNED");
                    }
                } else {
                    log.debug("XMS SaveMediaSession inside dlgSipB2BUA:processSipRequestInfo for INFO Request - handling ActiveTalker Event");
                    log.info("+++++++++++++++++++++++++++++++INFO REQUEST RECEIVER BEGINS++++++++++++++++++++++++++++++++++++++++++");
                    log.info("JSR309:SIP-INFO-REQUEST-RECEIVER() : SIP MSG RECEIVED:  ActiveTalker Request: " + request.toString());
                    log.info("JSR309:SIP-INFO-REQUEST-RECEIVER() : SIP MSG OWNER Media OBJID: " + jc.getMediaObject());
                    log.info("JSR309:SIP-INFO-REQUEST-RECEIVER() : JSR309 Callback Resource ObjectID String: " + ((DlgcXNetworkConnection)jc).getSdpPortMgrResource().toString());
                    log.info("+++++++++++++++++++++++++++++++INFO REQUEST RECEIVER ENDS++++++++++++++++++++++++++++++++++++++++++++");
                    DlgcXSdpPortManager sdpMgr = (DlgcXSdpPortManager)((DlgcXNetworkConnection)jc).getSdpPortMgrResource();
                    sdpMgr.processActiveTalker(msmlMessage);
                    log.debug("Resource returned from handling processSipInfoRequest for ActiveTalker Request");
                }
            } else {
                log.debug("XMS - This INFO Request has no msg lets process it...");
                infoWithNoMsmlReqNotifierProxy = (DlgcSipConnectorContentIdsProxy)request.getSession().getAttribute("RESOURCE");
                infoWithNoMsmlReqNotifierProxy.Load();
                DlgcResource<?, ?> resource = infoWithNoMsmlReqNotifierProxy.getCachedResource();
                if (resource != null) {
                    log.debug("XMS calling resource.processSipInfoRequest to handle Info Request with no msml payload for resourceId: " + resource.getProxy().getProxyId());
                    resource.processSipInfoRequest(msmlMessage, infoWithNoMsmlReqNotifierProxy);
                    if (DlgcInstrumentPropertyMgr.bRcvSerialize && infoWithNoMsmlReqNotifierProxy != null) {
                        log.debug("XMS SaveMediaSession inside dlgSipB2BUA:processSipRequestInfo for INFO Request with no MSML Payload");
                        infoWithNoMsmlReqNotifierProxy.saveMediaSession();
                    }
                } else {
                    log.warn("XMS UNABLE TO DETERMINE TARGET NOTIFIER FOR EVENT");
                }
            }
        }
        catch (IOException e) {
            log.error(e.toString());
        }
        catch (XmlException e) {
            log.debug("Ignoring picture fast update info");
        }
        finally {
            try {
                log.warn("<RESTCOMM ISSUE TRACE> XMS processSipRequestInfo(): sending response 200 OK back to Media Server");
                response.send();
                log.warn("<RESTCOMM ISSUE TRACE> XMS processSipRequestInfo(): DONE sending response 200 OK back to Media Server");
            }
            catch (IOException e) {
                log.debug("<TRY BLOCK> XMS processSipRequestInfo(): sending response 200 OK back to Media Server");
                log.error(e.toString());
            }
        }
        log.warn("<RESTCOMM ISSUE TRACE> Exiting processSipRequestInfo() ");
        log.debug("** XMS Returning from DlgcSipB2BUA:processSipRequestInfo **");
    }

    @Override
    protected void processSipResponseInfo(SipServletResponse response, DlgcJoinableContainer container, DlgcSipServletRequestProxy sipServletRequestProxy) {
        log.debug("**16 XMS Processing Sip Info Response inside processSipResponseInfo **");
        SipServletRequest request = response.getRequest();
        SipSession requestSipSession = request.getSession();
        log.debug("Received processSipResponseDoAction(INFO) ");
        int stat = response.getStatus();
        log.info("JSR309:SIP-INFO-RESPONSE-RECEIVER() : SIP STATUS = " + response.getStatus());
        DlgcSipConnectorContentIdsProxy reqResourceProxy = sipServletRequestProxy.GetResourceReqProxyResponse();
        if (reqResourceProxy == null) {
            log.debug("*16 reqResourceProxy is NULL - OK");
        } else {
            reqResourceProxy.Load();
            container = reqResourceProxy.getCachedContainer();
        }
        DlgcMediaSession ms = (DlgcMediaSession)container.getMediaSession();
        if (ms == null) {
            log.error("XMS DlgcMediaSession returned as null from reqResourceProxy.getCachedContainer(); during INFO Request");
        }
        DlgcXNetworkConnection dlgcXNetworkConnection = null;
        if (container instanceof DlgcXNetworkConnection) {
            log.debug("*16 processSipResponseInfo:: container Type DlgcXNetworkConnection");
            dlgcXNetworkConnection = (DlgcXNetworkConnection)container;
        } else if (container instanceof DlgcXMediaGroup) {
            log.debug("*16 processSipResponseInfo:: container Type DlgcXMediaGroup");
            dlgcXNetworkConnection = (DlgcXNetworkConnection)((DlgcXMediaGroup)container).joinedWithNetworkConnection();
        }
        log.debug("*16 processSipResponseInfo:: requestSipSession: " + requestSipSession.getId());
        if (dlgcXNetworkConnection != null) {
            log.debug("*16 processSipResponseInfo:: dlgcXNetworkConnection Id: " + dlgcXNetworkConnection.getMediaObject());
            log.debug("*16 processSipResponseInfo:: dlgcXNetworkConnection.SipSession Id: " + dlgcXNetworkConnection.getDlgIpmsSession().getIpmsSipSessionObjectID());
        }
        if (ms != null) {
            log.debug("*16 processSipResponseInfo:: ms: " + ms.getMediaObject() + " SASID: " + ms.getAppSasId());
        }
        if (dlgcXNetworkConnection.getDlgIpmsSession() != null) {
            dlgcXNetworkConnection.getDlgIpmsSession().setSipSession(requestSipSession);
        }
        String resourceId = null;
        DlgcResource<?, ?> res = null;
        if (reqResourceProxy != null && container != null) {
            res = reqResourceProxy.getResource(container);
            resourceId = res.getResourceId();
        }
        log.info("+++++++++++++++++++++++++++++++INFO RESPONSE RECEIVER BEGINS++++++++++++++++++++++++++++++++++++++++++");
        log.info("JSR309:SIP-INFO-RESPONSE-RECEIVER() : SIP MSG RECEIVED: " + request.toString());
        log.info("JSR309:SIP-INFO-RESPONSE-RECEIVER() : SIP MSG OWNER Media OBJID: " + sipServletRequestProxy.masterContainerReqProxyResponse.cachedContainer.getMediaObject());
        if (resourceId != null) {
            log.info("JSR309:SIP-INFO-RESPONSE-RECEIVER() : JSR309 Callback Resource Unique Assigned ObjectID: " + resourceId);
        }
        if (res != null) {
            log.info("JSR309:SIP-INFO-REQUEST-RECEIVER() :  JSR309 Callback Resource ObjectID String: " + reqResourceProxy.getResource(container).toString());
        }
        log.info("JSR309:SIP-INFO-RESPONSE-RECEIVER() : JSR309 Container Resource ObjectID: " + container.getMediaObject());
        log.info("+++++++++++++++++++++++++++++++INFO RESPONSE RECEIVER ENDS++++++++++++++++++++++++++++++++++++++++++++");
        container.processSipInfo(response, reqResourceProxy);
        log.debug("** XMS Returning from  DlgcSipB2BUA:processSipResponseInfo **");
    }
}

