/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.sip;

import com.vendor.dialogic.javax.media.mscontrol.DlgcISipB2BUAMsProtocolBridge;
import com.vendor.dialogic.javax.media.mscontrol.DlgcSipB2BUAMsProtocolMgrFactory;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIBMSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMobiSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMsMonitor;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMsMonitorServlet;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcOracleSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSailFinSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcTropoSipB2BUA;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcXmsB2BUAReceiver;
import com.vendor.dialogic.javax.media.mscontrol.spi.DlgcDriver;
import commonj.work.WorkManager;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.spi.Driver;
import javax.media.mscontrol.spi.DriverManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSessionsUtil;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.annotation.SipServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SipServlet(description="Component receiving SIP request and response from XMS", loadOnStartup=2)
public class DlgcSipServlet
extends javax.servlet.sip.SipServlet {
    private static final long serialVersionUID = 1L;
    public static WorkManager wManager;
    public static String APPLICATION_PLATFORM;
    public static String DEFAULT_APP_SERVER_URI;
    public static String DEFAULT_APP_SERVER_HOST;
    public static String DEFAULT_APP_SERVER_PORT;
    public static String DEFALT_APP_SERVER_TRANSPORT;
    protected boolean bReady = false;
    public static final String ORACLE_PLATFORM = "OCCAS5";
    public static final String ORACLE7_PLATFORM = "OCCAS7";
    public static final String IBM_PLATFORM = "IBM";
    public static final String SAILFIN_PLATFORM = "SAILFIN";
    public static final String TELESTAX_PLATFORM = "TELESTAX";
    public static final String TROPO_PLATFORM = "TROPO";
    static final String SESSION_SCOPED_MS_ID = "SESSION_SCOPED_MS_URI";
    public static DlgcSipServlet instance;
    private static Logger log;
    private DlgcDriver driver = null;
    private boolean servletInitializedFlag = false;
    public static DlgcSipB2BUA sipB2BUA;
    public static String APP_SERVER_PLATFORM;
    private static DlgcISipB2BUAMsProtocolBridge msProtocol;

    public void init(ServletConfig cfg) throws ServletException {
        super.init(cfg);
        log.debug("Entering DlgcSipServlet::Init");
        this.servletInitializedFlag = true;
        this.bReady = false;
        instance = this;
        String webServerPlatform = this.getWebServerPlatform();
        log.debug("Loading WEB Server Platform= " + webServerPlatform);
        Object rcv = null;
        if (webServerPlatform.compareToIgnoreCase(ORACLE_PLATFORM) == 0) {
            try {
                InitialContext context = new InitialContext();
                wManager = (WorkManager)context.lookup("java:comp/env/wm/default");
                log.debug("WorkManager:: found");
                context.close();
            }
            catch (NamingException e) {
                log.error("DlgcSipServlet::init() - exception creating OCCAS workManager: " + e.toString());
                e.printStackTrace();
            }
        } else if (webServerPlatform.compareToIgnoreCase(ORACLE7_PLATFORM) != 0) {
            wManager = null;
        }
        try {
            this.registerDialogic309Driver(webServerPlatform);
        }
        catch (MsControlException e) {
            log.error(e.toString());
        }
        log.debug("Dialogic Servlet Initialized...");
    }

    protected void doRequest(SipServletRequest request) throws IOException, ServletException {
        log.debug("Entering  DlgcSipServlet::doRequest");
        sipB2BUA.processSipRequest(request);
        log.debug("Leaving  DlgcSipServlet::doRequest");
    }

    protected void doResponse(SipServletResponse response) throws IOException, ServletException {
        log.debug("Entering  DlgcSipServlet::doResponse");
        sipB2BUA.processSipResponse(response);
        log.debug("Leaving  DlgcSipServlet::doResponse");
    }

    public List<SipURI> getApplicationSipServerConnections() {
        log.debug("Entering getApplicationSipServerConnectons ");
        String serverInfo = this.getServletContext().getServerInfo();
        log.debug("serverInfo: " + serverInfo);
        String ipv4Pattern = "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b";
        List connections = (List)this.getServletContext().getAttribute("javax.servlet.sip.outboundInterfaces");
        if (connections == null) {
            log.debug("getApplicationSipServerConnectons return NULL connections");
        } else {
            for (SipURI aConnection : connections) {
                Pattern ipv4AddressPattern;
                Matcher ipv4AddressMatcher;
                if (aConnection.getTransportParam().compareToIgnoreCase("udp") != 0 || !(ipv4AddressMatcher = (ipv4AddressPattern = Pattern.compile(ipv4Pattern)).matcher(aConnection.getHost())).matches() || aConnection.getHost().compareToIgnoreCase("127.0.0.1") == 0) continue;
                log.debug("getApplicationSipServerConnectons Connection URI: " + aConnection.toString());
                DEFAULT_APP_SERVER_URI = aConnection.toString();
                log.debug("getApplicationSipServerConnectons Connection Host: " + aConnection.getHost());
                DEFAULT_APP_SERVER_HOST = aConnection.getHost();
                log.debug("getApplicationSipServerConnectons Connection Transport: " + aConnection.getTransportParam());
                DEFALT_APP_SERVER_TRANSPORT = aConnection.getTransportParam();
                DEFAULT_APP_SERVER_PORT = new Integer(aConnection.getPort()).toString();
                log.debug("getApplicationSipServerConnectons Connection Port: " + DEFAULT_APP_SERVER_PORT);
            }
        }
        return connections;
    }

    private void initB2BUA() throws MsControlException {
        DlgcMsMonitor msMonitor = (DlgcMsMonitor)this.getServletContext().getAttribute("DlgcMsMonitor");
        APP_SERVER_PLATFORM = ORACLE_PLATFORM;
        this.getApplicationSipServerConnections();
        DlgcInstrumentPropertyMgr.getPlatformFromManifest();
        Properties properties = DlgcDriver.LoadProperties(((Object)((Object)this)).getClass());
        if (sipB2BUA == null) {
            log.debug("initB2BUA: Initializing sipB2BUA");
            log.debug("Initializing Protocol Manager");
            msProtocol = DlgcSipB2BUAMsProtocolMgrFactory.createMsProtocolMgr();
            String webServerPlatform = this.getWebServerPlatform();
            log.debug("Loading WEB Server Platform= " + webServerPlatform);
            DlgcXmsB2BUAReceiver rcv = null;
            if (webServerPlatform.compareToIgnoreCase(ORACLE_PLATFORM) == 0) {
                sipB2BUA = new DlgcOracleSipB2BUA(properties);
                sipB2BUA.setMsMonitor(msMonitor);
                rcv = new DlgcXmsB2BUAReceiver();
                sipB2BUA.setReceiver(rcv);
            } else if (webServerPlatform.compareToIgnoreCase(ORACLE7_PLATFORM) == 0) {
                sipB2BUA = new DlgcOracleSipB2BUA(properties);
                sipB2BUA.setMsMonitor(msMonitor);
                rcv = new DlgcXmsB2BUAReceiver();
                sipB2BUA.setReceiver(rcv);
            } else if (webServerPlatform.compareToIgnoreCase(IBM_PLATFORM) == 0) {
                APP_SERVER_PLATFORM = IBM_PLATFORM;
                sipB2BUA = new DlgcIBMSipB2BUA(properties);
                sipB2BUA.setMsMonitor(msMonitor);
                rcv = new DlgcXmsB2BUAReceiver();
                sipB2BUA.setReceiver(rcv);
            } else if (webServerPlatform.compareToIgnoreCase(SAILFIN_PLATFORM) == 0) {
                APP_SERVER_PLATFORM = SAILFIN_PLATFORM;
                sipB2BUA = new DlgcSailFinSipB2BUA(properties);
                sipB2BUA.setMsMonitor(msMonitor);
            } else if (webServerPlatform.compareToIgnoreCase(TELESTAX_PLATFORM) == 0) {
                APP_SERVER_PLATFORM = TELESTAX_PLATFORM;
                sipB2BUA = new DlgcMobiSipB2BUA(properties);
                sipB2BUA.setMsMonitor(msMonitor);
                rcv = new DlgcXmsB2BUAReceiver();
                sipB2BUA.setReceiver(rcv);
            } else if (webServerPlatform.compareToIgnoreCase(TROPO_PLATFORM) == 0) {
                APP_SERVER_PLATFORM = TROPO_PLATFORM;
                sipB2BUA = new DlgcTropoSipB2BUA(properties);
                sipB2BUA.setMsMonitor(msMonitor);
                rcv = new DlgcXmsB2BUAReceiver();
                sipB2BUA.setReceiver(rcv);
            } else {
                sipB2BUA = null;
                String msg = "Critital error: Invalid Web Server Platform value";
                log.error(msg);
                throw new MsControlException(msg);
            }
        }
    }

    protected String getWebServerPlatform() {
        log.debug("getWebServerPlatform... calling DlgcInstrumentPropertyMgr.getPlatformFromManifest()");
        String platform = DlgcInstrumentPropertyMgr.getPlatformFromManifest();
        if (platform == null) {
            log.warn("Environment Variable: " + "APPSERVER_PLATFORM" + " not provided");
            log.warn("Assuming OCCAS5 WEB Application Server Platform");
            platform = ORACLE_PLATFORM;
        }
        log.debug("APPSERVER_PLATFORM set to: " + platform);
        APPLICATION_PLATFORM = platform;
        return platform;
    }

    public static SipSessionsUtil getSSU() {
        SipSessionsUtil ssu = null;
        try {
            ServletContext ctx = instance.getServletContext();
            ssu = (SipSessionsUtil)ctx.getAttribute("javax.servlet.sip.SipSessionsUtil");
            return ssu;
        }
        catch (Exception e) {
            log.debug("getSSU Exception found: " + e.toString());
            return ssu;
        }
    }

    public static SipSessionsUtil getSSUA() {
        SipSessionsUtil ssua = (SipSessionsUtil)instance.getServletContext().getAttribute("javax.servlet.sip.SipSessionsUtil");
        return ssua;
    }

    public static SipFactory getSipFactory() {
        ServletConfig scfg = instance.getServletConfig();
        ServletContext ctx = scfg.getServletContext();
        SipFactory factory = (SipFactory)ctx.getAttribute("javax.servlet.sip.SipFactory");
        return factory;
    }

    public static DlgcISipB2BUAMsProtocolBridge getProtocolBridge() {
        return msProtocol;
    }

    public static boolean isTCKEnabled() {
        String tckFlag = System.getenv("TCK_ENABLED");
        log.debug("Value of TCK_ENABLED flag is :" + tckFlag);
        boolean isTCKEnabled = false;
        if (null == tckFlag || tckFlag.equalsIgnoreCase("NO")) {
            log.warn("Environment Variable: " + "TCK_ENABLED" + " not set");
            log.warn("Assuming TCK is not enabled");
            isTCKEnabled = false;
        } else if (tckFlag.equalsIgnoreCase("YES")) {
            isTCKEnabled = true;
        }
        log.debug("Value of TCK_ENABLED flag is :" + isTCKEnabled);
        return isTCKEnabled;
    }

    public void servletInitialized() throws MsControlException {
        log.debug("DlgcSipServlet::servletInitalized() internal call");
        log.debug("DlgcSipServlet::servletInitalized() internal - servletInitializedFlag: " + new Boolean(this.servletInitializedFlag).toString());
        if (this.servletInitializedFlag) {
            this.bReady = true;
            if (DlgcSipServlet.getSSU() == null || DlgcSipServlet.getSSUA() == null) {
                String msg = "Unable to retrieve data from Servlet Context";
                log.error(msg);
                if (DlgcSipServlet.getSSU() == null) {
                    log.error("sessionsUtil is null");
                }
                throw new MsControlException(msg);
            }
            try {
                log.debug("DlgcSipServlet:init - calling initB2BUA");
                this.initB2BUA();
            }
            catch (MsControlException e) {
                log.error("could not instantiate DlgcSipB2BUA Object", (Object)e.toString());
                throw e;
            }
            String wp = this.getWebServerPlatform();
            this.registerDialogic309Driver(wp);
        }
    }

    protected void registerDialogic309Driver(String wp) throws MsControlException {
        log.debug("Entering registerDialogic309Driver()");
        if (wp == null) {
            String msg = "DlgcSipServlet::registerDialogic309Driver() - Application Platform not defined defaulting to OCCAS using implicit driver loading";
            log.error(msg);
            throw new MsControlException(msg);
        }
        if (wp != null) {
            if (wp.compareToIgnoreCase(ORACLE_PLATFORM) == 0) {
                log.debug("DlgcSipServlet::registerDialogic309Driver() - Application Platform  defined as OCCAS using implicit driver loading");
            } else if (wp.compareToIgnoreCase(TELESTAX_PLATFORM) == 0) {
                log.debug("DlgcSipServlet::registerDialogic309Driver() - Application Platform  defined as MOBI using explicit driver loading..loading driver now");
                this.driver = new DlgcDriver();
                if (this.driver == null) {
                    log.debug("registerDialogic309Drive()  driver is NULL");
                } else {
                    log.debug("registerDialogic309Drive()  instantiated successfuly Dialogic 309 Driver");
                }
                log.debug("registerDialogic309Drive() calling DriverManager.registerDriver(driver)");
                DriverManager.registerDriver((Driver)this.driver);
                log.debug("registerDialogic309Drive() returned from DriverManager.registerDriver(driver)");
            } else if (wp.compareToIgnoreCase(ORACLE7_PLATFORM) == 0) {
                log.debug("DlgcSipServlet::registerDialogic309Driver() - Application Platform  defined as OCCAS7 using implicit driver loading");
            } else if (wp.compareToIgnoreCase(IBM_PLATFORM) == 0) {
                log.debug("DlgcSipServlet::registerDialogic309Driver() - Application Platform  defined as IBM LIBERTY using explicit driver loading..loading driver now");
                this.driver = new DlgcDriver();
                DriverManager.registerDriver((Driver)this.driver);
            } else if (wp.compareToIgnoreCase(TROPO_PLATFORM) == 0) {
                log.debug("DlgcSipServlet::registerDialogic309Driver() - Application Platform  defined as TROPO using explicit driver loading..loading driver now");
                this.driver = new DlgcDriver();
                DriverManager.registerDriver((Driver)this.driver);
            } else {
                log.error("DlgcSipServlet::registerDialogic309Driver() - Application Platform unknown or not supported...");
            }
        }
    }

    public static String getASPlatform() {
        log.debug("getASPlatform... calling DlgcInstrumentPropertyMgr.getPlatformFromManifest()");
        String platform = DlgcInstrumentPropertyMgr.getPlatformFromManifest();
        if (platform == null) {
            log.warn("Environment Variable: " + "APPSERVER_PLATFORM" + " not provided");
            log.warn("Assuming OCCAS5 WEB Application Server Platform");
            platform = ORACLE_PLATFORM;
        }
        log.debug("APPSERVER_PLATFORM set to: " + platform);
        APPLICATION_PLATFORM = platform;
        return platform;
    }

    public boolean ready() throws MsControlException {
        log.debug("Entering DlgSipServlet::ready()");
        if (!this.bReady) {
            log.debug("DlgSipServlet::ready() - DlgcSipServlet not ready calling servletInitialized()");
            boolean bMonitorReady = DlgcMsMonitorServlet.instance.ready();
            if (bMonitorReady) {
                log.debug("DlgcSipServlet::ready() sucessful Monitor Servlet Initialization");
                log.debug("DlgcSipServlet::ready() calling DlgcSipServlet servletInitialized.");
                this.servletInitialized();
                log.debug("DlgcSipServlet::ready() sucessful DlgcSipServlet servletInitialized.");
            }
        } else {
            log.debug("DlgSipServlet::ready() - DlgcSipServlet  ready not need to call servletInitialized()");
        }
        log.debug("Leaving DlgSipServlet::ready() returning " + new Boolean(this.bReady).toString());
        return this.bReady;
    }

    static {
        APPLICATION_PLATFORM = null;
        DEFAULT_APP_SERVER_URI = null;
        DEFAULT_APP_SERVER_HOST = null;
        DEFAULT_APP_SERVER_PORT = "5060";
        DEFALT_APP_SERVER_TRANSPORT = null;
        log = LoggerFactory.getLogger(DlgcSipServlet.class);
    }
}

