/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.sip;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcRecorder;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXPlayer;
import com.vendor.dialogic.javax.media.mscontrol.mediagroup.DlgcXRecorder;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXSdpPortManager;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResource;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcSignalGenerator;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcXSignalDetector;
import com.vendor.dialogic.javax.media.mscontrol.signals.DlgcXSignalGenerator;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.io.Serializable;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.JoinableStream;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.resource.Resource;
import javax.servlet.sip.SipApplicationSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcSipConnectorContentIdsProxy
implements Serializable {
    private static final long serialVersionUID = 77000736282712634L;
    public DlgcProxyEnumType type;
    public String sasId;
    public String msMediaObjId;
    public String containerProxyId;
    public DlgcStreamType streamType;
    protected transient DlgcMediaSession cachedMs;
    protected transient DlgcJoinableContainer cachedContainer;
    protected transient DlgcResource<?, ?> cachedResource;
    protected transient SipApplicationSession cachedSaS;
    private static Logger log = LoggerFactory.getLogger(DlgcSipConnectorContentIdsProxy.class);

    public String toDebug() {
        String retStr = new String();
        return retStr;
    }

    public DlgcSipConnectorContentIdsProxy(DlgcJoinableContainer container, DlgcResource<?, ?> resource) {
        this.type = DlgcProxyEnumType.UNKNOWN;
        this.streamType = DlgcStreamType.NOTAPPL;
        this.cachedMs = null;
        this.cachedContainer = null;
        this.cachedResource = null;
        this.cachedSaS = null;
        if (container != null) {
            this.initContainerType(container);
        }
        if (resource != null) {
            this.initResourceType(resource);
        }
    }

    public DlgcSipConnectorContentIdsProxy(DlgcJoinableContainer container, DlgcResource<?, ?> resource, JoinableStream.StreamType t) {
        this.type = DlgcProxyEnumType.UNKNOWN;
        this.setStreamType(t);
        this.cachedMs = null;
        this.cachedContainer = null;
        this.cachedResource = null;
        this.cachedSaS = null;
        if (container != null) {
            this.initContainerType(container);
        }
        if (resource != null) {
            this.initResourceType(resource);
        }
    }

    public DlgcSipConnectorContentIdsProxy(MediaEventNotifier<? extends MediaEvent<?>> notifier) {
        this.cachedMs = null;
        this.cachedContainer = null;
        this.cachedResource = null;
        this.cachedSaS = null;
        this.streamType = DlgcStreamType.NOTAPPL;
        if (notifier != null) {
            if (notifier instanceof MediaMixer) {
                this.initContainerType((DlgcJoinableContainer)notifier);
            } else if (notifier instanceof Resource) {
                this.initResourceType((DlgcResource)notifier);
            }
        }
    }

    protected void initContainerType(DlgcJoinableContainer container) {
        this.containerProxyId = null;
        this.sasId = null;
        this.msMediaObjId = null;
        this.containerProxyId = container.getMediaObject();
        this.sasId = ((DlgcMediaSession)container.getMediaSession()).getProxyId();
        this.msMediaObjId = ((DlgcMediaSession)container.getMediaSession()).getMediaObject();
        this.type = DlgcProxyEnumType.CONTAINER;
    }

    protected void initResourceType(DlgcResource<?, ?> resource) {
        if (resource != null) {
            this.containerProxyId = ((DlgcJoinableContainer)resource.getContainer()).getMediaObject();
            this.cachedMs = (DlgcMediaSession)((DlgcJoinableContainer)resource.getContainer()).getMediaSession();
            this.msMediaObjId = this.cachedMs.getMediaObject();
            this.sasId = this.cachedMs.getProxyId();
            if (resource instanceof DlgcPlayer) {
                this.type = DlgcProxyEnumType.PLAYER;
            } else if (resource instanceof DlgcRecorder) {
                this.type = DlgcProxyEnumType.RECORDER;
            } else if (resource instanceof DlgcSignalDetector) {
                this.type = DlgcProxyEnumType.SIGDET;
            } else if (resource instanceof DlgcSignalGenerator) {
                this.type = DlgcProxyEnumType.SIGGEN;
            } else if (resource instanceof DlgcSdpPortManager) {
                this.type = DlgcProxyEnumType.SDPMGR;
            }
        }
    }

    public DlgcProxyEnumType getType() {
        return this.type;
    }

    public DlgcResource<?, ?> getResource(DlgcJoinableContainer container) {
        DlgcMediaSession myMs = (DlgcMediaSession)container.getMediaSession();
        String msType = (String)myMs.getAttribute("MSTYPE");
        if (null == msType) {
            msType = "XMS";
        }
        Class<DlgcPlayer> playerClass = DlgcPlayer.class;
        Class<DlgcRecorder> recorderClass = DlgcRecorder.class;
        Class<DlgcSignalDetector> signalDetectorClass = DlgcSignalDetector.class;
        Class<DlgcSignalGenerator> signalGenClass = DlgcSignalGenerator.class;
        Class<DlgcSdpPortManager> sdpMgrClass = DlgcSdpPortManager.class;
        if (msType.equalsIgnoreCase("XMS")) {
            playerClass = DlgcXPlayer.class;
            recorderClass = DlgcXRecorder.class;
            signalDetectorClass = DlgcXSignalDetector.class;
            signalGenClass = DlgcXSignalGenerator.class;
            sdpMgrClass = DlgcXSdpPortManager.class;
        }
        if (this.type == DlgcProxyEnumType.PLAYER) {
            try {
                this.cachedResource = container.getResource(playerClass);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        } else if (this.type == DlgcProxyEnumType.RECORDER) {
            try {
                this.cachedResource = container.getResource(recorderClass);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        } else if (this.type == DlgcProxyEnumType.SIGDET) {
            try {
                this.cachedResource = container.getResource(signalDetectorClass);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        } else if (this.type == DlgcProxyEnumType.SIGGEN) {
            try {
                this.cachedResource = container.getResource(signalGenClass);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        } else if (this.type == DlgcProxyEnumType.SDPMGR) {
            try {
                this.cachedResource = container.getResource(sdpMgrClass);
            }
            catch (MsControlException e) {
                e.printStackTrace();
            }
        }
        return this.cachedResource;
    }

    public DlgcResource<?, ?> getCachedResource() {
        return this.cachedResource;
    }

    public void Load() {
        this.getContainer();
        this.getResource(this.cachedContainer);
    }

    public SipApplicationSession getSAS() {
        this.cachedSaS = DlgcSipServlet.getSSU().getApplicationSessionById(this.sasId);
        assert (this.cachedSaS == null);
        return this.cachedSaS;
    }

    public SipApplicationSession getCachedSAS() {
        return this.cachedSaS;
    }

    public DlgcMediaSession getMediaSession() {
        this.cachedSaS = this.getSAS();
        if (this.cachedSaS != null) {
            this.cachedMs = (DlgcMediaSession)this.cachedSaS.getAttribute(this.msMediaObjId);
        }
        return this.cachedMs;
    }

    public DlgcMediaSession getCachedMediaSession() {
        return this.cachedMs;
    }

    public DlgcJoinableContainer getContainer() {
        DlgcMediaSession ms = this.getMediaSession();
        if (ms == null) {
            this.cachedContainer = null;
            log.debug("DlgcJoinableContainer::getContainer() media session found to be null... this maybe due to a previous release of the media session");
        } else {
            this.cachedContainer = (DlgcJoinableContainer)ms.getMediaObjectByProxyId(this.containerProxyId);
        }
        return this.cachedContainer;
    }

    public DlgcJoinableContainer getCachedContainer() {
        return this.cachedContainer;
    }

    public DlgcJoinableContainer getContainer(DlgcMediaSession ms) {
        return (DlgcJoinableContainer)ms.getMediaObjectByProxyId(this.containerProxyId);
    }

    public void saveMediaSession() {
        SipApplicationSession sAs = this.getSAS();
        if (sAs != null) {
            DlgcMediaSession ms = this.getMediaSession();
            log.debug("**** Saving Media Session Obj Id=" + this.msMediaObjId + " using setAttribute to SAS = " + sAs.getId());
            sAs.setAttribute(this.msMediaObjId, (Object)ms);
            log.debug("**** Saving Media Session done");
        } else {
            log.debug("****SAS found to be null cannot save Media Session");
        }
    }

    public void saveMediaSession(String name, Object obj) {
        SipApplicationSession sAs = this.getSAS();
        if (sAs != null) {
            log.debug("**** Saving any object Media Session using setAttribute *****");
            sAs.setAttribute(name, obj);
        }
    }

    public void saveCachedMediaSession() {
        this.cachedSaS.setAttribute(this.msMediaObjId, (Object)this.cachedMs);
    }

    public void setStreamType(JoinableStream.StreamType type) {
        if (type == JoinableStream.StreamType.audio) {
            this.streamType = DlgcStreamType.AUDIO;
        } else if (type == JoinableStream.StreamType.video) {
            this.streamType = DlgcStreamType.VIDEO;
        }
    }

    public JoinableStream.StreamType getStreamType() {
        if (this.streamType == DlgcStreamType.VIDEO) {
            return JoinableStream.StreamType.video;
        }
        return JoinableStream.StreamType.audio;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DlgcSipConnectorContentIdsProxy temp = (DlgcSipConnectorContentIdsProxy)obj;
        return this.containerProxyId.compareTo(temp.containerProxyId) == 0 && this.msMediaObjId.compareTo(temp.msMediaObjId) == 0 && this.sasId.compareTo(temp.sasId) == 0 && this.streamType.compareTo(temp.streamType) == 0;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.containerProxyId.hashCode() + this.msMediaObjId.hashCode() + this.sasId.hashCode() + this.streamType.hashCode());
        return result;
    }

    public static enum DlgcStreamType {
        NOTAPPL,
        AUDIO,
        VIDEO;

    }

    public static enum DlgcProxyEnumType {
        UNKNOWN,
        CONTAINER,
        PLAYER,
        RECORDER,
        SIGDET,
        SIGGEN,
        SDPMGR;

    }
}

