/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.sip;

import com.vendor.dialogic.javax.media.mscontrol.DlgcMediaSession;
import com.vendor.dialogic.javax.media.mscontrol.DlgcXMsControlFactory;
import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResource;
import com.vendor.dialogic.javax.media.mscontrol.resource.DlgcResourceContainer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIB2BUAReceiverBridge;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcInstrumentPropertyMgr;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMediaServer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMsMonitor;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSessionFactory;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipConnectorContentIdsProxy;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipMessage;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServletRequestProxy;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventNotifier;
import javax.media.mscontrol.MsControlException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DlgcSipB2BUA
implements Serializable {
    public static DlgcSessionFactory sessionFactory;
    public static final String MEDIA_TYPE_IPMS = "IPMS";
    public static final String MEDIA_TYPE_XMS = "XMS";
    private static DlgcMsMonitor msMonitor;
    private static final long serialVersionUID = 19872039484L;
    private static Logger log;
    public static Properties myProperties;
    public static DlgcInstrumentPropertyMgr instrumentPropertyMgr;
    private DlgcIB2BUAReceiverBridge receiverBridge;

    public DlgcSipB2BUA(String workManagerName) {
        this.receiverBridge = null;
    }

    public DlgcSipB2BUA() {
        this.receiverBridge = null;
    }

    public DlgcSipB2BUA(Properties properties) {
        myProperties = properties;
        this.receiverBridge = null;
        sessionFactory = new DlgcSessionFactory(properties, DlgcSipServlet.instance);
        instrumentPropertyMgr = new DlgcInstrumentPropertyMgr(properties);
        msMonitor = null;
    }

    public void setMsMonitor(DlgcMsMonitor mn) {
        log.debug("SETMSMONITOR()");
        msMonitor = mn;
    }

    public DlgcSipB2BUA(Properties properties, String workManagerName) {
        myProperties = properties;
        sessionFactory = new DlgcSessionFactory(properties, DlgcSipServlet.instance);
        instrumentPropertyMgr = new DlgcInstrumentPropertyMgr(properties);
        msMonitor = null;
    }

    public String createNoMediaSDP() {
        String sdp = null;
        DlgcMediaServer mediaServer = msMonitor.getActiveMediaServer();
        if (mediaServer != null) {
            sdp = "v=0\r\no=anonymous 0 0 IN IP4 " + mediaServer.sMediaServerIP + "\r\n" + "s=anonymous0\r\n" + "t=0 0\r\n" + "c=IN IP4 0.0.0.0\r\n" + "a=inactive\r\n";
        }
        return sdp;
    }

    public String createNoMediaSDPMSML() {
        String sdp = null;
        DlgcMediaServer mediaServer = msMonitor.getActiveMediaServer();
        if (mediaServer != null) {
            sdp = "v=0\r\no=anonymous 0 0 IN IP4 " + mediaServer.sMediaServerIP + "\r\n" + "s=anonymous0\r\n" + "t=0 0\r\n" + "m=audio 0 RTP/AVP 0\r\n" + "c=IN IP4 0.0.0.0\r\n" + "a=inactive\r\n";
        }
        return sdp;
    }

    public void scheduleTask(DlgcSipMessage message) throws MsControlException {
        this.scheduleTask(message, null);
    }

    protected DlgcIpmsSession createNewIPMSSession(DlgcMediaSession ms, DlgcJoinableContainer taskOwner, DlgcJoinableContainer master, DlgcSipMessage message) {
        DlgcIpmsSession dlgsession = null;
        String appLogId = ms.getAppCallLogId() + " - ";
        log.debug(appLogId + "Create new MS Session Entry for Master = " + master.toString() + " OBJECTID= " + master.getMediaObject());
        log.debug(appLogId + "Creating new session owner = " + taskOwner.toString() + " master =" + master.toString());
        DlgcXMsControlFactory f = (DlgcXMsControlFactory)ms.getFactory();
        boolean mediaServerUriBased = f.isMediaServerBasedOnMS_URI();
        DlgcMediaServer mediaServer = null;
        if (mediaServerUriBased) {
            mediaServer = f.getMediaServer();
            if (mediaServer != null) {
                log.debug("DlgcSipB2BUA::createNewIPMSSession: URI Mode: Media Server Object MS IP ADDRESS: " + mediaServer.sMediaServerIP + " Media Server Object Port: " + mediaServer.iMediaServerPort);
            } else {
                log.error("DlgcSipB2BUA::createNewIPMSSession: URI Mode - it seems that the mediaServer URI was not passed accordingly");
            }
        } else {
            boolean isDynamicConfig = f.isDynamicConfiguration();
            if (isDynamicConfig) {
                mediaServer = f.getMediaServer();
                log.debug("DlgcSipB2BUA::createNewIPMSSession: using Media Server based on Dynamic Configuration " + mediaServer.sMediaServerIP + ": " + mediaServer.iMediaServerPort);
            } else {
                mediaServer = msMonitor.getActiveMediaServer();
                if (mediaServer != null) {
                    log.debug("DlgcSipB2BUA::createNewIPMSSession: using Media Server Configuration as per connector property file: " + mediaServer.sMediaServerIP + ": " + mediaServer.iMediaServerPort);
                } else {
                    log.error("DlgcSipB2BUA::createNewIPMSSession: using Media Server Configuration as per connector property file: there are not active Media Server found..check the connector property file.");
                }
            }
        }
        if (mediaServer != null) {
            mediaServer.setAssociatedComponent(master);
            SipApplicationSession mySas = ms.getSAS();
            log.debug("createNewIPMSSession()::message.user: " + message.user);
            dlgsession = sessionFactory.createSession(message.user, mediaServer, mySas, taskOwner, master);
            log.debug(appLogId + "APRIL 2013 - DlgcSipServlet:createNewIPMSSession(): SASID: " + mySas.getId());
            dlgsession.setResourceContainerOwner(taskOwner);
            dlgsession.setMasterContainerOwner(master);
            dlgsession.setMediaSessionObjId(ms.getMediaObject());
            if (dlgsession != null) {
                log.debug(appLogId + "** Creating a New Session in scheduleTask method **");
                log.debug(appLogId + "***** createNewIPMSSession() calling Owner Container = " + taskOwner.toDebug() + "**********");
                log.debug(appLogId + "Associating Media Server DlgcSession with Application DlgcMediaSession");
                DlgcNetworkConnection dlgcNetworkConnection = (DlgcNetworkConnection)master;
                dlgcNetworkConnection.setDlgIpmsSession(dlgsession);
            }
            ms.setMediaServer(mediaServer);
        } else {
            log.warn(appLogId + "Could not Create IPMS Sip Session because there is no Active Media Server or not configured properly.");
        }
        return dlgsession;
    }

    protected void registerNotifier(DlgcIpmsSession dlgsession, DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier, DlgcJoinableContainer taskOwner, DlgcJoinableContainer master) {
        DlgcMediaSession ms = (DlgcMediaSession)master.getMediaSession();
        String appLogId = ms.getAppCallLogId() + " - ";
        DlgcSipConnectorContentIdsProxy reqProxyNotifier = null;
        log.debug(appLogId + "FOUND SESSION based on Master= " + master.toString() + " MediaSession... REUSING SESSION");
        log.debug(appLogId + "FOUND SESSION based on Owner = " + taskOwner.toString() + " master =" + master.toString());
        if (message.transactionID != null && notifier != null) {
            reqProxyNotifier = new DlgcSipConnectorContentIdsProxy(notifier);
            log.debug(appLogId + "Registering Media Event Notifier using transId = " + message.transactionID);
            log.debug(appLogId + "Registering Media Event Notifier using session associated to Master Container = " + master.getMediaObject());
            log.debug(appLogId + "Registering Media Event Notifier using session associated to TaskOwner Container = " + taskOwner.getMediaObject());
            String notifierId = null;
            if (DlgcSipB2BUA.getMediaServerType().compareToIgnoreCase(MEDIA_TYPE_XMS) == 0) {
                notifierId = DlgcIpmsSession.getNewNotifierId(message.transactionID, message.dialogName);
                log.debug("SEND NOTIFIER_ID= " + notifierId + " notifier = " + notifier.toString());
            } else {
                notifierId = message.transactionID;
            }
            dlgsession.addMediaEventNotifier(notifierId, reqProxyNotifier);
            if (message.dialogName.compareToIgnoreCase("EMPTY") != 0) {
                dlgsession.addActiveDialogId(notifierId, ((DlgcResource)notifier).getResourceId());
            }
        }
    }

    protected DlgcSipConnectorContentIdsProxy fillupRequestProxy(DlgcSipServletRequestProxy sipServletRequestProxy, DlgcIpmsSession dlgsession, DlgcSipMessage message, DlgcJoinableContainer master, MediaEventNotifier<? extends MediaEvent<?>> notifier) {
        DlgcSipConnectorContentIdsProxy reqMasterProxy = new DlgcSipConnectorContentIdsProxy(master, null);
        DlgcMediaSession ms = (DlgcMediaSession)master.getMediaSession();
        String appLogId = ms.getAppCallLogId() + " - ";
        if (message.method.equals("INVITE")) {
            sipServletRequestProxy.SetMasterInviteContainerInSipSessionForRequest(reqMasterProxy);
        }
        if (!message.contentType.equals("none")) {
            String subContentType;
            String contentType;
            if (message.contentType.startsWith("multipart")) {
                contentType = message.contentType;
            } else if (message.contentType.equals("mscml")) {
                log.debug(appLogId + "Message ContentType is mscml");
                subContentType = message.contentType.equals("mscml") ? "mediaservercontrol+xml" : message.contentType;
                contentType = "application/" + subContentType;
            } else {
                log.debug(appLogId + "Message ContentType is msml");
                subContentType = message.contentType.equals("msml") ? "xml" : message.contentType;
                contentType = "application/" + subContentType;
                log.debug(appLogId + "XMS fillupRequestProxy contentType =" + contentType);
            }
            sipServletRequestProxy.setContent(message.content, contentType);
        }
        sipServletRequestProxy.SetMasterContainerReqProxyResponse(reqMasterProxy);
        Set<Map.Entry<String, Object>> attrList = message.attributeMap.entrySet();
        Iterator<Map.Entry<String, Object>> iter = attrList.iterator();
        if (iter.hasNext()) {
            Map.Entry<String, Object> attr = iter.next();
            sipServletRequestProxy.setAttribute(attr.getKey(), attr.getValue());
        }
        if (message.method.equals("INFO") && message.transactionID != null) {
            if (message.useHack) {
                DlgcSipConnectorContentIdsProxy reqProxyNotiferHack = new DlgcSipConnectorContentIdsProxy(notifier);
                sipServletRequestProxy.SetResourceDtmfHackInSipSessionForRequest(reqProxyNotiferHack);
            }
            log.debug(appLogId + "fillupRequestProxy  session.getMediaEventNotifier(message.transactionID) - transactionID = " + message.transactionID);
            String notifierId = DlgcIpmsSession.getNewNotifierId(message.transactionID, message.dialogName);
            DlgcSipConnectorContentIdsProxy reqProxyNotifier = dlgsession.getMediaEventNotifier(notifierId);
            DlgcResource<?, ?> resource = null;
            if (reqProxyNotifier != null) {
                log.debug(appLogId + "PRINT DEBUG - reqProxy (Resource) not equal to null");
                reqProxyNotifier.Load();
                resource = reqProxyNotifier.getCachedResource();
            } else {
                log.debug(appLogId + "fillupRequestProxy - reqProxy (Resource) is equal to null");
            }
            if (resource != null) {
                DlgcSipConnectorContentIdsProxy reqProxyResourceResponse = new DlgcSipConnectorContentIdsProxy(null, resource);
                sipServletRequestProxy.SetResourceReqProxyResponse(reqProxyResourceResponse);
            }
        }
        return reqMasterProxy;
    }

    public void scheduleTask(DlgcSipMessage message, MediaEventNotifier<? extends MediaEvent<?>> notifier) throws MsControlException {
        Object reqProxyNotifier = null;
        DlgcJoinableContainer taskOwner = (DlgcJoinableContainer)message.owner;
        DlgcJoinableContainer master = (DlgcJoinableContainer)taskOwner.getMasterJoinable();
        boolean fLogXmit = DlgcInstrumentPropertyMgr.bScheduleTaskTracing;
        DlgcMediaSession ms = (DlgcMediaSession)taskOwner.getMediaSession();
        String appLogId = ms.getAppCallLogId() + " - ";
        log.debug(appLogId + "** ENTERING SCHEDULETASK() - Preparing SIP Request to sent to MS  **");
        log.debug(appLogId + "*15 scheduleTask(): Request Method: " + message.method + " Request owner: " + taskOwner.toString() + " master =" + master.toString() + " OBJECTID= " + master.getMediaObject());
        if (fLogXmit) {
            String payLoad = message.content;
            if (payLoad == null) {
                log.debug(appLogId + "==> scheduleTask() SIP Message to send to MS: message= EMPTY");
            } else {
                log.debug(appLogId + "==> scheduleTask() SIP Message to send to MS: WITH PAYLOAD ");
            }
        }
        if (ms == null) {
            log.error(appLogId + "taskOwner returned null DlgcMediaSession...returning");
            return;
        }
        DlgcNetworkConnection dlgcNetworkConnection = (DlgcNetworkConnection)master;
        DlgcIpmsSession dlgsession = dlgcNetworkConnection.getDlgIpmsSession();
        if (dlgsession == null) {
            dlgsession = this.createNewIPMSSession(ms, taskOwner, master, message);
            message.setJsr309CallbackResourceID(master.getMediaObject());
            message.setJsr309NotifierResourceID(master.getMediaObject());
            message.setJsr309CallbackContainerID(master.getMediaObject());
        } else {
            log.debug(appLogId + "APRIL 2013 - DlgcSipServlet:scheduleTask(): SASID: " + dlgsession.getAppSession().getId() + " SIPID: " + dlgsession.getSipSession().getId());
            this.registerNotifier(dlgsession, message, notifier, taskOwner, master);
            message.setJsr309NotifierResourceID(notifier.toString());
            message.setJsr309CallbackResourceID(((DlgcResource)notifier).getResourceId());
            DlgcResourceContainer container = (DlgcResourceContainer)((DlgcResource)notifier).getContainer();
            message.setJsr309CallbackContainerID(container.getMediaObject());
        }
        if (dlgsession == null) {
            MsControlException mex = new MsControlException("Could cont create Connection to Media Server");
            throw mex;
        }
        DlgcSipServletRequestProxy sipServletRequestProxy = dlgsession.createRequestProxy(message.method);
        this.fillupRequestProxy(sipServletRequestProxy, dlgsession, message, master, notifier);
        dlgsession.addRequest(sipServletRequestProxy);
        log.debug(appLogId + "** Sending Request to Transmitter Manager for execution **");
        this.execute(message, dlgsession);
        log.debug(appLogId + "** Request queued by Transmitter Manager returned back to scheduleTask() **");
        log.debug(appLogId + "*** LEAVING SCHEDULETASK() **");
    }

    protected void execute(DlgcSipMessage message, DlgcIpmsSession session) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendSipMessage(DlgcSipMessage sipMessage, DlgcIpmsSession session) {
        block16: {
            DlgcMediaSession ms;
            DlgcJoinableContainer owner;
            DlgcSipServletRequestProxy requestProxy;
            boolean fLogXmit;
            block15: {
                DlgcMediaServer mediaServer;
                block17: {
                    fLogXmit = DlgcInstrumentPropertyMgr.bInstrumentXmit;
                    log.debug("Entering DlgcSipB2Bua:sendSipMessage");
                    requestProxy = session.removeRequest();
                    owner = session.getResourceContainerOwner();
                    DlgcJoinableContainer master = session.getMasterContainerOwner();
                    ms = (DlgcMediaSession)master.getMediaSession();
                    DlgcMediaServer mediaServerActive = msMonitor.getActiveMediaServer();
                    mediaServer = ms.getMediaServer();
                    log.debug("*15 DlgcSipB2BUA::sendSipMessage:: DlgcIpmsSession MyID " + session.getIpmsSipSessionObjectID() + " SipSessionID: " + session.getSipSessionID());
                    log.debug("*15 DlgcSipB2BUA::sendSipMessage:: MediaSession from Master: " + ms.getAppSasId());
                    log.debug("*15 DlgcSipB2BUA::sendSipMessage:: requestProxy SASID: " + requestProxy.sessionAttrProxy.sasId);
                    log.debug("*15 DlgcSipB2BUA::sendSipMessage:: requestProxy sipAppSession: " + requestProxy.sessionAttrProxy.getSipAppSession());
                    if (mediaServerActive == null || mediaServer == null) break block17;
                    log.debug("sendSipMessage: ActiveMediaServer Id: " + new Integer(mediaServerActive.serverIndex).toString());
                    log.debug("sendSipMessage: Trying to send Request to MediaServer Id: " + new Integer(mediaServer.serverIndex).toString());
                    if (mediaServer.serverIndex == mediaServerActive.serverIndex) {
                        log.debug("sendSipMessage:: sending SIP request to MS: " + mediaServer.sMediaServerIP);
                        break block15;
                    } else if (mediaServer.is_MS_URI_DEFINED()) {
                        log.debug("sendSipMessage:: sending SIP request to MS based on MEDIA_SERVER_URI: " + mediaServer.sMediaServerIP);
                        break block15;
                    } else {
                        if (!mediaServer.dynamicConfigured) {
                            log.warn("sendSipMessage:: refuse to send MS SIP request since media server: " + mediaServer.sMediaServerIP + " is not active");
                            return;
                        }
                        log.debug("sendSipMessage:: sending SIP request to MS based on Dynamic Configuration: " + mediaServer.sMediaServerIP);
                    }
                    break block15;
                }
                if (mediaServer == null) {
                    log.warn("sendSipMessage:: refuse to send MS SIP request since media server: error getting target media server found to be null");
                    return;
                }
                if (mediaServer.is_MS_URI_DEFINED()) {
                    log.debug("sendSipMessage:: sending SIP request to MS based on MEDIA_SERVER_URI: " + mediaServer.sMediaServerIP);
                } else {
                    if (!mediaServer.dynamicConfigured) {
                        log.warn("sendSipMessage:: refuse to send MS SIP request since media server: error getting target media server found to be null");
                        return;
                    }
                    log.debug("sendSipMessage:: sending SIP request to MS based on Dynamic Configuration: " + mediaServer.sMediaServerIP);
                }
            }
            String appLogId = ms.getAppCallLogId() + " - ";
            if (requestProxy != null) {
                SipServletRequest request = session.getSipServletRequest(requestProxy, sipMessage, session);
                try {
                    if (request != null) {
                        log.info("+++++++++++++++++++++++++++++++ " + sipMessage.method + " TRANSMISSION BEGINS++++++++++++++++++++++++++++++++++++++++++");
                        log.info("JSR309:sendSipMessage() : SIP MSG OWNER Media OBJID: " + owner.getMediaObject());
                        log.info("JSR309:sendSipMessage() : JSR309 Callback Resource Unique Assigned ObjectID: " + sipMessage.getJsr309CallbackResourceID());
                        log.info("JSR309:sendSipMessage() : JSR309 Callback Resource ObjectID String: " + sipMessage.getJsr309NotifierResourceID());
                        log.info("JSR309:sendSipMessage() : JSR309 Container Resource ObjectID: " + sipMessage.getJsr309CallbackContainerID());
                        log.info("JSR309:sendSipMessage() : SIP REQUEST TO BE SENT TO XMS :" + request.toString());
                        log.info("+++++++++++++++++++++++++++++++ " + sipMessage.method + " TRANSMISSION ENDS++++++++++++++++++++++++++++++++++++++++++");
                        request.send();
                        if (fLogXmit) {
                            log.debug(appLogId + "DlgcSipB2BUA:sendSipMessage: Completed sending SIP Message to MS");
                        }
                        break block16;
                    }
                    log.warn(appLogId + "sendSipMessage cant not sent message because request could not be created. SipSession may be an invalid state.");
                }
                catch (ConnectException ce) {
                    log.warn(appLogId + "Warning cant send DlgcSipB2BUA:sendSipMessage:send(msg)");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        log.debug("Leaving DlgcSipB2Bua:sendSipMessage");
    }

    public void processSipRequest(SipServletRequest request) {
        SipSession reqSipSession = request.getSession();
        String appLogId = "APP-ID-0 - ";
        log.debug(appLogId + "Entering DlgcSipB2BUA::processSipRequest");
        log.debug("Entering processSipRequest NOT USING ASYNC QUEUE - DlgcServlet Locked Call State <= Media Server");
        DlgcReceiveRequestTask asyncTask = new DlgcReceiveRequestTask(request);
        asyncTask.run(reqSipSession.getApplicationSession());
        log.debug("Leaving processSipRequest NOT USING ASYNC QUEUE - DlgcServlet Locked Call State <= Media Server");
        log.debug(appLogId + "Leaving DlgcSipB2BUA::processSipRequest");
    }

    public void processSipRequestDoAction(SipServletRequest request) {
        SipSession reqSipSession = request.getSession();
        String appLogId = "APP-ID-0 - ";
        log.debug(appLogId + "*** Processing MS Sip Request inside DlgcSipB2BUA:processSipRequestDoAction ***");
        String theSIPID = request.getSession().getId();
        String theSASID = request.getSession().getApplicationSession().getId();
        log.debug(appLogId + "APRIL 2013 - DlgcSipServlet:processSipRequestDoAction(request): SASID: " + theSASID + " SIPID: " + theSIPID);
        this.receiverBridge.processSipRequestDoAction(request);
        log.debug(appLogId + "*** Returning from DlgcSipB2BUA:processSipRequestDoAction ***");
    }

    public void processSipResponse(SipServletResponse response) {
        SipServletRequest request = response.getRequest();
        SipSession requestSipSession = request.getSession();
        String appLogId = "APP-ID-0 - ";
        log.debug(appLogId + "Entering DlgcSipB2BUA::processSipResponse");
        log.debug("In Async Receive Mode but NOT ADDING Task processSipResponse to ASYNC QUEUE<= Media Server - using Dialogic Servlet Doxxx to Lock Call State");
        if (response.getStatus() == 408) {
            if (response.getMethod().compareToIgnoreCase("INVITE") == 0) {
                log.error("Received 408 timeout on method INVITE - Check Media Server maybe down");
            } else {
                log.error("Received 408 timeout");
            }
            DlgcReceiveResponseTask asyncTask = new DlgcReceiveResponseTask(response);
            asyncTask.run(null);
        } else {
            log.debug("Entering Calling processSipResponse NOT USING ASYNC QUEUE - Call State Locked by DlgcServlet <= Media Server");
            DlgcReceiveResponseTask asyncTask = new DlgcReceiveResponseTask(response);
            asyncTask.run(requestSipSession.getApplicationSession());
            log.debug("Leaving processSipResponse NOT USING ASYNC QUEUE - Call State Locked by DlgcServlet <= Media Server");
        }
        log.debug(appLogId + "Leaving DlgcSipB2BUA::processSipResponse");
    }

    public void processSipResponseDoAction(SipServletResponse response) {
        SipServletRequest request = response.getRequest();
        SipSession requestSipSession = request.getSession();
        if (requestSipSession != null) {
            String appLogId = "APP-ID-0 - ";
            log.debug(appLogId + "** Entering DlgcSipB2BUA:processSipResponseDoAction **");
            String theSIPID = response.getSession().getId();
            String theSASID = response.getSession().getApplicationSession().getId();
            log.debug(appLogId + "DlgcSipServlet:processSipResponseDoAction(response): SASID: " + theSASID + " SIPID: " + theSIPID);
        } else {
            log.error("DlgcSipServlet:processSipResponseDoAction(response): SipSession is NULL");
        }
        this.receiverBridge.processSipResponseDoAction(response);
        log.debug("Returning from  DlgcSipB2BUA:processSipResponseDoAction");
    }

    public void setReceiver(DlgcIB2BUAReceiverBridge rcv) {
        this.receiverBridge = rcv;
    }

    public DlgcIB2BUAReceiverBridge getReceiver() {
        return this.receiverBridge;
    }

    public static String getMediaServerType() {
        return MEDIA_TYPE_XMS;
    }

    public static boolean isMediaTypeXMS() {
        String mType = DlgcSipB2BUA.getMediaServerType();
        return mType.compareToIgnoreCase(MEDIA_TYPE_XMS) == 0;
    }

    public static boolean isMediaTypeIPMS() {
        String mType = DlgcSipB2BUA.getMediaServerType();
        return mType.compareToIgnoreCase(MEDIA_TYPE_IPMS) == 0;
    }

    public static boolean getMixerConferenceDestroy() {
        String val = myProperties.getProperty("connector.mixer.conference.destroy");
        if (val == null) {
            return false;
        }
        return val.compareToIgnoreCase("yes") == 0;
    }

    public static String getToneClampSettings() {
        return myProperties.getProperty("connector.TONE_CLAMP");
    }

    static {
        log = LoggerFactory.getLogger(DlgcSipB2BUA.class);
        myProperties = null;
    }

    protected class DlgcSipTaskNew
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String sasID;
        public String msMediaObjId;
        transient DlgcMediaSession ms;
        transient DlgcIpmsSession session;

        public DlgcSipTaskNew(DlgcSipMessage message, DlgcIpmsSession session) {
            session.setXmitMsg(message);
            this.sasID = session.getAppSession().getId();
            this.msMediaObjId = session.getMediaSessionObjId();
            this.ms = null;
            this.session = session;
        }

        public void runTask(SipApplicationSession sas) {
            log.debug("DlgcSipTaskNew runTask() do nothing");
        }

        public DlgcMediaSession getMediaSession() {
            SipApplicationSession sAs;
            if (this.ms == null && (sAs = DlgcSipServlet.getSSU().getApplicationSessionById(this.sasID)) != null) {
                this.ms = (DlgcMediaSession)sAs.getAttribute(this.msMediaObjId);
                String appLogId = this.ms.getAppCallLogId() + " - ";
                log.debug(appLogId + "**** DlgcSipTaskNew Getting Media Session ObjId: " + this.ms.getMediaObject() + " using setAttribute to SAS = " + sAs.getId());
            }
            return this.ms;
        }

        public void saveMediaSession(DlgcMediaSession ms) {
            SipApplicationSession sAs = DlgcSipServlet.getSSU().getApplicationSessionById(this.sasID);
            if (sAs != null) {
                ms = (DlgcMediaSession)sAs.getAttribute(this.msMediaObjId);
                String appLogId = ms.getAppCallLogId() + " - ";
                log.debug(appLogId + "**** DlgcSipTaskNew Saving Media Session ObjId: " + this.msMediaObjId + " using setAttribute to SAS = " + sAs.getId());
                sAs.setAttribute(this.msMediaObjId, (Object)ms);
            }
        }

        public DlgcIpmsSession getSession() {
            if (this.session == null) {
                this.getMediaSession();
                if (this.ms != null) {
                    // empty if block
                }
            }
            return this.session;
        }
    }

    protected class DlgcSipTask
    implements Serializable {
        private static final long serialVersionUID = 83719898993871L;
        protected DlgcSipMessage message;
        protected DlgcIpmsSession session;

        public DlgcSipTask(DlgcSipMessage message, DlgcIpmsSession session) {
            this.message = message;
            this.session = session;
        }

        public DlgcIpmsSession getSession() {
            return this.session;
        }

        public DlgcSipMessage getSipMessage() {
            return this.message;
        }
    }

    protected class DlgcReceiveResponseTask {
        private static final long serialVersionUID = 1L;
        SipServletResponse resp;

        public DlgcReceiveResponseTask(SipServletResponse response) {
            this.resp = response;
        }

        public void run(SipApplicationSession sas) {
            log.debug("Entering Async Receive Task run() <= Media Server");
            DlgcSipB2BUA.this.processSipResponseDoAction(this.resp);
            log.debug("Leaving Async Receive Task run() <= Media Server");
        }
    }

    protected class DlgcReceiveRequestTask {
        private static final long serialVersionUID = 1L;
        SipServletRequest req;

        public DlgcReceiveRequestTask(SipServletRequest request) {
            this.req = request;
        }

        public void run(SipApplicationSession sas) {
            log.debug("Entering Async Receive Task run() <= Media Server");
            DlgcSipB2BUA.this.processSipRequestDoAction(this.req);
            log.debug("Entering Async Receive Task run() <= Media Server");
        }
    }
}

