/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.sip;

import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcIpmsSession;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMediaServer;
import java.io.Serializable;
import java.util.Properties;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcSessionFactory
implements Serializable {
    private static final long serialVersionUID = 7357153087750996759L;
    private int jmcPort;
    private String jmcIP;
    private final String jmcUserName = "dlgjmc";
    private final String jmcDisplayName = "dlgjmc";
    private final String jmcSipAddress = "connector.sip.address";
    private final String jmcSipPort = "connector.sip.port";
    private boolean jmcSessionTimerSwitch;
    private int jmcSessionTimerMaxTimeout;
    private int jmcSessionTimerMinTimeout;
    private String sipHandler;
    private static Logger log = LoggerFactory.getLogger(DlgcSessionFactory.class);

    public DlgcSessionFactory(Properties properties, SipServlet servlet) {
        this.sipHandler = servlet.getServletName();
        if (properties == null) {
            log.debug("DlgcSessionFactory CTOR  propety file is null... defaulting to dynamic configuration");
            this.jmcIP = null;
            this.jmcPort = 5060;
            this.jmcSessionTimerSwitch = true;
            this.jmcSessionTimerMaxTimeout = 1800;
            this.jmcSessionTimerMinTimeout = 90;
        } else {
            log.debug("DlgcSessionFactory CTOR  propety file is found... defaulting to legacy property file connector configuration");
            this.jmcIP = properties.getProperty("connector.sip.address");
            this.jmcPort = Integer.valueOf(properties.getProperty("connector.sip.port"));
            String prop = properties.getProperty("mediaserver.sessionTimer.switch");
            this.jmcSessionTimerSwitch = prop == null ? true : prop.compareToIgnoreCase("on") == 0;
            prop = properties.getProperty("mediaserver.sessionTimer.maxTimeout");
            this.jmcSessionTimerMaxTimeout = prop == null ? 1800 : (prop.isEmpty() ? 1800 : Integer.valueOf(prop));
            prop = properties.getProperty("mediaserver.sessionTimer.minTimeout");
            this.jmcSessionTimerMinTimeout = prop == null ? 90 : (prop.isEmpty() ? 90 : Integer.valueOf(prop));
        }
    }

    public DlgcIpmsSession createSession(String msIp, Integer msPort, String user, String mediaServerDisplayName, SipApplicationSession sas) {
        return new DlgcIpmsSession(sas, this.sipHandler, msIp, msPort, user, mediaServerDisplayName, this.jmcIP, this.jmcPort, "dlgjmc", "dlgjmc", this.jmcSessionTimerSwitch, this.jmcSessionTimerMaxTimeout, this.jmcSessionTimerMinTimeout, null, null);
    }

    public DlgcIpmsSession createSession(String user, DlgcMediaServer mediaServer, SipApplicationSession sas, DlgcJoinableContainer owner, DlgcJoinableContainer master) {
        return new DlgcIpmsSession(sas, this.sipHandler, mediaServer.sMediaServerIP, mediaServer.iMediaServerPort, user, "MediaServer", this.jmcIP, this.jmcPort, "dlgjmc", "dlgjmc", this.jmcSessionTimerSwitch, this.jmcSessionTimerMaxTimeout, this.jmcSessionTimerMinTimeout, owner, master);
    }

    public int getJmcPort() {
        return this.jmcPort;
    }

    public void setJmcPort(int jmcPort) {
        this.jmcPort = jmcPort;
    }

    public String getJmcIP() {
        return this.jmcIP;
    }

    public void setJmcIP(String jmcIP) {
        this.jmcIP = jmcIP;
    }

    public boolean isJmcSessionTimerSwitch() {
        return this.jmcSessionTimerSwitch;
    }

    public void setJmcSessionTimerSwitch(boolean jmcSessionTimerSwitch) {
        this.jmcSessionTimerSwitch = jmcSessionTimerSwitch;
    }

    public int getJmcSessionTimerMaxTimeout() {
        return this.jmcSessionTimerMaxTimeout;
    }

    public void setJmcSessionTimerMaxTimeout(int jmcSessionTimerMaxTimeout) {
        this.jmcSessionTimerMaxTimeout = jmcSessionTimerMaxTimeout;
    }

    public int getJmcSessionTimerMinTimeout() {
        return this.jmcSessionTimerMinTimeout;
    }

    public void setJmcSessionTimerMinTimeout(int jmcSessionTimerMinTimeout) {
        this.jmcSessionTimerMinTimeout = jmcSessionTimerMinTimeout;
    }
}

