/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.sip;

import com.vendor.dialogic.javax.media.mscontrol.join.DlgcJoinableContainer;
import com.vendor.dialogic.javax.media.mscontrol.networkconnection.DlgcXNetworkConnection;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMsMonitorServlet;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcSipServlet;
import java.io.Serializable;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlgcSessionAttributeProxy
implements Serializable {
    private static final long serialVersionUID = 19207373737372389L;
    private transient SipApplicationSession sipAppSession;
    String sasId;
    String msIp;
    Integer msPort;
    String msUserName;
    String msDisplayName;
    String myMSURIString;
    String jmcIp;
    Integer jmcPort;
    String jmcUserName;
    String jmcDisplayName;
    String sipHandler;
    String sipTag;
    String dialogId;
    private static Logger log = LoggerFactory.getLogger(DlgcSessionAttributeProxy.class);
    boolean sessionTimerSwitch;
    int sessionTimerMaxTimeout;
    int sessionTimerMinTimeout;
    DlgcJoinableContainer sessionOwner;
    DlgcJoinableContainer sessionMaster;

    DlgcSessionAttributeProxy(SipApplicationSession sas, String sHandler, String lmsIp, Integer lmsPort, String user, String mediaServerDisplayName, String ljmcIP, Integer ljmcPort, String ljmcUserName, String ljmcDisplayName, boolean sstSwitch, int sstMax, int sstMin, DlgcJoinableContainer owner, DlgcJoinableContainer master) {
        this.sipAppSession = sas;
        this.sasId = sas.getId();
        this.msIp = lmsIp;
        this.msPort = lmsPort;
        this.msUserName = user;
        this.msDisplayName = mediaServerDisplayName;
        this.sessionOwner = owner;
        this.sessionMaster = master;
        this.sessionTimerSwitch = sstSwitch;
        this.sessionTimerMaxTimeout = sstMax;
        this.sessionTimerMinTimeout = sstMin;
        this.jmcIp = ljmcIP;
        this.jmcPort = ljmcPort;
        this.jmcUserName = ljmcUserName;
        this.jmcDisplayName = ljmcDisplayName;
        this.myMSURIString = null;
        this.sipHandler = sHandler;
    }

    public SipFactory factory() {
        if (this.sipHandler.equals("DlgcSipServlet")) {
            return DlgcSipServlet.getSipFactory();
        }
        if (this.sipHandler.equals("DlgcMsMonitorServlet")) {
            return DlgcMsMonitorServlet.getSipFactory();
        }
        return DlgcMsMonitorServlet.getSipFactory();
    }

    public boolean getSessionTimerSwitch() {
        return this.sessionTimerSwitch;
    }

    public int getSessionTimerMaxTimeout() {
        return this.sessionTimerMaxTimeout;
    }

    public int getSessionTimerMinTimeout() {
        return this.sessionTimerMinTimeout;
    }

    public Address getConnectorAddress(String sipMethod) {
        SipURI jmcURI = this.factory().createSipURI(this.jmcDisplayName, this.jmcIp);
        jmcURI.setPort(this.jmcPort.intValue());
        if (sipMethod.equals("INVITE")) {
            jmcURI.setUser(this.jmcUserName);
        }
        Address jmcAddress = this.factory().createAddress((URI)jmcURI);
        jmcAddress.setDisplayName(this.jmcDisplayName);
        return jmcAddress;
    }

    public Address getConnectorAddress() {
        SipURI jmcURI = this.factory().createSipURI(this.jmcDisplayName, this.jmcIp);
        jmcURI.setPort(this.jmcPort.intValue());
        Address jmcAddress = this.factory().createAddress((URI)jmcURI);
        jmcAddress.setDisplayName(this.jmcDisplayName);
        return jmcAddress;
    }

    public SipURI getConnectorURI() {
        SipURI jmcURI = this.factory().createSipURI(this.jmcDisplayName, this.jmcIp);
        jmcURI.setPort(this.jmcPort.intValue());
        jmcURI.setUser(this.jmcUserName);
        return jmcURI;
    }

    public Address getMSAddress(String sipMethod) {
        Address msAddress = null;
        SipURI msURI = null;
        if (this.myMSURIString == null) {
            msURI = this.factory().createSipURI(this.msDisplayName, this.msIp);
            msURI.setUser(this.msUserName);
            msURI.setPort(this.msPort.intValue());
            msAddress = this.factory().createAddress((URI)msURI);
            msAddress.setDisplayName(this.msDisplayName);
            if (this.sessionOwner instanceof NetworkConnection) {
                if (((DlgcXNetworkConnection)this.sessionOwner).getSdpWebRtcType()) {
                    log.debug("DlgcSessionAttributeProxy::getMSAddress: setting webrtc to yes");
                    msAddress.getURI().setParameter("webrtc", "yes");
                    log.debug("DlgcSessionAttributeProxy::getMSAddress setting msAddress:" + msAddress.getURI().toString());
                } else {
                    log.debug("DlgcSessionAttributeProxy::getMSAddress: NOT a setting URI address to webrtc=yes");
                }
                if (((DlgcXNetworkConnection)this.sessionOwner).isCpaEnabled()) {
                    log.debug("DlgcSessionAttributeProxy::getMSAddress: setting cpa to yes");
                    msAddress.getURI().setParameter("cpa", "yes");
                    log.debug("DlgcSessionAttributeProxy::getMSAddress setting msAddress:" + msAddress.getURI().toString());
                } else {
                    log.debug("DlgcSessionAttributeProxy::getMSAddress: NOT a setting URI address to cpa=yes");
                }
            }
        } else {
            try {
                msURI = (SipURI)this.factory().createURI(this.myMSURIString);
            }
            catch (ServletParseException e) {
                e.printStackTrace();
            }
            msAddress = this.factory().createAddress((URI)msURI);
        }
        return msAddress;
    }

    public Address getMSAddress() {
        SipURI msURI = this.factory().createSipURI(this.msDisplayName, this.msIp);
        msURI.setPort(this.msPort.intValue());
        Address msAddress = this.factory().createAddress((URI)msURI);
        msAddress.setDisplayName(this.msDisplayName);
        return msAddress;
    }

    public SipURI getMSURI() {
        SipURI msURI = this.factory().createSipURI(this.msDisplayName, this.msIp);
        msURI.setPort(this.msPort.intValue());
        msURI.setUser(this.msUserName);
        return msURI;
    }

    public void setMSURI(SipURI uri) {
        this.myMSURIString = uri.toString();
    }

    public SipApplicationSession getSipAppSession() {
        if (this.sipHandler.equals("DlgcSipServlet")) {
            this.sipAppSession = DlgcSipServlet.getSSU().getApplicationSessionById(this.sasId);
        } else if (this.sipHandler.equals("DlgcMsMonitorServlet")) {
            this.sipAppSession = DlgcMsMonitorServlet.getSSU().getApplicationSessionById(this.sasId);
        }
        return this.sipAppSession;
    }

    public void setSipAppSession(SipApplicationSession sas) {
        this.sipAppSession = sas;
    }

    public String getSipTag() {
        return this.sipTag;
    }

    public void setSipTag(String tag) {
        this.sipTag = tag;
    }

    public String getDialogId() {
        return this.dialogId;
    }

    public void setDialogId(String id) {
        this.dialogId = id;
    }
}

