/*
 * Decompiled with CFR 0.152.
 */
package com.vendor.dialogic.javax.media.mscontrol.sip;

import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMediaServer;
import com.vendor.dialogic.javax.media.mscontrol.sip.DlgcMsMonitor;
import com.vendor.dialogic.javax.media.mscontrol.spi.DlgcDriver;
import java.io.IOException;
import java.util.Properties;
import javax.media.mscontrol.MsControlException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionsUtil;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.TimerService;
import javax.servlet.sip.annotation.SipServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SipServlet(description="XMS Keep Alive Monitor", loadOnStartup=1)
public class DlgcMsMonitorServlet
extends javax.servlet.sip.SipServlet
implements TimerListener {
    private static final long serialVersionUID = 1L;
    public static boolean bDynamicConnectorConfiguration = false;
    private boolean bReady = false;
    public static String AppServerAddress;
    private boolean servletInitializedFlag = false;
    public static DlgcMsMonitorServlet instance;
    public static TimerService msTimerService;
    private static Logger log;
    static DlgcMsMonitor mediaServerMonitor;

    protected void doResponse(SipServletResponse resp) throws IOException, ServletException {
        SipSession ss = resp.getSession();
        SipServletResponse myResp = resp;
        DlgcMediaServer ms = (DlgcMediaServer)ss.getAttribute("MediaServerObj");
        if (ms != null) {
            ms.loadContextInfo();
            ms.processResponse(myResp);
        } else {
            log.error("doResponse could not extract DlgcMediaServer from sipSesison response");
        }
    }

    public static javax.servlet.sip.SipServlet getInstance() {
        return instance;
    }

    public static TimerService getTimerService() {
        return msTimerService;
    }

    public static SipSessionsUtil getSSU() {
        SipSessionsUtil ssu = (SipSessionsUtil)instance.getServletContext().getAttribute("javax.servlet.sip.SipSessionsUtil");
        return ssu;
    }

    public static SipSessionsUtil getSSUA() {
        SipSessionsUtil ssua = (SipSessionsUtil)instance.getServletContext().getAttribute("javax.servlet.sip.SipSessionsUtil");
        return ssua;
    }

    public void init(ServletConfig cfg) throws ServletException {
        super.init(cfg);
        instance = this;
        this.bReady = false;
        this.servletInitializedFlag = false;
        log.debug("Leaving DlgcMsMonitorServlet::init");
    }

    public void timeout(ServletTimer timer) {
        String timerID = timer.getId();
        DlgcMediaServer ms = (DlgcMediaServer)timer.getInfo();
        log.debug("Enter DlgcMsMonitorServlet:timeout() generated by timerID: " + timerID);
        if (ms == null) {
            log.warn("DlgcMsMonitorServlet::DlgcMediaServer return by retrieveMediaServer is null..returning immediately from timeout()");
            return;
        }
        log.debug("Enter DlgcMsMonitorServlet:timeout timerID: " + timerID + " For Media Server: " + ms.sMediaServerIP);
        ms.loadContextInfo();
        ms.processTimeout(timer);
        log.debug("DlgcMsMonitorServlet::timeout::Returning from ms.processTimeout() for timerID: " + timerID + " For Media Server: " + ms.sMediaServerIP);
    }

    public static SipFactory getSipFactory() {
        ServletConfig scfg = instance.getServletConfig();
        ServletContext ctx = scfg.getServletContext();
        SipFactory factory = (SipFactory)ctx.getAttribute("javax.servlet.sip.SipFactory");
        return factory;
    }

    public void servletInitialized() {
        if (!this.servletInitializedFlag) {
            this.servletInitializedFlag = true;
            this.bReady = true;
            msTimerService = (TimerService)this.getServletContext().getAttribute("javax.servlet.sip.TimerService");
            log.debug("DlgcMsMonitorServlet:: Initializing DlgcMsMonitor Object");
            try {
                Properties properties = DlgcDriver.LoadProperties(((Object)((Object)this)).getClass());
                if (properties == null) {
                    log.debug("DlgcMsMonitorServlet::servletInitalized  can't find connector property file... defaulting to dynamic configuration");
                    bDynamicConnectorConfiguration = true;
                    mediaServerMonitor = new DlgcMsMonitor(properties, this);
                    this.getServletContext().setAttribute("DlgcMsMonitor", (Object)mediaServerMonitor);
                } else {
                    log.debug("DlgcMsMonitorServlet::servletInitalized  found connector property file... using legacy connector property file.");
                    bDynamicConnectorConfiguration = false;
                    AppServerAddress = properties.getProperty("connector.sip.address");
                    log.debug("Application Server IP Address: " + AppServerAddress);
                    mediaServerMonitor = new DlgcMsMonitor(properties, this);
                    this.getServletContext().setAttribute("DlgcMsMonitor", (Object)mediaServerMonitor);
                }
            }
            catch (Exception e) {
                log.debug("Exception creating DlgcMsMonitor: " + e);
                e.printStackTrace();
            }
            log.debug("Leaving DlgcMsMonitorServlet::servletInitialized");
            if (bDynamicConnectorConfiguration) {
                log.debug("Since connector is in dynamic configuration mode... not calling mediaServerMonitor.startMediaServers()");
            } else {
                log.debug("Since connector is in legacy property configuration file mode... calling mediaServerMonitor.startMediaServers()");
                mediaServerMonitor.startMediaServers();
            }
        }
    }

    public boolean ready() throws MsControlException {
        log.debug("Entering DlgcMsMonitorServlet::ready()");
        if (!this.bReady) {
            log.debug("DlgcMsMonitorServlet::ready() - DlgcMsMonitorServlet not ready calling servletInitialized()");
            this.servletInitialized();
        } else {
            log.debug("DlgcMsMonitorServlet::ready() - DlgcMsMonitorServlet  ready not need to call servletInitialized()");
        }
        log.debug("Leaving DlgcMsMonitorServlet::ready() returning " + new Boolean(this.bReady).toString());
        return this.bReady;
    }

    static {
        log = LoggerFactory.getLogger(DlgcMsMonitorServlet.class);
    }
}

